/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.mq.http.model;

import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;

public abstract class BaseMessage {
    private String requestId = null;
    private String messageId = null;
    private String messageBodyMD5 = null;
    private byte[] messageBodyBytes = null;
    private Map<String, String> properties = new HashMap<String, String>(4);

    public String getRequestId() {
        return this.requestId;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public String getMessageId() {
        return this.messageId;
    }

    public void setMessageId(String messageId) {
        this.messageId = messageId;
    }

    public String getMessageBodyMD5() {
        return this.messageBodyMD5;
    }

    public void setMessageBodyMD5(String messageBodyMD5) {
        this.messageBodyMD5 = messageBodyMD5;
    }

    public void setMessageBody(byte[] messageBodyBytes) {
        this.messageBodyBytes = messageBodyBytes;
    }

    public byte[] getMessageBodyBytes() {
        return this.messageBodyBytes;
    }

    public String getMessageBodyString() {
        byte[] messageBodyAsBytes = this.getMessageBodyBytes();
        if (messageBodyAsBytes == null) {
            return null;
        }
        try {
            return new String(messageBodyAsBytes, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Not support encoding: UTF-8");
        }
    }

    public void setMessageBody(String messageBody) throws UnsupportedEncodingException {
        this.setMessageBody(messageBody.getBytes("UTF-8"));
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.messageId != null) {
            sb.append("MessageID:" + this.messageId + ",");
        }
        if (this.messageBodyMD5 != null) {
            sb.append("MessageMD5:" + this.messageBodyMD5 + ",");
        }
        if (this.requestId != null) {
            sb.append("RequestID:" + this.requestId + ",");
        }
        if (this.properties != null && !this.properties.isEmpty()) {
            sb.append("Properties:" + this.properties);
        }
        return sb.toString();
    }
}

