/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.mq.http.common.utils;

import java.net.URI;
import java.net.URISyntaxException;
import org.apache.log4j.Logger;

public class Utils {
    public static Logger logger = Logger.getLogger(Utils.class);

    public static URI getHttpURI(String endpoint) {
        if (endpoint == null) {
            logger.warn((Object)"Endpoint is null");
            throw new NullPointerException("Endpoint is null");
        }
        try {
            if (!endpoint.startsWith("http://") && !endpoint.startsWith("https://")) {
                logger.warn((Object)"Only support http or https protocol\u3002Endpoint must be started by http:// or https://.");
                throw new IllegalArgumentException("Only support http or https protocol\u3002Endpoint must be started by http:// or https://.");
            }
            while (endpoint.endsWith("/")) {
                endpoint = endpoint.substring(0, endpoint.length() - 1);
            }
            if (endpoint.length() < "http://".length()) {
                logger.warn((Object)"Invalid endpoint.");
                throw new IllegalArgumentException("Invalid endpoint.");
            }
            return new URI(endpoint);
        }
        catch (URISyntaxException e) {
            logger.warn((Object)"uri syntax error");
            throw new IllegalArgumentException(e);
        }
    }
}

