/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.mq.http.common.http;

import com.aliyun.mq.http.common.ClientException;
import com.aliyun.mq.http.common.comm.ExecutionContext;
import com.aliyun.mq.http.common.comm.RetryStrategy;
import com.aliyun.mq.http.common.http.ClientConfiguration;
import com.aliyun.mq.http.common.http.HttpCallback;
import com.aliyun.mq.http.common.http.HttpFactory;
import com.aliyun.mq.http.common.http.RequestMessage;
import com.aliyun.mq.http.common.http.ResponseMessage;
import com.aliyun.mq.http.common.http.ServiceClient;
import java.io.IOException;
import java.util.TimerTask;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.impl.nio.conn.PoolingNHttpClientConnectionManager;
import org.apache.http.nio.client.HttpAsyncClient;
import org.apache.http.nio.conn.NHttpClientConnectionManager;

public class DefaultServiceClient
extends ServiceClient {
    AtomicBoolean clientIsOpen = new AtomicBoolean(false);
    private HttpAsyncClient httpClient;
    private PoolingNHttpClientConnectionManager connManager;
    private AtomicInteger refCount = new AtomicInteger(0);
    private ScheduledExecutorService timer = new ScheduledThreadPoolExecutor(1, new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            return new Thread(r, "CheckApacheClientTimer");
        }
    });

    DefaultServiceClient(ClientConfiguration config) {
        super(config);
        this.connManager = HttpFactory.createConnectionManager(config);
        this.httpClient = HttpFactory.createHttpAsyncClient(this.connManager, config);
        this.ref();
    }

    @Override
    int ref() {
        this.open();
        return this.refCount.incrementAndGet();
    }

    @Override
    int unRef() {
        if (this.refCount.decrementAndGet() <= 0) {
            this.close();
        }
        return this.refCount.get();
    }

    @Override
    public <T> Future<HttpResponse> sendRequestCore(ServiceClient.Request request, ExecutionContext context, HttpCallback<T> callback) throws IOException {
        assert (request != null && context != null);
        if (!this.isOpen()) {
            throw new IOException("Http selector is not running, try it again after 3s.");
        }
        HttpRequestBase httpRequest = HttpFactory.createHttpRequest(request, context);
        return this.httpClient.execute((HttpUriRequest)httpRequest, callback);
    }

    private void open() {
        if (this.httpClient != null && this.httpClient instanceof CloseableHttpAsyncClient && this.clientIsOpen.compareAndSet(false, true)) {
            ((CloseableHttpAsyncClient)this.httpClient).start();
            HttpFactory.IdleConnectionMonitor.getInstance().addConnMgr((NHttpClientConnectionManager)this.connManager);
        }
        this.timer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                block5: {
                    try {
                        if (DefaultServiceClient.this.refCount.get() <= 0 || !DefaultServiceClient.this.clientIsOpen.get() || DefaultServiceClient.this.isSelectorOk()) break block5;
                        try {
                            DefaultServiceClient.this.connManager.shutdown();
                            if (DefaultServiceClient.this.httpClient instanceof CloseableHttpAsyncClient) {
                                ((CloseableHttpAsyncClient)DefaultServiceClient.this.httpClient).close();
                            }
                            HttpFactory.IdleConnectionMonitor.getInstance().removeConnMgr((NHttpClientConnectionManager)DefaultServiceClient.this.connManager);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        DefaultServiceClient.this.connManager = HttpFactory.createConnectionManager(DefaultServiceClient.this.getClientConfigurationNoClone());
                        DefaultServiceClient.this.httpClient = (HttpAsyncClient)HttpFactory.createHttpAsyncClient(DefaultServiceClient.this.connManager, DefaultServiceClient.this.getClientConfigurationNoClone());
                        ((CloseableHttpAsyncClient)DefaultServiceClient.this.httpClient).start();
                        HttpFactory.IdleConnectionMonitor.getInstance().addConnMgr((NHttpClientConnectionManager)DefaultServiceClient.this.connManager);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
        }, 10000L, 3000L, TimeUnit.MILLISECONDS);
    }

    @Override
    public boolean isOpen() {
        return this.clientIsOpen.get() && this.isSelectorOk();
    }

    @Override
    protected boolean isSelectorOk() {
        if (this.httpClient instanceof CloseableHttpAsyncClient) {
            return ((CloseableHttpAsyncClient)this.httpClient).isRunning();
        }
        return true;
    }

    @Override
    protected void close() {
        HttpFactory.IdleConnectionMonitor.getInstance().removeConnMgr((NHttpClientConnectionManager)this.connManager);
        if (this.httpClient != null && this.httpClient instanceof CloseableHttpAsyncClient && this.clientIsOpen.compareAndSet(true, false)) {
            try {
                ((CloseableHttpAsyncClient)this.httpClient).close();
                this.timer.shutdownNow();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    protected RetryStrategy getDefaultRetryStrategy() {
        return new DefaultRetryStrategy();
    }

    private static class DefaultRetryStrategy
    extends RetryStrategy {
        private DefaultRetryStrategy() {
        }

        @Override
        public boolean shouldRetry(Exception ex, RequestMessage request, ResponseMessage response, int retries) {
            int statusCode;
            String errorCode;
            if (ex instanceof ClientException && ((errorCode = ((ClientException)ex).getErrorCode()).equals("ConnectionTimeout") || errorCode.equals("SocketTimeout"))) {
                return true;
            }
            return response != null && ((statusCode = response.getStatusCode()) == 500 || statusCode == 503);
        }
    }
}

