/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.mq.http;

import com.aliyun.mq.http.MQProducer;
import com.aliyun.mq.http.common.ClientException;
import com.aliyun.mq.http.common.ServiceException;
import com.aliyun.mq.http.common.auth.ServiceCredentials;
import com.aliyun.mq.http.common.http.ServiceClient;
import com.aliyun.mq.http.model.AsyncCallback;
import com.aliyun.mq.http.model.AsyncResult;
import com.aliyun.mq.http.model.Message;
import com.aliyun.mq.http.model.action.AckMessageAction;
import com.aliyun.mq.http.model.action.ConsumeMessageAction;
import com.aliyun.mq.http.model.request.AckMessageRequest;
import com.aliyun.mq.http.model.request.ConsumeMessageRequest;
import java.net.URI;
import java.util.Arrays;
import java.util.List;

public class MQTransProducer
extends MQProducer {
    protected final String groupId;

    protected MQTransProducer(String instanceId, String topicName, String groupId, ServiceClient client, ServiceCredentials credentials, URI endpoint) {
        super(instanceId, topicName, client, credentials, endpoint);
        this.groupId = groupId;
    }

    public List<Message> consumeHalfMessage(int num, int pollingSecond) throws ServiceException, ClientException {
        ConsumeMessageRequest request = new ConsumeMessageRequest();
        request.setBatchSize(num);
        request.setWaitSeconds(pollingSecond);
        request.setInstanceId(this.instanceId);
        request.setConsumer(this.groupId);
        request.setTrans("pop");
        try {
            ConsumeMessageAction action = new ConsumeMessageAction(this.serviceClient, this.credentials, this.endpoint);
            request.setRequestPath(this.topicURL + "/" + "messages");
            return (List)action.executeWithCustomHeaders(request, null);
        }
        catch (ServiceException e) {
            if ("MessageNotExist".equals(e.getErrorCode())) {
                return null;
            }
            throw e;
        }
    }

    public AsyncResult<List<Message>> asyncConsumeHalfMessage(int num, int pollingSecond, AsyncCallback<List<Message>> callback) {
        ConsumeMessageRequest request = new ConsumeMessageRequest();
        request.setBatchSize(num);
        request.setWaitSeconds(pollingSecond);
        request.setInstanceId(this.instanceId);
        request.setConsumer(this.groupId);
        request.setTrans("pop");
        ConsumeMessageAction action = new ConsumeMessageAction(this.serviceClient, this.credentials, this.endpoint);
        request.setRequestPath(this.topicURL + "/" + "messages");
        return action.executeWithCustomHeaders(request, callback, null);
    }

    public void commit(String handle) throws ServiceException, ClientException {
        AckMessageAction action = new AckMessageAction(this.serviceClient, this.credentials, this.endpoint);
        AckMessageRequest request = new AckMessageRequest();
        request.setRequestPath(this.topicURL + "/" + "messages");
        request.setReceiptHandles(Arrays.asList(handle));
        request.setInstanceId(this.instanceId);
        request.setConsumer(this.groupId);
        request.setTrans("commit");
        action.executeWithCustomHeaders(request, null);
    }

    public void rollback(String handle) throws ServiceException, ClientException {
        AckMessageAction action = new AckMessageAction(this.serviceClient, this.credentials, this.endpoint);
        AckMessageRequest request = new AckMessageRequest();
        request.setRequestPath(this.topicURL + "/" + "messages");
        request.setReceiptHandles(Arrays.asList(handle));
        request.setInstanceId(this.instanceId);
        request.setConsumer(this.groupId);
        request.setTrans("rollback");
        action.executeWithCustomHeaders(request, null);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("MQTransProducer{");
        sb.append("topicName='").append(this.topicName).append('\'');
        sb.append("groupId='").append(this.groupId).append('\'');
        sb.append(", endpoint=").append(this.endpoint);
        sb.append(", instanceId='").append(this.instanceId).append('\'');
        sb.append('}');
        return sb.toString();
    }
}

