/*
 * Decompiled with CFR 0.152.
 */
package yangcai.messagebox.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.io.Serializable;

@JsonIgnoreProperties(ignoreUnknown=true)
public class MessageResult<T>
implements Serializable {
    private static final long serialVersionUID = 7388794056203745199L;
    private Integer code;
    private String msg;
    private T data;

    public MessageResult(Integer code, String msg, T data) {
        this.code = code;
        this.msg = msg;
        this.data = data;
    }

    public static <T> MessageResult<T> succeed(String msg) {
        return MessageResult.succeed(null, CodeEnum.SUCCESS.getCode(), msg);
    }

    public static <T> MessageResult<T> succeed(T model, String msg) {
        return MessageResult.succeed(model, CodeEnum.SUCCESS.getCode(), msg);
    }

    public static <T> MessageResult<T> succeed(T data, Integer code, String msg) {
        return new MessageResult<T>(code, msg, data);
    }

    public static <T> MessageResult<T> failed(String msg) {
        return MessageResult.failed(null, CodeEnum.ERROR.getCode(), msg);
    }

    public static <T> MessageResult<T> failed(T model, String msg) {
        return MessageResult.failed(model, CodeEnum.ERROR.getCode(), msg);
    }

    public static <T> MessageResult<T> failed(T data, Integer code, String msg) {
        return new MessageResult<T>(code, msg, data);
    }

    public Integer getCode() {
        return this.code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getMsg() {
        return this.msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public T getData() {
        return this.data;
    }

    public void setData(T data) {
        this.data = data;
    }

    public static enum CodeEnum {
        SUCCESS(0),
        ERROR(1);

        private Integer code;

        private CodeEnum(Integer code) {
            this.code = code;
        }

        public Integer getCode() {
            return this.code;
        }

        public void setCode(Integer code) {
            this.code = code;
        }
    }
}

