/*
 * Decompiled with CFR 0.152.
 */
package yangcai.messagebox.handler;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshakerFactory;
import io.netty.handler.timeout.IdleStateEvent;
import io.netty.util.CharsetUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import yangcai.messagebox.config.MessageBoxConfig;
import yangcai.messagebox.model.LoginUser;
import yangcai.messagebox.util.MessageUtil;
import yangcai.messagebox.util.TokenUtil;

@Component
public class MessageChannelHandler
extends SimpleChannelInboundHandler<TextWebSocketFrame> {
    private static final Log log = LogFactory.getLog(MessageChannelHandler.class);
    private static final String URI = "/ws";
    private static MessageBoxConfig config;
    private WebSocketServerHandshaker handshaker;

    private static void sendHttpResponse(ChannelHandlerContext ctx, FullHttpRequest req, DefaultFullHttpResponse res) {
        if (res.status().code() != 200) {
            ByteBuf buf = Unpooled.copiedBuffer((CharSequence)res.status().toString(), (Charset)CharsetUtil.UTF_8);
            res.content().writeBytes(buf);
            buf.release();
        }
        ChannelFuture f = ctx.channel().writeAndFlush((Object)res);
        if (!HttpUtil.isKeepAlive((HttpMessage)req) || res.status().code() != 200) {
            f.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
    }

    private static Map getUrlParams(String url) {
        String semicolon = ";";
        HashMap<String, String> map = new HashMap<String, String>(5);
        if (!(url = url.replace("?", ";")).contains(";")) {
            return map;
        }
        if (url.split(";").length > 0) {
            String[] arr;
            for (String s : arr = url.split(";")[1].split("&")) {
                String key = s.split("=")[0];
                String value = s.split("=")[1];
                map.put(key, value);
            }
            return map;
        }
        return map;
    }

    @Autowired
    public void setMessageBoxConfig(MessageBoxConfig config) {
        MessageChannelHandler.config = config;
    }

    public void channelActive(ChannelHandlerContext ctx) {
        log.debug((Object)"\u4e0e\u5ba2\u6237\u7aef\u5efa\u7acb\u8fde\u63a5\uff0c\u901a\u9053\u5f00\u542f\uff01");
    }

    public void channelInactive(ChannelHandlerContext ctx) {
        log.debug((Object)"\u4e0e\u5ba2\u6237\u7aef\u65ad\u5f00\u8fde\u63a5\uff0c\u901a\u9053\u5173\u95ed\uff01");
        MessageUtil.removeChannelsById(ctx.channel());
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        log.debug((Object)"--------testppp----------");
        log.debug((Object)("msg:" + msg.toString()));
        if (null != msg && msg instanceof FullHttpRequest) {
            log.debug((Object)"msg instanceof FullHttpRequest");
            FullHttpRequest request = (FullHttpRequest)msg;
            String uri = request.uri();
            log.debug((Object)("uri:" + uri));
            Map paramMap = null;
            paramMap = null != uri && uri.startsWith(URI) && uri.contains("?") ? MessageChannelHandler.getUrlParams(uri) : new HashMap();
            log.debug((Object)("paramMap:" + paramMap));
            int userType = Integer.valueOf((String)paramMap.get("userType"));
            String userId = (String)paramMap.get("userId");
            log.debug((Object)("userType:" + userType + ":userId:" + userId));
            if (paramMap == null || userId == null || userId.isEmpty()) {
                ctx.close();
                log.debug((Object)"ctx.close()");
            } else {
                try {
                    MessageUtil.putUserChannel(config.getSysCode(), userType, userId, ctx.channel());
                }
                catch (Exception e) {
                    log.debug((Object)("MessageUtil.putUserChannel error:" + e));
                    ctx.close();
                    e.printStackTrace();
                }
                request.setUri(URI);
            }
            this.doHandlerHttpRequest(ctx, (HttpRequest)msg);
        } else if (msg instanceof WebSocketFrame) {
            log.debug((Object)"msg instanceof WebSocketFrame");
            this.doHandlerWebSocketFrame(ctx, (WebSocketFrame)msg);
        }
    }

    protected void channelRead0(ChannelHandlerContext channelHandlerContext, TextWebSocketFrame textWebSocketFrame) {
    }

    private void doHandlerHttpRequest(ChannelHandlerContext ctx, HttpRequest msg) {
        String uri;
        log.debug((Object)"\u7b2c\u4e00\u6b21\u8fde\u63a5\u63e1\u624b:");
        if (!msg.decoderResult().isSuccess() || !"websocket".equals(msg.headers().get("Upgrade"))) {
            MessageChannelHandler.sendHttpResponse(ctx, (FullHttpRequest)msg, new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.BAD_REQUEST));
        }
        if (!(uri = msg.uri()).startsWith(URI)) {
            ctx.close();
        }
        String host = msg.headers().get("Host");
        log.debug((Object)("host:" + host + "ws://" + msg.headers().get("Host") + URI + ""));
        WebSocketServerHandshakerFactory factory = null;
        factory = null != host && host.indexOf("192.168.") > -1 ? new WebSocketServerHandshakerFactory("ws://" + msg.headers().get("Host") + URI + "", null, false) : new WebSocketServerHandshakerFactory("wss://" + msg.headers().get("Host") + URI + "", null, false);
        this.handshaker = factory.newHandshaker(msg);
        if (this.handshaker == null) {
            WebSocketServerHandshakerFactory.sendUnsupportedVersionResponse((Channel)ctx.channel());
            return;
        }
        this.handshaker.handshake(ctx.channel(), (FullHttpRequest)msg);
        log.debug((Object)"\u7b2c\u4e00\u6b21\u8fde\u63a5\u63e1\u624bok:");
        try {
            CloseableHttpClient httpclient = HttpClients.createDefault();
            LoginUser loginUser = MessageUtil.getUserByChannelId(ctx.channel().id());
            HttpGet get = new HttpGet(config.getBusiAddress() + "queryUnReadMessageListWhenLogin?consumerPlatformType=" + loginUser.getSysCode() + "&consumerOperateType=" + loginUser.getUserType() + "&consumerOperateCode=" + loginUser.getUserId());
            get.setHeader("Authorization", "bearer " + TokenUtil.getAccessToken());
            CloseableHttpResponse resultRep = httpclient.execute((HttpUriRequest)get);
            int statusCode = resultRep.getStatusLine().getStatusCode();
            log.debug((Object)resultRep);
            if (statusCode == 200) {
                JSONArray array = new JSONArray();
                JSONObject obj = JSONObject.parseObject((String)EntityUtils.toString((HttpEntity)resultRep.getEntity()));
                array.add((Object)obj);
                ctx.channel().writeAndFlush((Object)new TextWebSocketFrame(array.toJSONString()));
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private void doHandlerWebSocketFrame(ChannelHandlerContext ctx, WebSocketFrame msg) {
        log.debug((Object)"websocket\u6d88\u606f\u5904\u7406:");
        if (msg instanceof CloseWebSocketFrame) {
            this.handshaker.close(ctx.channel(), (CloseWebSocketFrame)msg.retain());
            return;
        }
        if (msg instanceof PingWebSocketFrame) {
            PongWebSocketFrame pong = new PongWebSocketFrame(msg.content().retain());
            ctx.channel().writeAndFlush((Object)pong);
            return;
        }
        if (msg instanceof PongWebSocketFrame) {
            return;
        }
        if (!(msg instanceof TextWebSocketFrame)) {
            throw new UnsupportedOperationException("\u4e0d\u652f\u6301\u4e8c\u8fdb\u5236");
        }
        if (msg instanceof TextWebSocketFrame) {
            String pingStr = "ping";
            String readStr = "read";
            String messageBusi = ((TextWebSocketFrame)msg).text();
            if ("ping".equals(messageBusi)) {
                PongWebSocketFrame pong = new PongWebSocketFrame(msg.content().retain());
                ctx.channel().writeAndFlush((Object)pong);
            }
        }
        log.debug((Object)("websocket\u6d88\u606f\u5904\u7406ok:" + ctx.toString() + "msg:" + msg.toString()));
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
        log.debug((Object)"--------userEventTriggered----------");
        if (evt instanceof IdleStateEvent) {
            IdleStateEvent stateEvent = (IdleStateEvent)evt;
            PingWebSocketFrame ping = new PingWebSocketFrame();
            log.debug((Object)("--------stateEvent.state()----------" + stateEvent.state()));
            switch (stateEvent.state()) {
                case READER_IDLE: {
                    break;
                }
                case WRITER_IDLE: {
                    ctx.close();
                    break;
                }
                case ALL_IDLE: {
                    ctx.close();
                }
            }
        }
    }
}

