/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.imageoptions;

import com.aspose.imaging.Color;
import com.aspose.imaging.ColorPalette;
import com.aspose.imaging.IColorPalette;
import com.aspose.imaging.ImageOptionsBase;
import com.aspose.imaging.ResolutionSetting;
import com.aspose.imaging.Source;
import com.aspose.imaging.coreexceptions.imageformats.TiffImageException;
import com.aspose.imaging.fileformats.tiff.TiffDataType;
import com.aspose.imaging.fileformats.tiff.TiffExifIfd;
import com.aspose.imaging.fileformats.tiff.TiffRational;
import com.aspose.imaging.fileformats.tiff.enums.TiffAlphaStorage;
import com.aspose.imaging.fileformats.tiff.enums.TiffCompressions;
import com.aspose.imaging.fileformats.tiff.enums.TiffFillOrders;
import com.aspose.imaging.fileformats.tiff.enums.TiffNewSubFileTypes;
import com.aspose.imaging.fileformats.tiff.enums.TiffOrientations;
import com.aspose.imaging.fileformats.tiff.enums.TiffPhotometrics;
import com.aspose.imaging.fileformats.tiff.enums.TiffPlanarConfigs;
import com.aspose.imaging.fileformats.tiff.enums.TiffPredictor;
import com.aspose.imaging.fileformats.tiff.enums.TiffResolutionUnits;
import com.aspose.imaging.fileformats.tiff.enums.TiffThresholds;
import com.aspose.imaging.fileformats.tiff.instancefactory.ITiffTagCreator;
import com.aspose.imaging.fileformats.tiff.tifftagtypes.TiffASCIIType;
import com.aspose.imaging.fileformats.tiff.tifftagtypes.TiffByteType;
import com.aspose.imaging.fileformats.tiff.tifftagtypes.TiffIfdType;
import com.aspose.imaging.fileformats.tiff.tifftagtypes.TiffLong8Type;
import com.aspose.imaging.fileformats.tiff.tifftagtypes.TiffLongType;
import com.aspose.imaging.fileformats.tiff.tifftagtypes.TiffRationalType;
import com.aspose.imaging.fileformats.tiff.tifftagtypes.TiffShortType;
import com.aspose.imaging.fileformats.tiff.tifftagtypes.TiffUnknownType;
import com.aspose.imaging.imageoptions.MultiPageOptions;
import com.aspose.imaging.imageoptions.VectorRasterizationOptions;
import com.aspose.imaging.internal.Exceptions.ArgumentNullException;
import com.aspose.imaging.internal.Exceptions.ArgumentOutOfRangeException;
import com.aspose.imaging.internal.hO.h;
import com.aspose.imaging.internal.hO.o;
import com.aspose.imaging.internal.iR.b;
import com.aspose.imaging.internal.iR.c;
import com.aspose.imaging.internal.iR.d;
import com.aspose.imaging.internal.iR.e;
import com.aspose.imaging.internal.iR.f;
import com.aspose.imaging.internal.lo.a;
import com.aspose.imaging.internal.lt.g;
import com.aspose.imaging.internal.lu.i;
import com.aspose.imaging.internal.lz.I;
import com.aspose.imaging.internal.lz.aV;
import com.aspose.imaging.internal.lz.bC;
import com.aspose.imaging.internal.lz.bc;
import com.aspose.imaging.internal.mm.l;
import com.aspose.imaging.system.Enum;
import com.aspose.imaging.system.collections.Generic.IGenericEnumerable;
import com.aspose.imaging.system.collections.Generic.List;
import com.aspose.imaging.system.io.MemoryStream;
import com.aspose.imaging.xmp.XmpPacketWrapper;
import java.lang.reflect.Array;
import java.util.Arrays;

public class TiffOptions
extends ImageOptionsBase {
    private final i<TiffDataType> a = new i();
    private final List<TiffDataType> b = new List();
    private final i<long[]> c = new i();
    private int d = 18761;
    private boolean e;
    private boolean f = false;
    private final Color g = Color.getWhite();
    private int h = 0x6400000;
    private int i = 1;
    private boolean j = false;
    private int k;
    private boolean l = false;

    public TiffOptions(int n2, int n3) {
        this.setPhotometric(0);
        switch (n2) {
            case 13: {
                this.setCompression(2);
                break;
            }
            case 6: {
                this.setCompression(3);
                break;
            }
            case 7: {
                this.setCompression(4);
                break;
            }
            case 8: {
                this.setCompression(8);
                break;
            }
            case 9: {
                this.setCompression(8);
                this.setPhotometric(2);
                this.setBitsPerSample(new int[]{8, 8, 8});
                break;
            }
            case 10: {
                this.setCompression(8);
                this.setPhotometric(2);
                this.setBitsPerSample(new int[]{8, 8, 8, 8});
                this.setAlphaStorage(2);
                break;
            }
            case 11: {
                this.setCompression(8);
                this.setPhotometric(5);
                this.setBitsPerSample(new int[]{8, 8, 8, 8});
                break;
            }
            case 12: {
                this.setCompression(8);
                this.setPhotometric(5);
                this.setBitsPerSample(new int[]{8, 8, 8, 8, 8});
                this.setAlphaStorage(2);
                break;
            }
            case 14: {
                this.setCompression(7);
                this.setPhotometric(2);
                this.setBitsPerSample(new int[]{8, 8, 8});
                break;
            }
            case 15: {
                this.setCompression(7);
                this.setPhotometric(6);
                this.setBitsPerSample(new int[]{8, 8, 8});
                break;
            }
            case 1: {
                this.setCompression(5);
                break;
            }
            case 2: {
                this.setCompression(5);
                this.setPhotometric(2);
                this.setBitsPerSample(new int[]{8, 8, 8});
                break;
            }
            case 3: {
                this.setCompression(5);
                this.setPhotometric(2);
                this.setBitsPerSample(new int[]{8, 8, 8, 8});
                this.setAlphaStorage(2);
                break;
            }
            case 4: {
                this.setCompression(5);
                this.setPhotometric(5);
                this.setBitsPerSample(new int[]{8, 8, 8, 8});
                break;
            }
            case 5: {
                this.setCompression(5);
                this.setPhotometric(5);
                this.setBitsPerSample(new int[]{8, 8, 8, 8, 8});
                this.setAlphaStorage(2);
                break;
            }
            case 17: {
                this.setPhotometric(2);
                this.setBitsPerSample(new int[]{8, 8, 8});
                break;
            }
            case 18: {
                this.setPhotometric(2);
                this.setBitsPerSample(new int[]{8, 8, 8, 8});
                this.setAlphaStorage(2);
                break;
            }
            case 19: {
                this.setPhotometric(5);
                this.setBitsPerSample(new int[]{8, 8, 8, 8});
                break;
            }
            case 20: {
                this.setPhotometric(5);
                this.setBitsPerSample(new int[]{8, 8, 8, 8, 8});
                this.setAlphaStorage(2);
                break;
            }
        }
        this.d = n3;
        this.setCompressedQuality(75);
    }

    public TiffOptions(int n2) {
        this(n2, 18761);
    }

    public TiffOptions(TiffOptions tiffOptions) {
        super(tiffOptions);
        MultiPageOptions multiPageOptions;
        VectorRasterizationOptions vectorRasterizationOptions;
        ResolutionSetting resolutionSetting;
        if (!tiffOptions.b.isEmpty()) {
            this.a(tiffOptions.b);
        }
        this.d = tiffOptions.d;
        this.e = tiffOptions.e;
        this.f = tiffOptions.f;
        tiffOptions.g.CloneTo(this.g);
        this.h = tiffOptions.h;
        this.i = tiffOptions.i;
        Source source = tiffOptions.getSource();
        if (source != null) {
            this.setSource(source);
        }
        if ((resolutionSetting = tiffOptions.getResolutionSettings()) != null) {
            this.setResolutionSettings(resolutionSetting);
        }
        if ((vectorRasterizationOptions = tiffOptions.getVectorRasterizationOptions()) != null) {
            this.setVectorRasterizationOptions(vectorRasterizationOptions);
        }
        if ((multiPageOptions = tiffOptions.getMultiPageOptions()) != null) {
            this.setMultiPageOptions(multiPageOptions);
        }
        this.xmpData = tiffOptions.xmpData;
        this.k = tiffOptions.k;
        this.l = tiffOptions.l;
    }

    public TiffOptions(TiffDataType[] tiffDataTypeArray) {
        if (tiffDataTypeArray == null) {
            throw new ArgumentNullException("tags");
        }
        this.a(com.aspose.imaging.internal.lz.g.a(tiffDataTypeArray));
        this.setCompressedQuality(75);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getTagCount() {
        List<TiffDataType> list = this.b;
        synchronized (list) {
            return this.b.size();
        }
    }

    public static int getValidTagsCount(TiffDataType[] tiffDataTypeArray) {
        int n2 = 0;
        if (tiffDataTypeArray != null) {
            for (TiffDataType tiffDataType : tiffDataTypeArray) {
                if (tiffDataType == null || com.aspose.imaging.internal.qB.d.b((Object)tiffDataType, TiffUnknownType.class) || !tiffDataType.isValid()) continue;
                ++n2;
            }
        }
        return n2;
    }

    static b createOptionsValidator(TiffOptions tiffOptions) {
        if (tiffOptions.i == 0) {
            return new com.aspose.imaging.internal.iR.a(tiffOptions);
        }
        if (tiffOptions.getCompression() == 7) {
            switch (tiffOptions.getPhotometric()) {
                case 1: {
                    return new c(tiffOptions);
                }
                case 2: {
                    return new d(tiffOptions);
                }
                case 6: {
                    return new e(tiffOptions);
                }
            }
        }
        return new f(tiffOptions);
    }

    public int getFileStandard() {
        return this.i;
    }

    public void setFileStandard(int n2) {
        this.i = n2;
    }

    @Deprecated
    public int getDefaultMemoryAllocationLimit() {
        return this.h;
    }

    @Deprecated
    public void setDefaultMemoryAllocationLimit(int n2) {
        this.h = n2 > 0 ? n2 : this.h;
    }

    public boolean getPremultiplyComponents() {
        return this.f;
    }

    public void setPremultiplyComponents(boolean bl2) {
        this.f = bl2;
    }

    public Color c() {
        return this.g;
    }

    public void a(Color color) {
        color.CloneTo(this.g);
    }

    @Override
    public XmpPacketWrapper getXmpData() {
        return this.xmpData;
    }

    @Override
    public void setXmpData(XmpPacketWrapper xmpPacketWrapper) {
        this.xmpData = xmpPacketWrapper;
    }

    public boolean isValid() {
        return this.b(true);
    }

    public int[] getYCbCrSubsampling() {
        int[] nArray;
        int[] nArray2 = this.f(530);
        if (nArray2 == null) {
            nArray2 = new int[]{2, 2};
        }
        if ((nArray = nArray2).length != 2) {
            throw new TiffImageException("Invalid field length. YCbCrSubsampling field must consist of two values.");
        }
        if ((nArray[0] & 0xFFFF) != 1 && (nArray[0] & 0xFFFF) != 2 && (nArray[0] & 0xFFFF) != 4 || (nArray[1] & 0xFFFF) != 1 && (nArray[1] & 0xFFFF) != 2 && (nArray[1] & 0xFFFF) != 4) {
            throw new TiffImageException(aV.a("Invalid YCbCrSubsampling value [{0},{1}]", new Object[]{nArray[0], nArray[1]}));
        }
        if ((nArray[1] & 0xFFFF) > (nArray[0] & 0xFFFF)) {
            throw new TiffImageException(aV.a("YCbCrSubsampleVert={0} shall always be less than or equal to YCbCrSubsampleHoriz={1}", new Object[]{nArray[1], nArray[0]}));
        }
        return nArray;
    }

    public void setYCbCrSubsampling(int[] nArray) {
        if (nArray == null) {
            throw new ArgumentNullException("value");
        }
        this.a(530, nArray);
    }

    public TiffRational[] getYCbCrCoefficients() {
        if (this.getPhotometric() == 6) {
            TiffRational[] tiffRationalArray = this.h(529);
            if (tiffRationalArray != null) {
                int n2 = tiffRationalArray.length;
                if (n2 != 3) {
                    throw new TiffImageException("Invalid count of rational coefficient values. Must be equal to 3.");
                }
                return tiffRationalArray;
            }
            return new TiffRational[]{new TiffRational(299L, 1000L), new TiffRational(587L, 1000L), new TiffRational(114L, 1000L)};
        }
        return null;
    }

    public void setYCbCrCoefficients(TiffRational[] tiffRationalArray) {
        if (tiffRationalArray == null) {
            throw new ArgumentNullException("value");
        }
        if (tiffRationalArray.length != 3) {
            throw new TiffImageException("Invalid count of rational coefficient values. Must be equal to 3.");
        }
        this.a(529, tiffRationalArray);
    }

    public boolean isTiled() {
        return this.isTagPresent(322) && this.isTagPresent(323);
    }

    public String getArtist() {
        return this.i(315);
    }

    public void setArtist(String string) {
        this.a(315, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isTagPresent(int n2) {
        boolean bl2;
        i<TiffDataType> i2 = this.a;
        synchronized (i2) {
            bl2 = this.a.b(n2);
        }
        return bl2;
    }

    public int getByteOrder() {
        return this.d;
    }

    public void setByteOrder(int n2) {
        this.d = n2;
    }

    public byte[] getIccProfile() {
        return this.d(34675);
    }

    public MemoryStream d() {
        MemoryStream memoryStream = null;
        byte[] byArray = this.d(34675);
        if (byArray != null) {
            memoryStream = new MemoryStream(byArray);
        }
        return memoryStream;
    }

    public void setIccProfile(byte[] byArray) {
        this.a(34675, byArray);
    }

    public final boolean isDisableIccExport() {
        return this.l;
    }

    public final void setDisableIccExport(boolean bl2) {
        this.l = bl2;
    }

    public int[] getBitsPerSample() {
        int[] nArray = this.f(258);
        if (nArray == null) {
            return new int[]{1};
        }
        int n2 = this.getSamplesPerPixel() & 0xFFFF;
        if (nArray.length < (n2 & 0xFFFF)) {
            nArray = Arrays.copyOf(nArray, n2);
            Arrays.fill(nArray, 1, nArray.length, nArray[0]);
        }
        return nArray;
    }

    public void setBitsPerSample(int[] nArray) {
        if (nArray == null) {
            throw new ArgumentNullException("value");
        }
        if (nArray.length == 0) {
            throw new ArgumentOutOfRangeException("value", "At least single array value must be specified.");
        }
        this.a(258, nArray);
        this.a(277, (bc)null, nArray.length & 0xFFFF);
    }

    public final int[] getExtraSamples() {
        int[] nArray = this.f(338);
        if (nArray != null) {
            int[] nArray2 = this.f(258);
            int n2 = nArray.length;
            if (nArray2 == null || nArray2.length < n2 || n2 > (this.getSamplesPerPixel() & 0xFFFF)) {
                throw new TiffImageException(aV.a("Invalid length of extra components. ExtraSamples.Length = {0}", new Object[]{n2}));
            }
        }
        return nArray;
    }

    public void a(int[] nArray) {
        if (nArray == null) {
            this.removeTag(338);
        } else {
            if (nArray.length == 0) {
                throw new ArgumentOutOfRangeException("value", "At least single array value must be specified.");
            }
            this.a(338, nArray);
        }
    }

    public final long e() {
        return this.e(338) & 0xFFFFFFFFL;
    }

    public int getCompression() {
        return this.a(259, 1) & 0xFFFF;
    }

    public void setCompression(int n2) {
        this.a(259, com.aspose.imaging.internal.qB.d.a(TiffCompressions.class), n2);
    }

    public final int getCompressedQuality() {
        return this.k;
    }

    public final void setCompressedQuality(int n2) {
        if (n2 > 100 || n2 < 1) {
            throw new ArgumentOutOfRangeException("Quality must be between 1 and 100.");
        }
        this.k = n2;
    }

    public String getCopyright() {
        return this.i(33432);
    }

    public void setCopyright(String string) {
        this.a(33432, string);
    }

    public int[] getColorMap() {
        return this.f(320);
    }

    public void setColorMap(int[] nArray) {
        if (nArray == null) {
            throw new ArgumentNullException("value");
        }
        if ((this.getSamplesPerPixel() & 0xFFFF) != 1) {
            throw new TiffImageException("The color map may be defined for samples per pixel equal to 1 only.");
        }
        int n2 = this.getBitsPerPixel();
        if (n2 == 0) {
            throw new TiffImageException("The bits per sample are not defined.");
        }
        int n3 = com.aspose.imaging.internal.qB.d.e(3.0 * bC.f(2.0, (double)n2));
        if (nArray.length != n3) {
            throw new ArgumentOutOfRangeException("value", "The array length must correspond to the following formula: 3 * (2**BitsPerSample).");
        }
        this.a(320, nArray);
    }

    @Override
    public IColorPalette getPalette() {
        return this.h();
    }

    @Override
    public void setPalette(IColorPalette iColorPalette) {
        if (iColorPalette == null || iColorPalette.getEntriesCount() == 0) {
            this.removeTag(320);
        } else {
            int[] nArray = iColorPalette.getArgb32Entries();
            int n2 = iColorPalette.getEntriesCount();
            int n3 = this.getBitsPerPixel();
            if (n3 == 0) {
                throw new TiffImageException("The bits per sample are not defined. Please specify the BitsPerSample first.");
            }
            int n4 = com.aspose.imaging.internal.qB.d.e(bC.f(2.0, (double)n3));
            int[] nArray2 = new int[3 * n4];
            n2 = bC.d(n2, n4);
            for (int i2 = 0; i2 < n2; ++i2) {
                int n5 = nArray[i2];
                int n6 = n5 >> 16 & 0xFF;
                int n7 = n5 >> 8 & 0xFF;
                int n8 = n5 & 0xFF;
                nArray2[i2] = (byte)n6 & 0xFF;
                nArray2[i2 + n4] = (byte)n7 & 0xFF;
                nArray2[i2 + n4 * 2] = (byte)n8 & 0xFF;
            }
            this.setColorMap(nArray2);
            this.e = iColorPalette.isCompactPalette();
        }
    }

    public String getDateTime() {
        return this.i(306);
    }

    public void setDateTime(String string) {
        this.a(306, string);
    }

    public String getDocumentName() {
        return this.i(269);
    }

    public void setDocumentName(String string) {
        this.a(269, string);
    }

    public int getAlphaStorage() {
        return this.a(338, 0) & 0xFFFF;
    }

    public void setAlphaStorage(int n2) {
        this.a(338, com.aspose.imaging.internal.qB.d.a(TiffAlphaStorage.class), n2);
    }

    public boolean isExtraSamplesPresent() {
        return 65535 != (this.a(338, 65535) & 0xFFFF);
    }

    public int getFillOrder() {
        return this.a(266, 1) & 0xFFFF;
    }

    public void setFillOrder(int n2) {
        this.a(266, com.aspose.imaging.internal.qB.d.a(TiffFillOrders.class), n2);
    }

    public int[] getHalfToneHints() {
        return this.f(321);
    }

    public void setHalfToneHints(int[] nArray) {
        if (nArray == null) {
            throw new ArgumentNullException("value");
        }
        if (nArray.length != 2) {
            throw new ArgumentOutOfRangeException("value", "Halftone hints array length must be equal to 2.");
        }
        this.a(321, nArray);
    }

    public String getImageDescription() {
        return this.i(270);
    }

    public void setImageDescription(String string) {
        this.a(270, string);
    }

    public String getInkNames() {
        return this.i(333);
    }

    public void setInkNames(String string) {
        this.a(333, string);
    }

    public String getScannerManufacturer() {
        return this.i(271);
    }

    public void setScannerManufacturer(String string) {
        this.a(271, string);
    }

    public int[] getMaxSampleValue() {
        int[] nArray = this.f(281);
        if (nArray == null) {
            int[] nArray2 = this.getBitsPerSample();
            nArray = new int[nArray2.length];
            for (int i2 = 0; i2 < nArray2.length; ++i2) {
                int n2;
                nArray[i2] = n2 = com.aspose.imaging.internal.qB.d.e(bC.f(2.0, (double)((long)nArray2[i2] & 0xFFFFL))) - 1 & 0xFFFF;
            }
        }
        return nArray;
    }

    public void setMaxSampleValue(int[] nArray) {
        if (nArray == null) {
            throw new ArgumentNullException("value");
        }
        if (nArray.length != (this.getSamplesPerPixel() & 0xFFFF)) {
            throw new ArgumentOutOfRangeException("value", "The array length must correspond to the samples per pixel count.");
        }
        this.a(281, nArray);
    }

    public int[] getMinSampleValue() {
        int[] nArray = this.f(280);
        if (nArray == null) {
            nArray = new int[this.getSamplesPerPixel()];
        }
        return nArray;
    }

    public void setMinSampleValue(int[] nArray) {
        if (nArray == null) {
            throw new ArgumentNullException("value");
        }
        if (nArray.length != (this.getSamplesPerPixel() & 0xFFFF)) {
            throw new ArgumentOutOfRangeException("value", "The array length must correspond to the samples per pixel count.");
        }
        this.a(280, nArray);
    }

    public String getScannerModel() {
        return this.i(272);
    }

    public void setScannerModel(String string) {
        this.a(272, string);
    }

    public int getOrientation() {
        return this.a(274, 1) & 0xFFFF;
    }

    public void setOrientation(int n2) {
        this.a(274, com.aspose.imaging.internal.qB.d.a(TiffOrientations.class), n2);
    }

    public String getPageName() {
        return this.i(285);
    }

    public void setPageName(String string) {
        this.a(285, string);
    }

    public int[] getPageNumber() {
        return this.f(297);
    }

    public void setPageNumber(int[] nArray) {
        if (nArray == null) {
            throw new ArgumentNullException("value");
        }
        if (nArray.length != 2) {
            throw new ArgumentOutOfRangeException("value", "Expected 2 values in the array: PageNumber[0] is the page number and PageNumber[1] is the total number of pages in the document.");
        }
        this.a(297, nArray);
    }

    public int getPhotometric() {
        int n2 = this.a(262, 65535) & 0xFFFF;
        return n2 != 65535 ? n2 : this.i();
    }

    public void setPhotometric(int n2) {
        this.a(262, com.aspose.imaging.internal.qB.d.a(TiffPhotometrics.class), n2);
    }

    public int getPlanarConfiguration() {
        return this.a(284, 1) & 0xFFFF;
    }

    public void setPlanarConfiguration(int n2) {
        this.a(284, com.aspose.imaging.internal.qB.d.a(TiffPlanarConfigs.class), n2);
    }

    public int getResolutionUnit() {
        return this.a(296, 2) & 0xFFFF;
    }

    public void setResolutionUnit(int n2) {
        this.a(296, com.aspose.imaging.internal.qB.d.a(TiffResolutionUnits.class), n2);
    }

    public long getRowsPerStrip() {
        return this.b(278, 0L);
    }

    public void setRowsPerStrip(long l2) {
        this.removeTags(322, 323, 324, 325);
        this.a(278, new long[]{l2}, false);
    }

    public long getTileWidth() {
        return this.b(322, 0L);
    }

    public void setTileWidth(long l2) {
        this.removeTags(278, 273, 279);
        this.a(322, new long[]{l2}, false);
    }

    public long getTileLength() {
        return this.b(323, 0L);
    }

    public void setTileLength(long l2) {
        this.removeTags(278, 273, 279);
        this.a(323, new long[]{l2}, false);
    }

    public int[] getSampleFormat() {
        int[] nArray;
        int[] nArray2 = this.f(339);
        if (nArray2 == null) {
            nArray = new int[this.getSamplesPerPixel()];
            Arrays.fill(nArray, 1);
        } else {
            nArray = new int[nArray2.length];
            for (int i2 = 0; i2 < nArray2.length; ++i2) {
                nArray[i2] = nArray2[i2] & 0xFFFF;
            }
        }
        return nArray;
    }

    public void setSampleFormat(int[] nArray) {
        TiffOptions.a(nArray, this.getSamplesPerPixel() & 0xFFFF);
        int[] nArray2 = new int[nArray.length];
        System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
        this.a(339, nArray2);
    }

    public int getSamplesPerPixel() {
        return this.a(277, 1);
    }

    public long[] getSmaxSampleValue() {
        return this.a(341, 0xFFFFFFFFL, this.getSamplesPerPixel() & 0xFFFF);
    }

    public void setSmaxSampleValue(long[] lArray) {
        TiffOptions.a(lArray, this.getSamplesPerPixel() & 0xFFFF);
        this.a(341, lArray, true);
    }

    public long[] getSminSampleValue() {
        return this.a(340, 0L, this.getSamplesPerPixel() & 0xFFFF);
    }

    public void setSminSampleValue(long[] lArray) {
        TiffOptions.a(lArray, this.getSamplesPerPixel() & 0xFFFF);
        this.a(340, lArray, true);
    }

    public String getSoftwareType() {
        return this.i(305);
    }

    public void setSoftwareType(String string) {
        this.a(305, string);
    }

    public long[] getStripByteCounts() {
        return this.c(279);
    }

    public void setStripByteCounts(long[] lArray) {
        if (!this.isTiled()) {
            this.removeTags(324, 325);
            this.a(279, lArray, false);
        }
    }

    public long[] getStripOffsets() {
        return this.c(273);
    }

    public void setStripOffsets(long[] lArray) {
        if (!this.isTiled()) {
            this.removeTags(324, 325);
            this.a(273, lArray, false);
        }
    }

    public long[] getTileByteCounts() {
        return this.c(325);
    }

    public void setTileByteCounts(long[] lArray) {
        if (this.isTiled()) {
            this.removeTags(273, 279);
            this.a(325, lArray, false);
        }
    }

    public long[] getTileOffsets() {
        return this.c(324);
    }

    public void setTileOffsets(long[] lArray) {
        if (this.isTiled()) {
            this.removeTags(273, 279);
            this.a(324, lArray, false);
        }
    }

    public long getSubFileType() {
        return this.a(254, 0L) & 0xFFFFFFFFL;
    }

    public void setSubFileType(long l2) {
        this.a(254, com.aspose.imaging.internal.qB.d.a(TiffNewSubFileTypes.class), l2);
    }

    public String getTargetPrinter() {
        return this.i(337);
    }

    public void setTargetPrinter(String string) {
        this.a(337, string);
    }

    public int getThreshholding() {
        return this.a(263, 1) & 0xFFFF;
    }

    public void setThreshholding(int n2) {
        this.a(263, com.aspose.imaging.internal.qB.d.a(TiffThresholds.class), n2);
    }

    public int getTotalPages() {
        int n2 = 0;
        TiffShortType tiffShortType = (TiffShortType)((Object)com.aspose.imaging.internal.qB.d.a(this.getTagByType(297), TiffShortType.class));
        if (tiffShortType != null && tiffShortType.getValues() != null && tiffShortType.getValues().length > 1) {
            n2 = tiffShortType.getValues()[1];
        }
        return n2;
    }

    public TiffRational getXposition() {
        return this.g(286);
    }

    public void setXposition(TiffRational tiffRational) {
        this.a(286, tiffRational);
    }

    @Override
    public ResolutionSetting getResolutionSettings() {
        return super.getResolutionSettings();
    }

    @Override
    public void setResolutionSettings(ResolutionSetting resolutionSetting) {
        super.setResolutionSettings(resolutionSetting);
        if (resolutionSetting != null) {
            this.setXresolution(TiffRational.approximateFraction(resolutionSetting.getHorizontalResolution()));
            this.setYresolution(TiffRational.approximateFraction(resolutionSetting.getVerticalResolution()));
        } else {
            this.setXresolution(null);
            this.setYresolution(null);
        }
    }

    public TiffRational getXresolution() {
        return this.g(282);
    }

    public void setXresolution(TiffRational tiffRational) {
        this.a(282, tiffRational);
        this.a(tiffRational, this.getYresolution());
    }

    public TiffRational getYposition() {
        return this.g(287);
    }

    public void setYposition(TiffRational tiffRational) {
        this.a(287, tiffRational);
    }

    public TiffRational getYresolution() {
        return this.g(283);
    }

    public void setYresolution(TiffRational tiffRational) {
        this.a(283, tiffRational);
        this.a(this.getXresolution(), tiffRational);
    }

    public long getFaxT4Options() {
        return this.a(292, 0L) & 0xFFFFFFFFL;
    }

    public void setFaxT4Options(long l2) {
        this.a(292, new long[]{l2 & 0xFFFFFFFFL});
    }

    public int getPredictor() {
        return this.a(317, 1) & 0xFFFF;
    }

    public void setPredictor(int n2) {
        this.a(317, com.aspose.imaging.internal.qB.d.a(TiffPredictor.class), n2);
    }

    public long getImageLength() {
        return this.b(257, 0L);
    }

    public void setImageLength(long l2) {
        this.a(257, new long[]{l2}, false);
    }

    public long getImageWidth() {
        return this.b(256, 0L);
    }

    public void setImageWidth(long l2) {
        this.a(256, new long[]{l2}, false);
    }

    public TiffExifIfd getExifIfd() {
        long l2 = this.b(34665, 0xFFFFFFFFL);
        return 0xFFFFFFFFL != (l2 & 0xFFFFFFFFL) ? new TiffExifIfd(l2) : new TiffExifIfd();
    }

    final void setExifIfd_internalized(TiffExifIfd tiffExifIfd) {
        if (tiffExifIfd == null || !tiffExifIfd.hasValue()) {
            return;
        }
        this.a(34665, tiffExifIfd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TiffDataType[] getTags() {
        TiffDataType[] tiffDataTypeArray;
        List<TiffDataType> list = this.b;
        synchronized (list) {
            tiffDataTypeArray = this.b.toArray((TiffDataType[])new TiffDataType[0]);
        }
        return tiffDataTypeArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTags(TiffDataType[] tiffDataTypeArray) {
        List<TiffDataType> list = this.b;
        synchronized (list) {
            i<TiffDataType> i2 = this.a;
            synchronized (i2) {
                this.b.clear();
                this.a.c();
                if (tiffDataTypeArray != null) {
                    for (TiffDataType tiffDataType : tiffDataTypeArray) {
                        this.addTag(tiffDataType);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getValidTagCount() {
        TiffDataType[] tiffDataTypeArray;
        List<TiffDataType> list = this.b;
        synchronized (list) {
            tiffDataTypeArray = this.b.toArray((TiffDataType[])new TiffDataType[0]);
        }
        return TiffOptions.getValidTagsCount(tiffDataTypeArray);
    }

    public int getBitsPerPixel() {
        int[] nArray = this.getBitsPerSample();
        int n2 = 0;
        if (nArray != null) {
            for (int n3 : nArray) {
                n2 += n3 & 0xFFFF;
            }
        }
        return n2;
    }

    public final String getXPTitle() {
        return this.j(40091);
    }

    public final void setXPTitle(String string) {
        this.b(40091, string);
    }

    public final String getXPComment() {
        return this.j(40092);
    }

    public final void setXPComment(String string) {
        this.b(40092, string);
    }

    public final String getXPAuthor() {
        return this.j(40093);
    }

    public final void setXPAuthor(String string) {
        this.b(40093, string);
    }

    public final String getXPKeywords() {
        return this.j(40094);
    }

    public final void setXPKeywords(String string) {
        this.b(40094, string);
    }

    public final String getXPSubject() {
        return this.j(40095);
    }

    public final void setXPSubject(String string) {
        this.b(40095, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeTag(int n2) {
        boolean bl2 = false;
        List<TiffDataType> list = this.b;
        synchronized (list) {
            i<TiffDataType> i2 = this.a;
            synchronized (i2) {
                if (this.a.b(n2)) {
                    TiffDataType tiffDataType = this.a.a(n2);
                    this.a.c(n2);
                    this.b.removeItem(tiffDataType);
                    bl2 = true;
                }
            }
        }
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean removeTags(int ... nArray) {
        List<TiffDataType> list = this.b;
        synchronized (list) {
            i<TiffDataType> i2 = this.a;
            synchronized (i2) {
                int n2 = this.a.a();
                for (int n3 : nArray) {
                    if (!this.a.b(n3)) continue;
                    TiffDataType tiffDataType = this.a.a(n3);
                    this.a.c(n3);
                    this.b.removeItem(tiffDataType);
                }
                return this.a.a() < n2;
            }
        }
    }

    public void validate() {
        this.b(false);
    }

    public void addTags(TiffDataType[] tiffDataTypeArray) {
        if (tiffDataTypeArray == null) {
            throw new ArgumentNullException("tagsToAdd");
        }
        for (TiffDataType tiffDataType : tiffDataTypeArray) {
            this.addTag(tiffDataType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTag(TiffDataType tiffDataType) {
        this.g();
        if (tiffDataType == null) {
            throw new ArgumentNullException("tagToAdd");
        }
        List<TiffDataType> list = this.b;
        synchronized (list) {
            i<TiffDataType> i2 = this.a;
            synchronized (i2) {
                if (!this.a.b(tiffDataType.getTagId())) {
                    this.b.addItem(tiffDataType);
                }
                this.a.a(tiffDataType.getTagId(), tiffDataType);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TiffDataType getTagByType(int n2) {
        TiffDataType tiffDataType = null;
        i<TiffDataType> i2 = this.a;
        synchronized (i2) {
            if (this.a.b(n2)) {
                tiffDataType = this.a.a(n2);
            }
        }
        return tiffDataType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean a(int n2) {
        i<TiffDataType> i2 = this.a;
        synchronized (i2) {
            return this.a.b(n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long[] b(int n2) {
        if (!this.a(n2)) {
            return null;
        }
        i<long[]> i2 = this.c;
        synchronized (i2) {
            long[] lArray;
            if (!this.j || !this.c.b(n2)) {
                lArray = this.c(n2);
                this.j = true;
                this.c.a(n2, lArray);
            } else {
                lArray = this.c.a(n2);
            }
            return lArray;
        }
    }

    public final IGenericEnumerable<TiffDataType> f() {
        return this.b.asReadOnly();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void g() {
        i<long[]> i2 = this.c;
        synchronized (i2) {
            this.j = false;
            this.c.c();
        }
    }

    private IColorPalette h() {
        ColorPalette colorPalette = null;
        int[] nArray = this.getColorMap();
        if (nArray != null) {
            int n2;
            int n3;
            boolean bl2 = false;
            int[] nArray2 = nArray;
            int n4 = nArray2.length;
            for (n3 = 0; n3 < n4; ++n3) {
                n2 = nArray2[n3];
                if ((n2 & 0xFFFF) <= 255) continue;
                bl2 = true;
                break;
            }
            if (bl2) {
                int[] nArray3 = new int[nArray.length];
                for (n3 = 0; n3 < nArray3.length; ++n3) {
                    nArray3[n3] = (nArray[n3] & 0xFFFF) >> 8 & 0xFF & 0xFFFF;
                }
                nArray2 = nArray3;
            } else {
                nArray2 = nArray;
            }
            int n5 = nArray2.length / 3;
            if (n5 > 0) {
                int[] nArray4 = new int[n5];
                for (n2 = 0; n2 < nArray4.length; ++n2) {
                    nArray4[n2] = 0xFF000000 | (nArray2[n2] & 0xFF) << 16 | (nArray2[n2 + n5] & 0xFF) << 8 | nArray2[n2 + (n5 << 1)] & 0xFF;
                }
                colorPalette = new ColorPalette(nArray4, this.e);
            }
        }
        return colorPalette;
    }

    private static void a(Object object, int n2) {
        if (object == null) {
            throw new ArgumentNullException("array");
        }
        if (Array.getLength(object) != n2) {
            throw new ArgumentOutOfRangeException("array", "The array length is not valid. Expected length equal to samples per pixel.");
        }
    }

    private long[] c(int n2) {
        long[] lArray = null;
        TiffDataType tiffDataType = this.getTagByType(n2);
        if (tiffDataType != null && com.aspose.imaging.internal.qB.d.b(tiffDataType.getValue(), com.aspose.imaging.internal.lz.g.class)) {
            com.aspose.imaging.internal.lz.g g2 = (com.aspose.imaging.internal.lz.g)((Object)com.aspose.imaging.internal.qB.d.a(tiffDataType.getValue(), com.aspose.imaging.internal.lz.g.class));
            int n3 = g2.j();
            lArray = new long[n3];
            for (int i2 = 0; i2 < n3; ++i2) {
                lArray[i2] = I.h(g2.e(i2));
            }
        }
        return lArray;
    }

    private byte[] d(int n2) {
        byte[] byArray = null;
        TiffDataType tiffDataType = this.getTagByType(n2);
        if (tiffDataType != null && com.aspose.imaging.internal.qB.d.b(tiffDataType.getValue(), com.aspose.imaging.internal.lz.g.class)) {
            com.aspose.imaging.internal.lz.g g2 = (com.aspose.imaging.internal.lz.g)((Object)com.aspose.imaging.internal.qB.d.a(tiffDataType.getValue(), com.aspose.imaging.internal.lz.g.class));
            byArray = new byte[g2.j()];
            for (int i2 = 0; i2 < g2.j(); ++i2) {
                byArray[i2] = I.c(g2.e(i2));
            }
        }
        return byArray;
    }

    private long[] a(int n2, long l2, int n3) {
        long[] lArray = this.c(n2);
        if (lArray == null) {
            lArray = new long[n3];
            Arrays.fill(lArray, l2);
        }
        return lArray;
    }

    private long e(int n2) {
        TiffDataType tiffDataType = this.getTagByType(n2);
        return tiffDataType == null ? 0L : tiffDataType.getCount();
    }

    private void a(int n2, long[] lArray, boolean bl2) {
        int n3;
        Object object;
        long l2 = 0L;
        for (long l3 : lArray) {
            if ((l3 & 0xFFFFFFFFL) <= (l2 & 0xFFFFFFFFL)) continue;
            l2 = l3;
        }
        if (bl2 && (l2 & 0xFFFFFFFFL) <= 255L) {
            object = new byte[lArray.length];
            for (n3 = 0; n3 < lArray.length; ++n3) {
                object[n3] = (byte)lArray[n3];
            }
            TiffDataType tiffDataType = this.getTagByType(n2);
            if (tiffDataType != null && tiffDataType.getTagType() != 1) {
                this.removeTag(n2);
            }
            this.a(n2, (byte[])object);
        } else if ((l2 & 0xFFFFFFFFL) <= 65535L) {
            object = new int[lArray.length];
            for (n3 = 0; n3 < lArray.length; ++n3) {
                object[n3] = (int)(lArray[n3] & 0xFFFFFFFFL);
            }
            TiffDataType tiffDataType = this.getTagByType(n2);
            if (tiffDataType != null && tiffDataType.getTagType() != 3) {
                this.removeTag(n2);
            }
            this.a(n2, (int[])object);
        } else {
            object = this.getTagByType(n2);
            if (object != null && ((TiffDataType)object).getTagType() != 4) {
                this.removeTag(n2);
            }
            this.a(n2, lArray);
        }
    }

    private void a(Iterable<TiffDataType> iterable) {
        for (TiffDataType tiffDataType : iterable) {
            this.addTag(tiffDataType.deepClone());
        }
    }

    private void a(int n2, byte[] byArray) {
        TiffByteType tiffByteType = (TiffByteType)this.a(n2, new com.aspose.imaging.internal.hO.b());
        tiffByteType.setValues(byArray);
        this.addTag(tiffByteType);
    }

    private void a(int n2, int[] nArray) {
        TiffShortType tiffShortType = (TiffShortType)this.a(n2, new o());
        tiffShortType.setValues(nArray);
        this.addTag(tiffShortType);
    }

    private void a(int n2, long[] lArray) {
        TiffLongType tiffLongType = (TiffLongType)this.a(n2, new h());
        tiffLongType.setValues(lArray);
        this.addTag(tiffLongType);
    }

    private void b(int n2, long[] lArray) {
        TiffLong8Type tiffLong8Type = (TiffLong8Type)((Object)com.aspose.imaging.internal.qB.d.a(this.a(n2, new com.aspose.imaging.internal.hO.g()), TiffLong8Type.class));
        tiffLong8Type.setValues(lArray);
        this.addTag(tiffLong8Type);
    }

    private void a(int n2, TiffExifIfd[] tiffExifIfdArray) {
        g g2 = new g();
        if (tiffExifIfdArray == null) {
            return;
        }
        for (TiffExifIfd tiffExifIfd : tiffExifIfdArray) {
            if (!tiffExifIfd.hasValue()) continue;
            g2.e(tiffExifIfd.getOffset());
        }
        if (g2.b() > 0) {
            TiffIfdType tiffIfdType = (TiffIfdType)this.a(n2, new com.aspose.imaging.internal.hO.f());
            tiffIfdType.setValues(com.aspose.imaging.internal.lo.a.d);
            this.addTag(tiffIfdType);
        }
    }

    private void a(int n2, TiffRational[] tiffRationalArray) {
        TiffRationalType tiffRationalType = (TiffRationalType)this.a(n2, new com.aspose.imaging.internal.hO.i());
        tiffRationalType.setValues(tiffRationalArray);
        this.addTag(tiffRationalType);
    }

    private void a(int n2, bc bc2, int n3) {
        if (bc2 != null && !Enum.isDefined(bc2, (long)n3)) {
            throw new ArgumentOutOfRangeException("value", "The value is not defined.");
        }
        this.a(n2, new int[]{n3});
    }

    private void a(int n2, bc bc2, long l2) {
        if (bc2 != null && !Enum.isDefined(bc2, l2)) {
            throw new ArgumentOutOfRangeException("value", "The value is not defined.");
        }
        this.a(n2, new long[]{l2});
    }

    private void a(int n2, TiffExifIfd tiffExifIfd) {
        this.a(n2, new TiffExifIfd[]{tiffExifIfd});
    }

    private void a(int n2, TiffRational tiffRational) {
        this.a(n2, new TiffRational[]{tiffRational});
    }

    private int[] f(int n2) {
        int[] nArray = null;
        TiffShortType tiffShortType = (TiffShortType)((Object)com.aspose.imaging.internal.qB.d.a(this.getTagByType(n2), TiffShortType.class));
        if (tiffShortType != null) {
            nArray = tiffShortType.getValues();
        }
        return nArray;
    }

    private int a(int n2, int n3) {
        int n4 = n3;
        TiffShortType tiffShortType = (TiffShortType)((Object)com.aspose.imaging.internal.qB.d.a(this.getTagByType(n2), TiffShortType.class));
        if (tiffShortType != null && tiffShortType.getValues() != null && tiffShortType.getValues().length > 0) {
            n4 = tiffShortType.getValues()[0];
        }
        return n4;
    }

    private long a(int n2, long l2) {
        long l3 = l2;
        TiffLongType tiffLongType = (TiffLongType)((Object)com.aspose.imaging.internal.qB.d.a(this.getTagByType(n2), TiffLongType.class));
        if (tiffLongType != null && tiffLongType.getValues() != null && tiffLongType.getValues().length > 0) {
            l3 = tiffLongType.getValues()[0];
        }
        return l3;
    }

    private long b(int n2, long l2) {
        long l3 = l2;
        TiffDataType tiffDataType = this.getTagByType(n2);
        if (tiffDataType != null && tiffDataType.getValue() != null && com.aspose.imaging.internal.qB.d.b(tiffDataType.getValue(), com.aspose.imaging.internal.lz.g.class) && ((com.aspose.imaging.internal.lz.g)((Object)com.aspose.imaging.internal.qB.d.a(tiffDataType.getValue(), com.aspose.imaging.internal.lz.g.class))).j() > 0) {
            l3 = I.h(((com.aspose.imaging.internal.lz.g)((Object)com.aspose.imaging.internal.qB.d.a(tiffDataType.getValue(), com.aspose.imaging.internal.lz.g.class))).e(0));
        }
        return l3;
    }

    private void a(int n2, String string) {
        if (string == null) {
            this.removeTag(n2);
            return;
        }
        TiffASCIIType tiffASCIIType = (TiffASCIIType)this.a(n2, new com.aspose.imaging.internal.hO.a());
        tiffASCIIType.setText(string);
        this.addTag(tiffASCIIType);
    }

    private void b(int n2, String string) {
        if (string == null) {
            this.removeTag(n2);
            return;
        }
        TiffByteType tiffByteType = (TiffByteType)this.a(n2, new com.aspose.imaging.internal.hO.b());
        tiffByteType.setValues(com.aspose.imaging.internal.mm.l.A().c(aV.a(new String[]{string, "\u0000"})));
        this.addTag(tiffByteType);
    }

    private TiffRational g(int n2) {
        TiffRational tiffRational = null;
        TiffRationalType tiffRationalType = (TiffRationalType)((Object)com.aspose.imaging.internal.qB.d.a(this.getTagByType(n2), TiffRationalType.class));
        if (tiffRationalType != null && tiffRationalType.getValues() != null && tiffRationalType.getValues().length > 0) {
            tiffRational = tiffRationalType.getValues()[0];
        }
        return tiffRational;
    }

    private TiffRational[] h(int n2) {
        TiffRational[] tiffRationalArray;
        TiffRational[] tiffRationalArray2 = null;
        TiffRationalType tiffRationalType = (TiffRationalType)((Object)com.aspose.imaging.internal.qB.d.a(this.getTagByType(n2), TiffRationalType.class));
        if (tiffRationalType != null && (tiffRationalArray = tiffRationalType.getValues()) != null && tiffRationalArray.length > 0) {
            tiffRationalArray2 = new TiffRational[tiffRationalArray.length];
            System.arraycopy(tiffRationalArray, 0, tiffRationalArray2, 0, tiffRationalArray.length);
        }
        return tiffRationalArray2;
    }

    private String i(int n2) {
        String string = null;
        TiffASCIIType tiffASCIIType = (TiffASCIIType)((Object)com.aspose.imaging.internal.qB.d.a(this.getTagByType(n2), TiffASCIIType.class));
        if (tiffASCIIType != null) {
            string = tiffASCIIType.getText();
        }
        return string;
    }

    private String j(int n2) {
        String string = null;
        TiffByteType tiffByteType = (TiffByteType)((Object)com.aspose.imaging.internal.qB.d.a(this.getTagByType(n2), TiffByteType.class));
        if (tiffByteType != null) {
            string = aV.c(com.aspose.imaging.internal.mm.l.A().c(tiffByteType.getValues()), new char[]{'\u0000'});
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TiffDataType a(int n2, ITiffTagCreator iTiffTagCreator) {
        TiffDataType tiffDataType = iTiffTagCreator.createInstance(n2);
        TiffDataType tiffDataType2 = null;
        i<TiffDataType> i2 = this.a;
        synchronized (i2) {
            if (this.a.b(n2) && (tiffDataType2 = this.a.a(n2)).getTagType() != tiffDataType.getTagType()) {
                this.removeTag(n2);
                tiffDataType2 = null;
            }
        }
        if (tiffDataType2 == null) {
            tiffDataType2 = tiffDataType;
        }
        return tiffDataType2;
    }

    private boolean b(boolean bl2) {
        b b2 = TiffOptions.createOptionsValidator(this);
        return b2.a(bl2);
    }

    @Override
    protected Object memberwiseClone() {
        return new TiffOptions(this);
    }

    private int i() {
        int[] nArray = this.f(258);
        int n2 = nArray == null ? 1 : nArray.length;
        int n3 = this.getSamplesPerPixel() & 0xFFFF;
        n2 = Math.max(n2, n3);
        return n2 > 1 ? 2 : 0;
    }

    private void a(TiffRational tiffRational, TiffRational tiffRational2) {
        if (tiffRational != null && tiffRational2 != null) {
            ResolutionSetting resolutionSetting = this.getResolutionSettings();
            if (resolutionSetting == null) {
                super.setResolutionSettings(new ResolutionSetting(tiffRational.getValueD(), tiffRational2.getValueD()));
            } else {
                resolutionSetting.setHorizontalResolution(tiffRational.getValueD());
                resolutionSetting.setVerticalResolution(tiffRational2.getValueD());
            }
        }
    }
}

