/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.fileformats.ico;

import com.aspose.imaging.IMultipageImageExt;
import com.aspose.imaging.Image;
import com.aspose.imaging.RasterCachedImage;
import com.aspose.imaging.RasterCachedMultipageImage;
import com.aspose.imaging.RasterImage;
import com.aspose.imaging.StreamContainer;
import com.aspose.imaging.coreexceptions.OperationInterruptedException;
import com.aspose.imaging.fileformats.bmp.BmpImage;
import com.aspose.imaging.fileformats.ico.a;
import com.aspose.imaging.fileformats.ico.b;
import com.aspose.imaging.fileformats.ico.c;
import com.aspose.imaging.fileformats.ico.d;
import com.aspose.imaging.fileformats.png.PngImage;
import com.aspose.imaging.imageoptions.IcoOptions;
import com.aspose.imaging.internal.Exceptions.ArgumentException;
import com.aspose.imaging.internal.Exceptions.ArgumentNullException;
import com.aspose.imaging.internal.Exceptions.ArgumentOutOfRangeException;
import com.aspose.imaging.internal.iW.m;
import com.aspose.imaging.internal.lz.g;
import com.aspose.imaging.multithreading.IInterruptMonitor;
import com.aspose.imaging.multithreading.InterruptMonitor;
import com.aspose.imaging.system.IDisposable;
import com.aspose.imaging.system.collections.Generic.Dictionary;
import com.aspose.imaging.system.collections.Generic.IGenericEnumerator;
import com.aspose.imaging.system.collections.Generic.List;
import com.aspose.imaging.system.io.MemoryStream;
import com.aspose.imaging.system.io.Stream;
import java.io.OutputStream;

public class IcoImage
extends RasterCachedMultipageImage
implements IMultipageImageExt {
    private final List<Image> j = new List();
    private com.aspose.imaging.internal.fp.b[] k;

    public IcoImage(int n2, int n3, IcoOptions icoOptions) {
        this();
        if (n2 <= 0 || n3 <= 0) {
            throw new ArgumentException("width and height must be > 0.");
        }
        if (icoOptions == null) {
            throw new ArgumentNullException("options");
        }
        RasterCachedImage rasterCachedImage = icoOptions.getFormat() == 2L ? new BmpImage(n2, n3, icoOptions.getBitsPerPixel() & 0xFFFF, icoOptions.getPalette()) : new PngImage(n2, n3, icoOptions.c());
        this.j.addItem(rasterCachedImage);
    }

    public IcoImage(Image image, IcoOptions icoOptions) {
        this();
        this.addPage(image, icoOptions);
    }

    IcoImage(com.aspose.imaging.internal.fp.b[] bArray) {
        this();
        this.k = bArray;
    }

    IcoImage(Image[] imageArray) {
        this();
        if (imageArray == null) {
            throw new ArgumentNullException("images");
        }
        this.j.addRange(com.aspose.imaging.internal.lz.g.a(imageArray));
        IcoImage icoImage = this;
        this.j.forEach(new a(this, icoImage));
    }

    public static IcoImage a(Image[] imageArray) {
        return new IcoImage(imageArray);
    }

    public static IcoImage a(com.aspose.imaging.internal.fp.b[] bArray) {
        return new IcoImage(bArray);
    }

    private IcoImage() {
        super.a(new com.aspose.imaging.internal.fr.a(this));
    }

    @Override
    public long getFileFormat() {
        return 256L;
    }

    @Override
    public int getPageCount() {
        this.b(m.c());
        int n2 = this.j.size();
        if (n2 > 0) {
            return n2;
        }
        return this.s().length;
    }

    @Override
    public Image[] getPages() {
        this.b(m.c());
        return this.s();
    }

    @Override
    public Image n() {
        this.b(m.c());
        Image[] imageArray = this.getPages();
        return imageArray.length > 0 ? imageArray[0] : null;
    }

    @Override
    public boolean hasAlpha() {
        this.b(m.c());
        return com.aspose.imaging.internal.lz.g.a(this.getPages(), new b(this));
    }

    public final com.aspose.imaging.internal.fp.b[] r() {
        return this.k;
    }

    @Override
    public boolean f() {
        return com.aspose.imaging.internal.lz.g.a(this.getPages(), new c(this));
    }

    @Override
    public final void addPage(RasterImage rasterImage) {
        this.addPage(rasterImage, new IcoOptions());
    }

    public final void addPage(Image image) {
        this.addPage(image, new IcoOptions());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addPage(Image image, IcoOptions icoOptions) {
        super.verifyNotDisposed();
        if (image == null || icoOptions == null) {
            throw new ArgumentNullException(image == null ? "page" : "icoOptions");
        }
        Object object = this.c;
        synchronized (object) {
            this.s();
            Image image2 = com.aspose.imaging.internal.fq.c.b(image, icoOptions);
            image2.a(this);
            this.j.addItem(image2);
        }
        this.b(m.c());
    }

    public final void removePage(int n2) {
        super.verifyNotDisposed();
        if (n2 < 0 || n2 >= this.getPageCount()) {
            throw new ArgumentOutOfRangeException("index", "Page index is out of range. Note that ICO image must contain at least single entry.");
        }
        this.j.get_Item(n2).dispose();
        this.j.removeAt(n2);
        this.b(m.c());
    }

    @Override
    protected void saveData(Stream stream) {
        super.verifyNotDisposed();
        Dictionary<com.aspose.imaging.internal.fp.b, MemoryStream> dictionary = com.aspose.imaging.internal.fq.c.b(this);
        IcoImage.a(stream, dictionary);
    }

    @Override
    protected void updateDimensions(int n2, int n3) {
    }

    public static boolean b(StreamContainer streamContainer) {
        com.aspose.imaging.internal.fp.a a2 = com.aspose.imaging.internal.fp.a.a(streamContainer);
        com.aspose.imaging.internal.fp.b b2 = com.aspose.imaging.internal.fp.b.a(streamContainer);
        return com.aspose.imaging.internal.fp.a.a(a2) && (b2.e() & 0xFF) == 0;
    }

    protected static void write(OutputStream outputStream, Dictionary<com.aspose.imaging.internal.fp.b, MemoryStream> dictionary) {
        IcoImage.a(Stream.fromJava(outputStream), dictionary);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void a(Stream stream, Dictionary<com.aspose.imaging.internal.fp.b, MemoryStream> dictionary) {
        IInterruptMonitor iInterruptMonitor = InterruptMonitor.getThreadLocalInstance();
        if (com.aspose.imaging.internal.qB.d.b((Object)iInterruptMonitor, IInterruptMonitor.class) && iInterruptMonitor.isInterrupted()) {
            throw new OperationInterruptedException("The operation has been interrupted.");
        }
        if (dictionary.size() == 0) {
            throw new ArgumentException("ICO image must contain at least a single image entry.", "entries");
        }
        stream.setPosition(0L);
        stream.write(new com.aspose.imaging.internal.fp.a(dictionary.size()).a(), 0, 6);
        com.aspose.imaging.internal.fq.c.a(dictionary);
        IGenericEnumerator iGenericEnumerator = ((Dictionary.KeyCollection)dictionary.getKeys()).iterator();
        try {
            while (iGenericEnumerator.hasNext()) {
                com.aspose.imaging.internal.fp.b b2 = (com.aspose.imaging.internal.fp.b)iGenericEnumerator.next();
                stream.write(b2.a(), 0, 16);
            }
        }
        finally {
            if (com.aspose.imaging.internal.qB.d.a(iGenericEnumerator, IDisposable.class) != false) {
                ((IDisposable)iGenericEnumerator).dispose();
            }
        }
        for (MemoryStream memoryStream : dictionary.getValues()) {
            try {
                memoryStream.writeTo(stream);
            }
            finally {
                if (memoryStream == null) continue;
                memoryStream.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Image[] s() {
        Object object = this.c;
        synchronized (object) {
            List<Image> list = this.j;
            if (list == null) {
                return new Image[0];
            }
            if (list.size() == 0 && this.r() != null) {
                list.addRange(com.aspose.imaging.internal.fq.c.a(this));
                IcoImage icoImage = this;
                list.forEach(new d(this, icoImage));
                this.k = null;
            }
            return list.toArray((Image[])new Image[0]);
        }
    }
}

