/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging;

import com.aspose.imaging.Color;
import com.aspose.imaging.DataStreamSupporter;
import com.aspose.imaging.DisposableObject;
import com.aspose.imaging.FileStreamContainer;
import com.aspose.imaging.IColorPalette;
import com.aspose.imaging.IImageCreator;
import com.aspose.imaging.IImageExporter;
import com.aspose.imaging.IImageLoaderDescriptor;
import com.aspose.imaging.IObjectWithBounds;
import com.aspose.imaging.ImageCreatorsRegistry;
import com.aspose.imaging.ImageExportersRegistry;
import com.aspose.imaging.ImageLoadersRegistry;
import com.aspose.imaging.ImageOptionsBase;
import com.aspose.imaging.ImageResizeSettings;
import com.aspose.imaging.LoadOptions;
import com.aspose.imaging.Point;
import com.aspose.imaging.ProgressEventHandler;
import com.aspose.imaging.Rectangle;
import com.aspose.imaging.Size;
import com.aspose.imaging.StreamContainer;
import com.aspose.imaging.coreexceptions.FrameworkException;
import com.aspose.imaging.coreexceptions.ImageCreateException;
import com.aspose.imaging.coreexceptions.ImageException;
import com.aspose.imaging.coreexceptions.ImageLoadException;
import com.aspose.imaging.coreexceptions.ImageSaveException;
import com.aspose.imaging.coreexceptions.OperationInterruptedException;
import com.aspose.imaging.internal.Exceptions.ArgumentException;
import com.aspose.imaging.internal.Exceptions.ArgumentNullException;
import com.aspose.imaging.internal.Exceptions.ArgumentOutOfRangeException;
import com.aspose.imaging.internal.Exceptions.NotImplementedException;
import com.aspose.imaging.internal.aK.X;
import com.aspose.imaging.internal.aK.aL;
import com.aspose.imaging.internal.aK.bi;
import com.aspose.imaging.internal.aK.cp;
import com.aspose.imaging.internal.aK.cq;
import com.aspose.imaging.internal.aK.e;
import com.aspose.imaging.internal.jG.a;
import com.aspose.imaging.internal.jo.g;
import com.aspose.imaging.internal.jo.i;
import com.aspose.imaging.internal.kQ.l;
import com.aspose.imaging.internal.kS.D;
import com.aspose.imaging.internal.kk.b;
import com.aspose.imaging.internal.la.u;
import com.aspose.imaging.internal.la.w;
import com.aspose.imaging.internal.ln.f;
import com.aspose.imaging.internal.lz.aD;
import com.aspose.imaging.internal.lz.aV;
import com.aspose.imaging.internal.lz.bC;
import com.aspose.imaging.internal.pP.d;
import com.aspose.imaging.internal.qA.c;
import com.aspose.imaging.j;
import com.aspose.imaging.k;
import com.aspose.imaging.m;
import com.aspose.imaging.multithreading.InterruptMonitor;
import com.aspose.imaging.n;
import com.aspose.imaging.o;
import com.aspose.imaging.p;
import com.aspose.imaging.progressmanagement.EventType;
import com.aspose.imaging.progressmanagement.ProgressEventHandlerInfo;
import com.aspose.imaging.sources.StreamSource;
import com.aspose.imaging.system.Enum;
import com.aspose.imaging.system.IDisposable;
import com.aspose.imaging.system.io.FileStream;
import com.aspose.imaging.system.io.Stream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;

public abstract class Image
extends DataStreamSupporter
implements IObjectWithBounds,
com.aspose.imaging.internal.jz.b,
com.aspose.imaging.internal.jz.c {
    public static final f<com.aspose.imaging.internal.aK.g> e = new f();
    public static final f<e> f = new f();
    public static final f<com.aspose.imaging.internal.aK.a> g = new f();
    private WeakReference<Image> j = new WeakReference<Object>(null);
    private IColorPalette k;
    private Object l;
    private boolean m = false;
    private boolean n;
    private InterruptMonitor o;
    private final AtomicReference<i> p = new AtomicReference<Object>(null);
    private ProgressEventHandlerInfo q;
    private u r;
    private boolean s = false;
    private final Color t = Color.getWhite();
    protected StreamContainer h;
    private l u;
    public com.aspose.imaging.internal.iW.o i;
    private static final String v = "Cannot open an image. The image file format may be not supported at the moment.";
    private boolean w;

    protected Image() {
    }

    protected Image(IColorPalette iColorPalette) {
        this.k = iColorPalette;
    }

    public static boolean canLoad(String string) {
        return Image.canLoad(string, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean canLoad(String string, LoadOptions loadOptions) {
        Object object = SyncOperation;
        synchronized (object) {
            boolean bl2;
            FileStream fileStream = com.aspose.imaging.internal.lO.k.a(string, 3, 3, 3);
            try {
                bl2 = Image.a((Stream)fileStream, loadOptions);
            }
            catch (Throwable throwable) {
                fileStream.dispose();
                throw throwable;
            }
            fileStream.dispose();
            return bl2;
        }
    }

    public static boolean canLoad(InputStream inputStream) {
        return Image.c(Stream.fromJava(inputStream));
    }

    public static boolean c(Stream stream) {
        return Image.a(stream, null);
    }

    public static boolean canLoad(InputStream inputStream, LoadOptions loadOptions) {
        return Image.a(Stream.fromJava(inputStream), loadOptions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean a(Stream stream, LoadOptions loadOptions) {
        boolean bl2;
        cp cp2 = cq.a().a(stream);
        try {
            bl2 = ImageLoadersRegistry.a(cp2, loadOptions) != null;
        }
        finally {
            cq.a().a(cp2);
        }
        return bl2;
    }

    public static Image create(ImageOptionsBase imageOptionsBase, int n2, int n3) {
        if (imageOptionsBase == null) {
            throw new ArgumentNullException("imageOptions");
        }
        if (imageOptionsBase.getSource() == null) {
            throw new ArgumentNullException("imageOptions", "Please specify source for the image creation.");
        }
        if (n2 <= 0) {
            throw new ArgumentOutOfRangeException("width", "Expected positive width value.");
        }
        if (n3 <= 0) {
            throw new ArgumentOutOfRangeException("height", "Expected positive height value.");
        }
        boolean[] blArray = new boolean[]{false};
        return com.aspose.imaging.internal.bj.g.a(Image.a(imageOptionsBase, n2, n3, Image.a(com.aspose.imaging.internal.iW.m.a(Image.class.getSimpleName()), null, blArray)), blArray[0]);
    }

    public static Image create(Image[] imageArray) {
        boolean[] blArray = new boolean[]{false};
        return com.aspose.imaging.internal.bj.g.a(new bi(imageArray, false, Image.a(com.aspose.imaging.internal.iW.m.a(bi.class.getSimpleName()), null, blArray)), blArray[0]);
    }

    public static Image create(Image[] imageArray, boolean bl2) {
        boolean[] blArray = new boolean[]{false};
        return com.aspose.imaging.internal.bj.g.a(new bi(imageArray, bl2, Image.a(com.aspose.imaging.internal.iW.m.a(Image.class.getSimpleName()), null, blArray)), blArray[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getFileFormat(String string) {
        FileStream fileStream = com.aspose.imaging.internal.lO.k.a(string, 3, 1, 1);
        cp cp2 = cq.a().a(fileStream);
        try {
            long l2 = Image.f(cp2);
            return l2;
        }
        finally {
            cp2.e();
            if (cp2.a() <= 0) {
                cp2.dispose();
            }
            fileStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Image load(String string, LoadOptions loadOptions) {
        FileStreamContainer fileStreamContainer = FileStreamContainer.openFileStream(string, true);
        boolean bl2 = true;
        try {
            boolean[] blArray = new boolean[]{false};
            Image image = com.aspose.imaging.internal.bj.g.a(Image.a(fileStreamContainer, loadOptions, Image.a(com.aspose.imaging.internal.iW.m.a(Image.class.getSimpleName()), loadOptions, blArray)), blArray[0]);
            bl2 = false;
            Image image2 = image;
            return image2;
        }
        finally {
            if (bl2) {
                fileStreamContainer.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Image load(String string) {
        FileStreamContainer fileStreamContainer = FileStreamContainer.openFileStream(string, true);
        boolean bl2 = true;
        try {
            boolean[] blArray = new boolean[]{false};
            Image image = com.aspose.imaging.internal.bj.g.a(Image.a(fileStreamContainer, null, Image.a(com.aspose.imaging.internal.iW.m.a(Image.class.getSimpleName()), null, blArray)), blArray[0]);
            bl2 = false;
            Image image2 = image;
            return image2;
        }
        finally {
            if (bl2) {
                fileStreamContainer.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Image load(RandomAccessFile randomAccessFile, LoadOptions loadOptions) {
        a a2 = new a(randomAccessFile);
        boolean bl2 = true;
        try {
            Image image = Image.b(a2, loadOptions);
            bl2 = false;
            Image image2 = image;
            return image2;
        }
        finally {
            if (bl2) {
                a2.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Image load(RandomAccessFile randomAccessFile) {
        a a2 = new a(randomAccessFile);
        boolean bl2 = true;
        try {
            Image image = Image.b(a2, null);
            bl2 = false;
            Image image2 = image;
            return image2;
        }
        finally {
            if (bl2) {
                a2.close();
            }
        }
    }

    public static Image load(InputStream inputStream, LoadOptions loadOptions) {
        return Image.b(Stream.fromJava(inputStream), loadOptions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Image b(Stream stream, LoadOptions loadOptions) {
        boolean bl2 = loadOptions != null && loadOptions.e();
        StreamContainer streamContainer = new StreamContainer(stream, 0L, bl2);
        boolean bl3 = true;
        try {
            boolean[] blArray = new boolean[]{false};
            Image image = com.aspose.imaging.internal.bj.g.a(Image.a(streamContainer, loadOptions, Image.a(com.aspose.imaging.internal.iW.m.a(Image.class.getSimpleName()), null, blArray)), blArray[0]);
            bl3 = false;
            Image image2 = image;
            return image2;
        }
        finally {
            if (bl3) {
                streamContainer.dispose();
            }
        }
    }

    public static Image load(InputStream inputStream) {
        return Image.d(Stream.fromJava(inputStream));
    }

    public static Image d(Stream stream) {
        boolean[] blArray = new boolean[]{false};
        return com.aspose.imaging.internal.bj.g.a(Image.a(stream, null, Image.a(com.aspose.imaging.internal.iW.m.a(Image.class.getSimpleName()), null, blArray)), blArray[0]);
    }

    public static Image c(Stream stream, LoadOptions loadOptions) {
        boolean[] blArray = new boolean[]{false};
        return com.aspose.imaging.internal.bj.g.a(Image.a(stream, loadOptions, Image.a(com.aspose.imaging.internal.iW.m.a(Image.class.getSimpleName()), null, blArray)), blArray[0]);
    }

    public static Image a(Stream stream, LoadOptions loadOptions, com.aspose.imaging.internal.iW.o o2) {
        StreamContainer streamContainer = new StreamContainer(stream, 0L, false);
        return Image.a(streamContainer, loadOptions, o2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Image a(Stream stream, long l2, LoadOptions loadOptions, com.aspose.imaging.internal.iW.o o2) {
        boolean bl2 = loadOptions != null && loadOptions.e();
        StreamContainer streamContainer = new StreamContainer(stream, 0L, bl2);
        streamContainer.setPosition(l2);
        boolean bl3 = true;
        try {
            Image image = Image.a(streamContainer, loadOptions, o2);
            bl3 = false;
            Image image2 = image;
            return image2;
        }
        finally {
            if (bl3) {
                streamContainer.close();
            }
        }
    }

    public static Image a(Stream stream, long l2) {
        return Image.a(stream, l2, null, null);
    }

    public static Image e(Stream stream) {
        return Image.a(stream, 0L, null, null);
    }

    public static long getFileFormat(InputStream inputStream) {
        return Image.f(Stream.fromJava(inputStream));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long f(Stream stream) {
        cp cp2 = cq.a().a(stream);
        Object object = cp2.getSyncRoot();
        synchronized (object) {
            long l2;
            try {
                l2 = Image.a((Stream)cp2, false);
                cq.a().a(cp2);
            }
            catch (Throwable throwable) {
                cq.a().a(cp2);
                throw throwable;
            }
            return l2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long a(Stream stream, boolean bl2) {
        long l2 = 0L;
        long l3 = stream.getPosition();
        IImageLoaderDescriptor iImageLoaderDescriptor = ImageLoadersRegistry.a(stream, null, false);
        if (iImageLoaderDescriptor != null) {
            l2 = iImageLoaderDescriptor.getSupportedFormat();
        } else if (!bl2) {
            stream.setPosition(l3);
            try {
                Stream stream2 = com.aspose.imaging.internal.kk.b.a(stream);
                if (stream2 == null) {
                    long l4 = l2;
                    return l4;
                }
                try {
                    long l5 = Image.a(stream2, true);
                    stream2.dispose();
                    return l5;
                }
                catch (Throwable throwable) {
                    try {
                        stream2.dispose();
                        throw throwable;
                    }
                    catch (RuntimeException runtimeException) {
                        long l6 = 0L;
                        return l6;
                    }
                }
            }
            finally {
                stream.setPosition(l3);
            }
        }
        return l2;
    }

    public static Rectangle getFittingRectangle(Rectangle rectangle, int n2, int n3) {
        Rectangle rectangle2 = Rectangle.intersect(rectangle, new Rectangle(new Point(), new Size(bC.a(n2), bC.a(n3))));
        if (rectangle2.getWidth() <= 0 || rectangle2.getHeight() <= 0) {
            throw new ArgumentException("The rectangle has no common processing area. Cannot proceed.");
        }
        return rectangle2;
    }

    public static Rectangle getFittingRectangle(Rectangle rectangle, int[] nArray, int n2, int n3) {
        if (nArray == null) {
            throw new ArgumentNullException("pixels");
        }
        Rectangle rectangle2 = Image.getFittingRectangle(rectangle, n2, n3);
        if (nArray.length < rectangle2.getWidth() * rectangle2.getHeight()) {
            String string = aV.a("The passed rectangle does not correspond to pixels array size. Expected: {0} pixels, passed: {1} pixels.", new Object[]{rectangle2.getWidth() * rectangle2.getHeight(), nArray.length});
            throw new ImageException(string);
        }
        return rectangle2;
    }

    public static int getProportionalWidth(int n2, int n3, int n4) {
        double d2 = (double)n4 / (double)n3;
        return com.aspose.imaging.internal.qB.d.e(d2 * (double)n2 + 0.5);
    }

    public static int getProportionalHeight(int n2, int n3, int n4) {
        double d2 = (double)n4 / (double)n2;
        return com.aspose.imaging.internal.qB.d.e(d2 * (double)n3 + 0.5);
    }

    public D a(ImageOptionsBase imageOptionsBase, int n2, Rectangle rectangle) {
        throw new NotImplementedException();
    }

    public final boolean b(String string) {
        return this.a(string, null);
    }

    public final boolean a(String string, com.aspose.imaging.internal.iW.c c2) {
        if (com.aspose.imaging.internal.iW.l.d()) {
            com.aspose.imaging.internal.iW.l.a(new com.aspose.imaging.i(this), new j(this));
        }
        if (this.i == null) {
            this.i = new com.aspose.imaging.internal.iW.o();
        }
        for (com.aspose.imaging.internal.aK.a a2 : g.a()) {
            if (!a2.a(string, this.i, c2)) continue;
            this.a(this.i);
        }
        return true;
    }

    public final <T> boolean a(Class<T> clazz, String string) {
        return this.a(clazz, string, null);
    }

    public final <T> boolean a(Class<T> clazz, String string, com.aspose.imaging.internal.iW.c c2) {
        List<com.aspose.imaging.internal.aK.a> list;
        if (com.aspose.imaging.internal.iW.l.d()) {
            com.aspose.imaging.internal.iW.l.a(new k(this), new com.aspose.imaging.l(this));
        }
        if ((list = g.a()) == null) {
            return false;
        }
        if (this.i == null) {
            this.i = new com.aspose.imaging.internal.iW.o();
        }
        for (com.aspose.imaging.internal.aK.a a2 : list) {
            if (!a2.a(com.aspose.imaging.internal.iW.m.a(clazz.getSimpleName(), string), this.i, c2)) continue;
            this.a(this.i);
        }
        return true;
    }

    protected static void a(long[] lArray, Stream stream) {
        for (com.aspose.imaging.internal.aK.g g2 : e.a()) {
            g2.a(lArray, stream);
        }
    }

    private static void a(long[] lArray, long l2) {
        for (e e2 : f.a()) {
            e2.a(lArray, l2);
        }
    }

    public static com.aspose.imaging.internal.iW.o a(String string, LoadOptions loadOptions, boolean[] blArray) {
        List<com.aspose.imaging.internal.aK.a> list;
        blArray[0] = false;
        if (com.aspose.imaging.internal.iW.l.d()) {
            com.aspose.imaging.internal.iW.l.a(new m(), new n());
        }
        if ((list = g.a()) != null) {
            com.aspose.imaging.internal.iW.o o2 = null;
            if (loadOptions == null || !loadOptions.d()) {
                o2 = new com.aspose.imaging.internal.iW.o();
            }
            for (com.aspose.imaging.internal.aK.a a2 : list) {
                blArray[0] = a2.a(string, o2, null);
            }
            return o2;
        }
        return null;
    }

    private static void a(ProgressEventHandlerInfo progressEventHandlerInfo, EventType eventType) {
        if (progressEventHandlerInfo != null) {
            progressEventHandlerInfo.a(eventType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    private static Image a(ImageOptionsBase imageOptionsBase, int n2, int n3, com.aspose.imaging.internal.iW.o o2) {
        Object object;
        StreamSource streamSource = (StreamSource)((Object)com.aspose.imaging.internal.qB.d.a(imageOptionsBase.getSource(), StreamSource.class));
        Stream stream = streamSource != null ? streamSource.getStream() : null;
        Object object2 = object = cp.a(stream, stream == null ? new Object() : stream);
        synchronized (object2) {
            ProgressEventHandlerInfo progressEventHandlerInfo = null;
            if (imageOptionsBase.getProgressEventHandler() != null) {
                progressEventHandlerInfo = ProgressEventHandlerInfo.a(4);
                progressEventHandlerInfo.a(imageOptionsBase.getProgressEventHandler());
            }
            Image.a(progressEventHandlerInfo, EventType.Initialization);
            StreamContainer streamContainer = imageOptionsBase.getSource().getStreamContainer();
            boolean bl2 = true;
            try {
                Image image;
                block17: {
                    IImageCreator iImageCreator = ImageCreatorsRegistry.createFirstSupportedCreator(imageOptionsBase);
                    if (iImageCreator == null) {
                        throw new ImageLoadException("Cannot create a new image. The image file format may be not supported at the moment.");
                    }
                    Image.a(progressEventHandlerInfo, EventType.PreProcessing);
                    Image image2 = iImageCreator.create(streamContainer, imageOptionsBase, n2, n3);
                    try {
                        image2.q = progressEventHandlerInfo;
                        Image.a(progressEventHandlerInfo, EventType.Processing);
                        image2.a(streamContainer);
                        i i2 = imageOptionsBase.b() != null ? imageOptionsBase.b().f() : com.aspose.imaging.internal.jo.g.a(imageOptionsBase);
                        image2.a(i2, true);
                        image2.a(o2);
                        Image.a(progressEventHandlerInfo, EventType.Finalization);
                        if (!imageOptionsBase.a()) {
                            Image.a(image2.d, (long)image2.getWidth() * (long)image2.getHeight());
                        }
                        bl2 = false;
                        image = image2;
                        if (!bl2) break block17;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (bl2) {
                                image2.close();
                            }
                            throw throwable;
                        }
                        catch (RuntimeException runtimeException) {
                            throw new ImageCreateException("Image creation failed.", runtimeException);
                        }
                        catch (Error error) {
                            throw new ImageCreateException("Image creation failed.", error);
                        }
                    }
                    image2.close();
                }
                return image;
            }
            finally {
                if (bl2) {
                    streamContainer.close();
                }
            }
        }
    }

    /*
     * Exception decompiling
     */
    private static Image a(StreamContainer var0, LoadOptions var1_1, com.aspose.imaging.internal.iW.o var2_2) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public abstract int getBitsPerPixel();

    @Override
    public Rectangle getBounds() {
        this.verifyNotDisposed();
        return new Rectangle(Point.getEmpty(), this.getSize());
    }

    public Image getContainer() {
        return (Image)this.j.get();
    }

    @Override
    public abstract int getHeight();

    public IColorPalette getPalette() {
        return this.k;
    }

    public void setPalette(IColorPalette iColorPalette) {
        if (this.k != iColorPalette) {
            IColorPalette iColorPalette2 = this.k;
            this.onPaletteChanging(iColorPalette2, iColorPalette);
            this.k = iColorPalette;
            this.onPaletteChanged(iColorPalette2, iColorPalette);
        }
    }

    public boolean isUsePalette() {
        return false;
    }

    @Override
    public Size getSize() {
        this.verifyNotDisposed();
        return new Size(this.getWidth(), this.getHeight());
    }

    @Override
    public abstract int getWidth();

    public InterruptMonitor getInterruptMonitor() {
        return this.o;
    }

    public void setInterruptMonitor(InterruptMonitor interruptMonitor) {
        this.o = interruptMonitor;
    }

    public final int getBufferSizeHint() {
        return this.h().b();
    }

    public final void setBufferSizeHint(int n2) {
        i i2 = this.h();
        if (!aD.a(i2, com.aspose.imaging.internal.jo.i.a)) {
            i2.c(n2);
        }
    }

    public boolean isAutoAdjustPalette() {
        return this.n;
    }

    public void setAutoAdjustPalette(boolean bl2) {
        this.n = bl2;
    }

    public boolean hasBackgroundColor() {
        return this.s;
    }

    public long getFileFormat() {
        return 0L;
    }

    public Color getBackgroundColor() {
        return this.t;
    }

    public void setBackgroundColor(boolean bl2) {
        this.s = bl2;
    }

    public void setBackgroundColor(Color color) {
        color.CloneTo(this.t);
    }

    public boolean f() {
        return this.m;
    }

    public void d(boolean bl2) {
        this.m = bl2;
    }

    public final l g() {
        if (this.u == null) {
            this.u = new l();
        }
        return this.u;
    }

    public i h() {
        i i2 = this.p.get();
        return i2 != null ? i2 : com.aspose.imaging.internal.jo.i.a;
    }

    @Override
    public boolean C_() {
        return this.h().c();
    }

    public int i() {
        if (this.i == null && this.getContainer() != null) {
            this.i = this.getContainer().i;
        }
        if (this.i == null) {
            return 0;
        }
        return this.i.a();
    }

    @Override
    @com.aspose.imaging.internal.qB.g
    public final ProgressEventHandler getIProgressEventHandler() {
        if (this.q == null) {
            return null;
        }
        return this.q.a();
    }

    @Override
    @com.aspose.imaging.internal.qB.g
    public final ProgressEventHandlerInfo getProgressEventHandlerInfo() {
        return this.q;
    }

    public boolean canSave(ImageOptionsBase imageOptionsBase) {
        if (imageOptionsBase == null) {
            throw new ArgumentNullException("options");
        }
        this.verifyNotDisposed();
        return ImageExportersRegistry.getFirstSupportedDescriptor(this, imageOptionsBase) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resize(int n2, int n3) {
        Object object = this.c;
        synchronized (object) {
            try {
                this.b(true);
                this.resize(n2, n3, 7);
            }
            finally {
                this.c(true);
            }
            this.b(com.aspose.imaging.internal.iW.m.c());
        }
    }

    public abstract void resize(int var1, int var2, int var3);

    public abstract void resize(int var1, int var2, ImageResizeSettings var3);

    public ImageOptionsBase getDefaultOptions(Object[] objectArray) {
        return null;
    }

    public ImageOptionsBase getOriginalOptions() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resizeWidthProportionally(int n2) {
        Object object = this.c;
        synchronized (object) {
            boolean bl2 = this.b(2);
            try {
                this.b(bl2);
                this.resizeWidthProportionally(n2, 7);
            }
            finally {
                this.c(bl2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resizeHeightProportionally(int n2) {
        Object object = this.c;
        synchronized (object) {
            boolean bl2 = this.b(3);
            try {
                this.b(bl2);
                this.resizeHeightProportionally(n2, 7);
            }
            finally {
                this.c(bl2);
            }
        }
    }

    public void resizeWidthProportionally(int n2, int n3) {
        int n4 = Image.getProportionalHeight(this.getWidth(), this.getHeight(), n2);
        this.resize(n2, n4, n3);
    }

    public void resizeHeightProportionally(int n2, int n3) {
        int n4 = Image.getProportionalWidth(this.getWidth(), this.getHeight(), n2);
        this.resize(n4, n2, n3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resizeWidthProportionally(int n2, ImageResizeSettings imageResizeSettings) {
        Object object = this.c;
        synchronized (object) {
            try {
                this.b(true);
                int n3 = Image.getProportionalHeight(this.getWidth(), this.getHeight(), n2);
                this.resize(n2, n3, imageResizeSettings);
            }
            finally {
                this.c(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resizeHeightProportionally(int n2, ImageResizeSettings imageResizeSettings) {
        Object object = this.c;
        synchronized (object) {
            try {
                this.b(true);
                int n3 = Image.getProportionalWidth(this.getWidth(), this.getHeight(), n2);
                this.resize(n3, n2, imageResizeSettings);
            }
            finally {
                this.c(true);
            }
        }
    }

    public abstract void rotateFlip(int var1);

    @Override
    public final void save() {
        if (this.j.get() != null) {
            throw new FrameworkException("The result of this method is unpredictable since the current image has Container defined. Use the parent Container's Save() method instead.");
        }
        this.a(Image.class, com.aspose.imaging.internal.iW.m.c());
        super.save();
        if (this.h != null) {
            this.h.setPosition(0L);
            Stream stream = this.getDataStreamContainer().a();
            stream.setPosition(0L);
            com.aspose.imaging.internal.kk.b.a(stream, this.h.a());
        }
    }

    @Override
    public void save(String string) {
        ImageOptionsBase imageOptionsBase;
        if (string == null) {
            throw new ArgumentNullException("filePath");
        }
        this.a(Image.class, com.aspose.imaging.internal.iW.m.c());
        if (!this.a(string) && (imageOptionsBase = X.a(string, this)) != null) {
            this.save(string, imageOptionsBase);
            return;
        }
        super.save(string);
    }

    public void save(String string, ImageOptionsBase imageOptionsBase) {
        this.save(string, imageOptionsBase, Rectangle.getEmpty());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(String string, ImageOptionsBase imageOptionsBase, Rectangle rectangle) {
        this.verifyNotDisposed();
        if (imageOptionsBase == null) {
            throw new ArgumentNullException("options");
        }
        X.a(string, imageOptionsBase);
        try {
            FileStream fileStream = com.aspose.imaging.internal.lO.k.b(string);
            try {
                this.a(fileStream, imageOptionsBase, rectangle);
                fileStream.flush();
            }
            finally {
                fileStream.dispose();
            }
        }
        catch (OperationInterruptedException operationInterruptedException) {
            throw operationInterruptedException;
        }
        catch (Error error) {
            throw new ImageLoadException("Image saving failed.", error);
        }
        catch (ImageSaveException imageSaveException) {
            throw imageSaveException;
        }
        catch (RuntimeException runtimeException) {
            throw new ImageSaveException("Image saving failed.", runtimeException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(RandomAccessFile randomAccessFile, ImageOptionsBase imageOptionsBase) {
        a a2 = new a(randomAccessFile);
        try {
            this.a(a2, imageOptionsBase, Rectangle.getEmpty());
        }
        finally {
            a2.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(RandomAccessFile randomAccessFile, ImageOptionsBase imageOptionsBase, Rectangle rectangle) {
        a a2 = new a(randomAccessFile);
        try {
            this.a(a2, imageOptionsBase, rectangle);
        }
        finally {
            a2.dispose();
        }
    }

    public void save(OutputStream outputStream, ImageOptionsBase imageOptionsBase) {
        if (outputStream instanceof d) {
            this.a(((d)outputStream).a(), imageOptionsBase, Rectangle.getEmpty());
        } else {
            com.aspose.imaging.internal.qA.c.a(new o(this, outputStream, imageOptionsBase));
        }
    }

    public void save(OutputStream outputStream, ImageOptionsBase imageOptionsBase, Rectangle rectangle) {
        if (outputStream instanceof d) {
            this.a(((d)outputStream).a(), imageOptionsBase, rectangle);
        } else {
            com.aspose.imaging.internal.qA.c.a(new p(this, outputStream, imageOptionsBase, rectangle));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void a(Stream stream, ImageOptionsBase imageOptionsBase, Rectangle rectangle) {
        this.verifyNotDisposed();
        if (imageOptionsBase == null) {
            throw new ArgumentNullException("optionsBase");
        }
        if (!(rectangle.isEmpty() || rectangle.getWidth() > 0 && rectangle.getHeight() > 0)) {
            throw new ArgumentOutOfRangeException("boundsRectangle", "Rectangle should have positive width and height");
        }
        boolean bl2 = false;
        try {
            Object object;
            Object object2 = this.c;
            synchronized (object2) {
                this.isRecursiveCall = bl2 = this.isSameSourceStream_internalized(stream);
                this.MutuallyExclusiveOperationIsNotRunningEvent_internalized.waitOne();
                if (imageOptionsBase.getProgressEventHandler() != null) {
                    this.q = ProgressEventHandlerInfo.a(4);
                    this.q.a(imageOptionsBase.getProgressEventHandler());
                } else if (this.q != null) {
                    this.q.b(this.q.getMaxValue() + 4);
                    imageOptionsBase.setProgressEventHandler(this.q.a());
                }
                object = this.SyncNonExclusiveOperation_internalized;
                synchronized (object) {
                    if (this.NonExclusiveRunningOperationsCount_internalized.incrementAndGet() > 0) {
                        this.NonMutuallyExclusiveOperationIsNotRunningEvent_internalized.reset();
                    }
                }
            }
            this.a(Image.class, com.aspose.imaging.internal.iW.m.c(), new com.aspose.imaging.internal.iW.g(imageOptionsBase));
            Image.a(this.q, EventType.Initialization);
            object2 = ImageExportersRegistry.createFirstSupportedExporter(this, imageOptionsBase);
            if (object2 == null) {
                object = this.getCanNotSaveMessage(imageOptionsBase);
                throw new ArgumentException((String)object, "optionsBase");
            }
            object = this.a(imageOptionsBase, rectangle, (IImageExporter)object2);
            Image image = ((aL)object).c();
            cp cp2 = null;
            try {
                Image.a(this.q, EventType.PreProcessing);
                image.a(image.i);
                cp2 = cq.a().a(stream);
                Object object3 = cp2.getSyncRoot();
                synchronized (object3) {
                    cp2.setPosition(0L);
                    image.tryCacheImage(cp2);
                    Image.a(this.q, EventType.Processing);
                    object2.export(image, cp2.toOutputStream(), imageOptionsBase, rectangle);
                    Image.a(this.q, EventType.Finalization);
                    this.b(cp2);
                }
                cq.a().a(cp2);
                ((aL)object).a();
            }
            catch (Throwable throwable) {
                cq.a().a(cp2);
                ((aL)object).a();
                throw throwable;
            }
        }
        catch (OperationInterruptedException operationInterruptedException) {
            throw operationInterruptedException;
        }
        catch (RuntimeException runtimeException) {
            throw new ImageSaveException("Image export failed.", runtimeException);
        }
        finally {
            Object object = this.SyncNonExclusiveOperation_internalized;
            synchronized (object) {
                if (bl2) {
                    this.isRecursiveCall = false;
                }
                if (this.NonExclusiveRunningOperationsCount_internalized.decrementAndGet() <= 0) {
                    this.NonMutuallyExclusiveOperationIsNotRunningEvent_internalized.set();
                }
            }
        }
    }

    public abstract void setPalette(IColorPalette var1, boolean var2);

    public Object j() {
        return this.l;
    }

    public void a(Object object) {
        this.l = object;
    }

    public boolean a(com.aspose.imaging.internal.iW.o o2) {
        if (o2 == null) {
            return false;
        }
        if (com.aspose.imaging.internal.iW.l.d()) {
            throw new FrameworkException("Plugin license is not ready");
        }
        if (this.i == null || this.i != o2) {
            this.i = o2;
        }
        return true;
    }

    public void a(Image image) {
        this.j = new WeakReference<Image>(image);
        this.k();
    }

    public final void a(EventType eventType) {
        if (this.q != null) {
            this.q.c(this.q.getValue() + 1);
            this.q.a(eventType, this.q.getValue());
        }
    }

    public final void a(int n2) {
        if (this.q != null) {
            this.q.b(this.q.getMaxValue() + n2);
        }
    }

    public void k() {
        Image image = this.getContainer();
        if (image != null) {
            this.a(image.i);
        } else {
            this.a((com.aspose.imaging.internal.iW.o)null);
        }
    }

    public void a(i i2, boolean bl2) {
        if (this.w) {
            i i3 = this.p.getAndSet(aD.a(i2, com.aspose.imaging.internal.jo.i.a) ? null : i2);
            if (i3 != null && !aD.a(i3, i2)) {
                i3.dispose();
            }
        } else {
            this.p.set(aD.a(i2, com.aspose.imaging.internal.jo.i.a) ? null : i2);
        }
        this.w = bl2;
    }

    protected boolean b(int n2) {
        return false;
    }

    protected String getCanNotSaveMessage(ImageOptionsBase imageOptionsBase) {
        return "Cannot save to the specified format as it is not supported at the moment";
    }

    public Image a(ImageOptionsBase imageOptionsBase) {
        return this;
    }

    public boolean l() {
        Image image = (Image)this.j.get();
        return this.n || image != null && image.l();
    }

    public final boolean m() {
        return this.r != null;
    }

    protected Rectangle getFitRectangle(Rectangle rectangle) {
        return Image.getFittingRectangle(rectangle, this.getWidth(), this.getHeight());
    }

    protected Image getImage2Export(ImageOptionsBase imageOptionsBase, Rectangle rectangle, IImageExporter iImageExporter) {
        return this;
    }

    public aL a(ImageOptionsBase imageOptionsBase, Rectangle rectangle, IImageExporter iImageExporter) {
        return new aL(this.getImage2Export(imageOptionsBase, rectangle, iImageExporter), false);
    }

    protected Rectangle getFitRectangle(Rectangle rectangle, int[] nArray) {
        return Image.getFittingRectangle(rectangle, nArray, this.getWidth(), this.getHeight());
    }

    protected void onPaletteChanged(IColorPalette iColorPalette, IColorPalette iColorPalette2) {
    }

    protected void onPaletteChanging(IColorPalette iColorPalette, IColorPalette iColorPalette2) {
        this.b(com.aspose.imaging.internal.iW.m.c());
    }

    protected final void releaseResources() {
        this.k = null;
        i i2 = this.p.getAndSet(null);
        if (i2 != null && this.w) {
            i2.dispose();
        }
        if (this.u != null) {
            this.u.dispose();
        }
        if (this.r != null) {
            com.aspose.imaging.internal.la.w.b().b(this.r);
        }
    }

    protected void releaseReferences() {
        this.releaseResources();
    }

    @Override
    protected void releaseManagedResources() {
        this.releaseResources();
        if (this.h != null) {
            try {
                IDisposable iDisposable;
                StreamContainer streamContainer = this.h;
                Stream stream = streamContainer.a();
                if (stream instanceof cp) {
                    iDisposable = (cp)stream;
                    ((cp)iDisposable).e();
                    if (((cp)iDisposable).a() <= 0) {
                        ((cp)iDisposable).dispose();
                        streamContainer.dispose();
                    }
                } else {
                    stream.dispose();
                    streamContainer.dispose();
                }
                iDisposable = this.getDataStreamContainer();
                Stream stream2 = ((StreamContainer)iDisposable).a();
                if (com.aspose.imaging.internal.qB.d.b((Object)stream2, cp.class)) {
                    cp cp2 = (cp)stream2;
                    Stream stream3 = cp2.b();
                    String string = stream3 instanceof FileStream ? ((FileStream)stream3).getName() : null;
                    stream2.dispose();
                    ((DisposableObject)iDisposable).dispose();
                    if (com.aspose.imaging.internal.lO.k.e(string)) {
                        com.aspose.imaging.internal.lO.k.d(string);
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        super.releaseManagedResources();
    }

    static {
        new com.aspose.imaging.internal.kl.b().run();
    }

    protected static final class ImageOperation
    extends Enum {
        public static final int Blend = 0;
        public static final int Resize = 1;
        public static final int ResizeWidthProportionally = 2;
        public static final int ResizeHeightProportionally = 3;
        public static final int Filter = 4;
        public static final int LoadPixels = 5;
        public static final int SavePixels = 6;
        public static final int Crop = 7;
        public static final int BinarizeFixed = 8;
        public static final int BinarizeOtsu = 9;
        public static final int BinarizeBradley = 10;
        public static final int Grayscale = 11;
        public static final int AdjustBrightness = 12;
        public static final int AdjustContrast = 13;
        public static final int AdjustGamma = 14;
        public static final int Rotate = 15;
        public static final int RotateFlip = 16;

        private ImageOperation() {
        }

        static {
            Enum.register(new a());
        }

        private static final class a
        extends Enum.SimpleEnum {
            a() {
                super(ImageOperation.class, Integer.class);
                this.addConstant("Blend", 0L);
                this.addConstant("Resize", 1L);
                this.addConstant("ResizeWidthProportionally", 2L);
                this.addConstant("ResizeHeightProportionally", 3L);
                this.addConstant("Filter", 4L);
                this.addConstant("LoadPixels", 5L);
                this.addConstant("SavePixels", 6L);
                this.addConstant("Crop", 7L);
                this.addConstant("BinarizeFixed", 8L);
                this.addConstant("BinarizeOtsu", 9L);
                this.addConstant("BinarizeBradley", 10L);
                this.addConstant("Grayscale", 11L);
                this.addConstant("AdjustBrightness", 12L);
                this.addConstant("AdjustContrast", 13L);
                this.addConstant("AdjustGamma", 14L);
                this.addConstant("Rotate", 15L);
                this.addConstant("RotateFlip", 16L);
            }
        }
    }
}

