/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.uploadlarge;

import java.io.File;
import java.util.List;
import org.zhiqim.httpd.HttpContext;
import org.zhiqim.httpd.context.core.Context;
import org.zhiqim.kernel.logging.Log;
import org.zhiqim.kernel.logging.LogFactory;
import org.zhiqim.kernel.schedule.Task;
import org.zhiqim.kernel.util.DateTimes;
import org.zhiqim.kernel.util.Validates;
import org.zhiqim.orm.dbo.Selector;
import org.zhiqim.uploadlarge.ZulBootstrap;
import org.zhiqim.uploadlarge.ZulConstants;
import org.zhiqim.uploadlarge.ZulDao;
import org.zhiqim.uploadlarge.dbo.UpllChunk;

public class ZulTask
implements ZulConstants,
Task {
    private static final Log log = LogFactory.getLog(ZulTask.class);
    private Context context;

    public ZulTask(Context context) {
        this.context = context;
    }

    public void execute() {
        String datetime = String.valueOf(DateTimes.getDateString()) + " 00:00:00";
        String chunkTime = DateTimes.getPreviousDateTimeString((String)datetime, (int)1);
        Selector selector = (Selector)new Selector().addMustThenL("chunkTime", (Object)chunkTime);
        try {
            List list = ZulBootstrap.table((HttpContext)this.context).list(UpllChunk.class, selector);
            int size = list.size();
            int error = 0;
            for (UpllChunk chunk : list) {
                String filePath = ZulDao.getFilePath(chunk);
                if (Validates.isEmptyBlank((String)filePath)) {
                    ZulBootstrap.table((HttpContext)this.context).delete(UpllChunk.class, new Object[]{chunk.getFileMd5(), chunk.getChunkSize()});
                    continue;
                }
                File file = new File(filePath);
                if (!file.exists()) {
                    ZulBootstrap.table((HttpContext)this.context).delete(UpllChunk.class, new Object[]{chunk.getFileMd5(), chunk.getChunkSize()});
                    continue;
                }
                if (file.delete()) {
                    ZulBootstrap.table((HttpContext)this.context).delete(UpllChunk.class, new Object[]{chunk.getFileMd5(), chunk.getChunkSize()});
                    continue;
                }
                ++error;
            }
            log.info((Object)"\u5220\u9664[%s]\u4e4b\u524d\u7684\u788e\u7247\u6587\u4ef6\u5b8c\u6210\uff0c\u603b[%s]\uff0c\u5931\u8d25[%s]...", new Object[]{chunkTime, size, error});
        }
        catch (Exception e) {
            log.error((Object)"\u5220\u9664[%s]\u4e4b\u524d\u7684\u788e\u7247\u6587\u4ef6\u65f6\u5f02\u5e38", new Object[]{chunkTime, e});
        }
    }
}

