/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.uploadlarge;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.zhiqim.httpd.HttpContext;
import org.zhiqim.httpd.HttpExecutor;
import org.zhiqim.httpd.HttpRequest;
import org.zhiqim.httpd.HttpResponse;
import org.zhiqim.httpd.constants.HttpMimeType;
import org.zhiqim.kernel.util.DateTimes;
import org.zhiqim.kernel.util.Files;
import org.zhiqim.kernel.util.Streams;
import org.zhiqim.kernel.util.Strings;
import org.zhiqim.kernel.util.Urls;
import org.zhiqim.kernel.util.Validates;
import org.zhiqim.uploadlarge.ZulConstants;
import org.zhiqim.uploadlarge.ZulDao;
import org.zhiqim.uploadlarge.ZulUploader;
import org.zhiqim.uploadlarge.dbo.UpllFile;

public class ZulAccessService
implements HttpExecutor,
ZulConstants {
    private String access = null;

    public boolean isMatch(String pathInContext) {
        return Validates.isMatch((String)pathInContext, (String)"/service/upll/*");
    }

    public void handle(HttpRequest request, HttpResponse response) throws IOException {
        String ext;
        HttpContext context = request.getContext();
        if (this.access == null) {
            this.access = context.getAttributeString("upload.large.access", "");
        }
        if (Validates.isNotEmpty((String)this.access)) {
            try {
                request.forwardTo(this.access);
            }
            catch (Exception exception) {
                response.sendHeader(500);
            }
            return;
        }
        String fileName = Strings.lastIndexOfString((String)request.getPathInContext(), (String)"/");
        String fileExt = Files.getFileExt((String)fileName);
        String fileId = Strings.removeEndsWith((String)fileName, (String)("." + fileExt));
        UpllFile upload = null;
        try {
            upload = ZulUploader.getFile(request, fileId);
        }
        catch (Exception exception) {
            response.sendHeader(500);
            return;
        }
        if (upload == null) {
            response.sendError(404);
            return;
        }
        File file = new File(ZulDao.getFilePath(upload));
        if (!file.exists() || !file.isFile()) {
            response.sendError(404);
            return;
        }
        if (file.isHidden() || !file.canRead()) {
            response.sendError(403);
            return;
        }
        if (Validates.isNotEmpty((String)fileExt) && !fileExt.equals(ext = Files.getFileExt((String)ZulDao.getFilePath(upload)))) {
            response.sendError(404);
            return;
        }
        String contentType = upload.getContentType();
        if (Validates.isEmptyBlank((String)contentType) || "application/octet-stream".equals(contentType)) {
            contentType = HttpMimeType.getResourceMimeType((String)fileExt);
        }
        response.setContentType(contentType);
        if (!Validates.isContain((String)"html,js,css,png,jpg,gif", (String)",", (String)fileExt)) {
            String downName = Urls.encodeUTF8((String)upload.getFileName());
            if (request.isChrome()) {
                downName = downName.replaceAll("%28", "(");
                downName = downName.replaceAll("%29", ")");
            }
            if (request.isFirefox()) {
                response.setHeader("Content-Disposition", (Object)("attachment; filename*=UTF-8''" + upload.getFileName()));
            } else {
                response.setHeader("Content-Disposition", (Object)("attachment; filename=" + downName));
            }
        }
        if (Validates.isNotEmpty((String)upload.getCacheControl())) {
            response.setCacheControl(upload.getCacheControl());
        }
        long lastModified = file.lastModified();
        String lastModifiedTime = DateTimes.getDateTimeHttp((long)lastModified);
        String ifModifiedSince = request.getHeader("If-Modified-Since");
        if (ifModifiedSince != null && ifModifiedSince.indexOf(lastModifiedTime) != -1) {
            response.sendHeader(304);
            return;
        }
        response.setHeader("Accept-Ranges", (Object)"bytes");
        response.setHeader("Last-Modified", (Object)lastModifiedTime);
        response.setHeader("Content-Length", (Object)file.length());
        if (request.isMethodResponseContent()) {
            FileInputStream fis = new FileInputStream(file);
            Streams.putBytes((InputStream)fis, (OutputStream)response.getOutputStream());
        }
        response.commit();
    }
}

