/*
 * Decompiled with CFR 0.152.
 */
package com.zhiqim.oss.service;

import com.zhiqim.oss.service.oss.OssDownloadService;
import com.zhiqim.oss.service.oss.OssService;
import com.zhiqim.oss.service.oss.OssUploadService;
import org.zhiqim.kernel.Global;
import org.zhiqim.kernel.Servicer;
import org.zhiqim.kernel.config.Group;
import org.zhiqim.kernel.httpclient.HttpPostStream;
import org.zhiqim.kernel.util.Strings;
import org.zhiqim.kernel.util.Validates;

public class OssServer
extends Servicer {
    private String endpointExternal = "http://oss-cn-shenzhen.aliyuncs.com";
    private String endpointInternal = "http://oss-cn-shenzhen-internal.aliyuncs.com";
    private String accessKeyId = "";
    private String accessKeySecret = "";
    private int connectTimeout = 10;
    private int readTimeout = 30;
    private String ossForward = "";

    public boolean create() throws Exception {
        Group group = Global.getGroup((String)this.id);
        this.endpointExternal = group.getString("endpointExternal");
        this.endpointInternal = group.getString("endpointInternal");
        this.accessKeyId = group.getString("accessKeyId");
        this.accessKeySecret = group.getString("accessKeySecret");
        this.ossForward = group.getString("ossForward");
        Global.add(OssService.class, (Object)new OssService(this));
        Global.add(OssUploadService.class, (Object)new OssUploadService(this));
        Global.add(OssDownloadService.class, (Object)new OssDownloadService(this));
        return true;
    }

    public byte[] invokeForwardService(String queryString) throws Exception {
        if (!this.isOssForward()) {
            throw new Exception("\u8be5\u6587\u4ef6\u65e0\u987b\u900f\u4f20\u4e0b\u8f7d");
        }
        HttpPostStream client = new HttpPostStream(this.ossForward);
        client.setQueryString(queryString, "UTF-8");
        client.setConnectTimeout(this.connectTimeout);
        client.setReadTimeout(this.readTimeout);
        client.execute();
        int responseStatus = client.getResponseStatus();
        if (responseStatus != 200) {
            throw new Exception("\u8c03\u7528\u4e0b\u8f7doss\u63a5\u53e3\u900f\u4f20\u65f6\u9519\u8bef,\u9519\u8bef\u7801[" + responseStatus + "][" + client.getResponseText() + "]");
        }
        return client.getBytes();
    }

    public void checkKey(String key) throws Exception {
        if (Validates.isEmpty((String)key) || Strings.startsWith((String)key, (String)"/")) {
            throw new Exception("key\u957f\u5ea6\u5fc5\u987b\u5728 1-1023\u5b57\u8282\u4e4b\u95f4\uff0c\u800c\u4e14\u4e0d\u80fd\u5305\u542b\u56de\u8f66\u3001\u6362\u884c\u3001\u4ee5\u53caxml1.0\u4e0d\u652f\u6301\u7684\u5b57\u7b26\uff0c\u540c\u65f6\u4e5f\u4e0d\u80fd\u4ee5/\u6216\u8005\\\u5f00\u5934");
        }
    }

    public boolean isOssForward() {
        return Validates.isNotEmpty((String)this.ossForward);
    }

    public String getEndpointExternal() {
        return this.endpointExternal;
    }

    public void setEndpointExternal(String endpointExternal) {
        this.endpointExternal = endpointExternal;
    }

    public String getEndpointInternal() {
        return this.endpointInternal;
    }

    public void setEndpointInternal(String endpointInternal) {
        this.endpointInternal = endpointInternal;
    }

    public String getAccessKeyId() {
        return this.accessKeyId;
    }

    public void setAccessKeyId(String accessKeyId) {
        this.accessKeyId = accessKeyId;
    }

    public String getAccessKeySecret() {
        return this.accessKeySecret;
    }

    public void setAccessKeySecret(String accessKeySecret) {
        this.accessKeySecret = accessKeySecret;
    }

    public String getOssForward() {
        return this.ossForward;
    }

    public void setOssForward(String ossForward) {
        this.ossForward = ossForward;
    }
}

