/*********************************************
**       素材特效处理
**********************************************/

/*********************************************
**    一： 通用处理
**********************************************/

//******* 1.1 素材翻转 **********//
function setReversal(material, $curElem, reversal)
{
    //获取素材，节点
    material = material || media.tool.tempMaterial || media.getCurMaterial();
    $curElem = $curElem || media.tool.tempElement || media.tool.getCurSvgElement();

    if (!material || !$curElem)
        return;

    //处理
    reversal = reversal || material.reversal;        //reversal = "1 1"
    if (!reversal) {
        return;
    }

    var reversalData = reversal.split(" ");
    var doHType = parseInt(reversalData[0]);
    var doVType = parseInt(reversalData[1]);

    var $gSvg = $curElem.querySelector("g");
    var $svg = $gSvg.querySelector("svg");
    var svgWidth = $svg.width.baseVal.value;
    var svgHeight = $svg.height.baseVal.value;

    var setX = doHType > 0 ? 0 : svgWidth;
    var setY = doVType > 0 ? 0 : svgHeight;

    var trans = "translate(" + setX + " " + setY + ") " + "scale(" + reversal + ")";
    $gSvg.setAttribute("transform", trans);
}

/*********************************************
**    二： 图片处理
**********************************************/

//******* 2.1 图片圆角 **********//
function setImageEffectRadius(imgRadius, material, $curElem)
{
    // 获取素材，节点
    material = material || media.tool.tempMaterial || media.getCurMaterial();
    $curElem = $curElem || media.tool.tempElement || media.tool.getCurSvgElement();

    if (!material || !$curElem)
        return;

    var $svg = $curElem.querySelector("svg");
    var $img = $svg.querySelector("image");
    material.type = parseFloat(material.type);

    // 处理
    if (material.type !== 0 && material.type !== 2) {
        return;
    }
    imgRadius = Math.round(imgRadius || material.imgRadius || 0);   // imgRadius = "11 11 11 11"
    material.imgRadius = imgRadius;
    // 判断圆角是否为0
    if (imgRadius === 0) {
        if ($img.hasAttribute("clip-path")) { Z($img).removeAttr("clip-path");}
        if ($defs) { Z($defs).remove();}
        return;
    }
    var viewBox = $svg.viewBox.baseVal;
    var clipId = "#radius_" + $curElem.id;
    var $defs = Z($svg).find(clipId).parent()[0];
    // 判断是否存在圆角节点
    if (!$defs)
    {
        // 移除所有可能存在的 $defs
        var $allDefs = Z($svg).find('[id^="radius_svgElementSon_"]');
        $allDefs.each(function(){
            Z(this).parent().remove();
        });
        // 移除绑定的 圆角
        $img.removeAttribute("clip-path");
        
        // 插入新的 $defs
        var defs = '<defs><clipPath id="radius_' + $curElem.id + '">';
        defs += '<rect x="' + viewBox.x + '" y="' + viewBox.y + '" width="' + viewBox.width + '" height="' + viewBox.height + '" rx="' + imgRadius + '%">';
        defs += '</rect></clipPath></defs>';
        $svg.insertAdjacentHTML("afterbegin",defs);
    } else {
        var $rect = Z($defs).find("rect")[0];
        $rect.setAttribute("x", viewBox.x);
        $rect.setAttribute("y", viewBox.y);
        $rect.setAttribute("width", viewBox.width);
        $rect.setAttribute("height", viewBox.height);
        $rect.setAttribute("rx", imgRadius + "%");
    }
    // 给 image 绑定 clip-path
    if (!$img.hasAttribute("clip-path")) {
        $img.setAttribute("clip-path", "url(" + clipId + ")");
    }
}


/*********************************************
**    三： 文字处理
**********************************************/

//******* 3.1 文字执行斜体操作 **********//
function setTextItalic(material, $curElem)
{
    // 获取参数，节点
    material = material || media.tool.tempMaterial || media.getCurMaterial();
    $curElem = $curElem || media.tool.tempElement || media.tool.getCurSvgElement();
    if (!material || !$curElem)
        return;
    // 执行操作
    textItalicFunction(material, $curElem, '-18', 1);
}

//******* 3.2 文字取消斜体操作 **********//
function cancelTextItalic(material, $curElem)
{
    // 获取参数，节点
    material = material || media.tool.tempMaterial || media.getCurMaterial();
    $curElem = $curElem || media.tool.tempElement || media.tool.getCurSvgElement();
    if (!material || !$curElem)
        return;
    // 执行操作
    textItalicFunction(material, $curElem, '0', 0);
}
// 文本斜体实现方法
function textItalicFunction(material, $curElem, skewVal, italicVal)
{
    // 设置每个字符
    function setEachPath()
    {
        // 根据是否存在横竖版，判断文字的偏移
        function setItalicStr()
        {
            pathText = $gPath.getAttribute('data-text').replace(/-%6-%-%0-/g, '<');
            if (material.textVertical !== 'normal' && !/[\u4e00-\u9fa5]/.test(pathText))
                italicStr = ' skewY(' + (0 - skewVal) + ')';
            else
                italicStr = ' skewX(' + skewVal + ')';
            italicReg = new RegExp(italicStr);
        }

        // 主方法
        for (i = 0;i < $$lines.length;i++)
        {
            $$gPath = $$lines[i].querySelectorAll(".font-path");
            for (j = 0;j < $$gPath.length;j++)
            {
                $gPath = $$gPath[j];
                // 设置斜体参数
                setItalicStr();
                pathTrans = $gPath.getAttribute("transform");
                if (italicReg.test(pathTrans))
                    continue;
                if (/\s?skew[XY]\(-?\d+\)/.test(pathTrans))
                    pathTrans = pathTrans.replace(/\s?skew[XY]\([^)]+\)/, italicStr);
                else
                    pathTrans += italicStr;
                $gPath.setAttribute("transform",pathTrans);
            }
        }
    }
    // 重新计算文字宽高
    function resetTextElemSize()
    {
        var $rect = $curElem.querySelector("rect");
        var lineLength = $$lines.length;

        // 去除翻转设置
        $gSvg.setAttribute('transform', 'translate(0 0) scale(1 1)');
        // 去除宽高设置
        $rect.setAttribute("width", "1");
        $rect.setAttribute("height", "1");
        $svg.removeAttribute("viewBox");
        $svg.removeAttribute("width");
        $svg.removeAttribute("height");

        // 获取最新的宽高
        var set_width, set_height;
        if (material.textVertical === 'normal')
        {
            var i = 0, lineWidth, widthArr = [], singleMax, set_view;
            // 每一行的宽度
            for (i;i < $$lines.length;i++)
            {
                lineWidth = $$lines[i].getBBox().width;
                $$lines[i].setAttribute('data-oldwidth', lineWidth);
                widthArr.push(lineWidth);
            }
            set_width = Math.max($curElem.getBBox().width, getMaxNum(widthArr));     // 素材宽度
            singleMax = getMaxNum([material.lineHeight, material.singleHeight]);
            set_height = material.lineHeight * (lineLength - 1) + singleMax;         // 素材高度
            set_view = "0 0 " + set_width + " " + set_height;
            material.width = set_width;
            material.height = set_height;
        } else {
            set_width = $curElem.getBBox().width;
            set_height = $curElem.getBBox().height;
        }

        $rect.setAttribute("width", set_width + "");
        $rect.setAttribute("height", set_height + "");
        $svg.setAttribute("viewBox", set_view + "");
        $svg.setAttribute("width", set_width + "");
        $svg.setAttribute("height", set_height + "");

    }

    // 1：定义变量
    var $gSvg = $curElem.querySelector("g");
    var $$svg = $gSvg.children;
    while ($$svg.length > 1)
        $gSvg.removeChild($$svg[0]);
    var $svg = $$svg[0];
    var $$lines = $svg.children;
    var i, j, $$gPath, italicStr, italicReg, $gPath, pathTrans, pathText;

    // 2：遍历每一行，执行处理
    setEachPath();

    // 3：定义 material 属性，如果存在wordsList
    material.fontItalic = italicVal;
    for (i = 0;i < material.wordsList.length;i++) {
        material.wordsList[i].fontItalic = material.fontItalic;
    }
    // 判断是否是特殊文字
    setTextMaterialData(material, $curElem);

    // 4：重新计算宽高
    resetTextElemSize();

    // 5：执行文字特效处理
    // 缩放
    if (material.textZoom !== '1 1') setTextZoom(null, material, $curElem);
    // 翻转
    setReversal(material, $curElem);
    // 特效
    doTextSpecialSet();
    // 校准
    editOverSet($curElem);
}

//******* 3.3 添加文字下划线 **********//
function setTextDecoration(material, $curElem)
{
    // 获取参数，节点
    $curElem = $curElem || media.tool.tempElement || media.tool.getCurSvgElement();
    material = material || media.tool.tempMaterial || media.getCurMaterial();
    if (!$curElem  || !material)
        return;
    // 执行操作
    textDecorationFunction(material, $curElem, 1);
}

//******* 3.4 取消文字下划线 **********//
function cancelTextDecoration(material, $curElem)
{
    // 获取参数，节点
    material = material || media.tool.tempMaterial || media.getCurMaterial();
    $curElem = $curElem || media.tool.tempElement || media.tool.getCurSvgElement();
    if (!material || !$curElem)
        return;

    // 执行操作
    textDecorationFunction(material, $curElem, 0);
}
// 文本下划线实现方法
function textDecorationFunction(material, $curElem, decorationVal)
{
    var $gSvg = $curElem.querySelector("g");
    var $$svg = $gSvg.children;
    while ($$svg.length > 1)
        $gSvg.removeChild($$svg[0]);
    var $svg = $$svg[0];
    var $$fontPaths = $svg.querySelectorAll(".font-path");
    var i, $gPath, $line, setX2, stroke;
    for (i = 0;i < $$fontPaths.length;i++)
    {
        $gPath = $$fontPaths[i];
        // 创建线条
        $line = $gPath.querySelector("line");
        if ($line) {
            $line.parentNode.removeChild($line);
        }
        if (!decorationVal){
            continue;
        }
        $line = document.createElementNS(xmlns, "line");
        setX2 = parseFloat($gPath.getAttribute("data-width")) + parseFloat(material.letterSpacing);
        stroke = material.wordsList[i].color;
        $line.setAttribute("x1", '0');
        $line.setAttribute("y1", material.underlineOffset);
        $line.setAttribute("x2", setX2);
        $line.setAttribute("y2", material.underlineOffset);
        $line.setAttribute("stroke", stroke);
        $line.setAttribute("stroke-width", material.underlineThickness);
        $gPath.appendChild($line);
    }

    // 定义 material 属性，如果存在wordsList
    material.textDecoration = decorationVal;
    for (i = 0;i < material.wordsList.length;i++) {
        material.wordsList[i].textDecoration = material.textDecoration;
    }
    // 判断是否是特殊文字
    setTextMaterialData(material, $curElem);
    // 特效
    doTextSpecialSet();
}

//******* 3.5 文字内多行文本对齐 **********//
function setElementAlign(alignType, material, $curElem)
{
    // 默认的偏移设置
    function doDefault($$gPaths)
    {
        var $gPath, trans;
        var setX = 0;
        var i = 0;
        var letterSpacing = parseFloat(material.letterSpacing + '');
        for (i;i < $$gPaths.length;i++)
        {
            $gPath = $$gPaths[i];
            setX = parseFloat($gPath.getAttribute('data-x')) + letterSpacing * i;
            trans = $gPath.getAttribute('transform');
            trans = trans.replace(/translate\s?\(\s?-?\d+(\.\d+)?/, 'translate(' + setX);
            $gPath.setAttribute('transform', trans);
        }
    }
    // 两端对齐，偏移设置
    function doJustify($$gPaths, wrapWidth, width)
    {
        var $gPath, pathX, setX, trans;
        var spaceWidth = wrapWidth - width;
        var space = spaceWidth / ($$gPaths.length - 1);
        var i = 0;
        for (i;i < $$gPaths.length;i++)
        {
            $gPath = $$gPaths[i];
            pathX = parseFloat($gPath.getAttribute('data-x'));
            setX = pathX + (space + letterSpacing) * i;

            trans = $gPath.getAttribute('transform');
            trans = trans.replace(/translate\s?\(\s?-?\d+(\.\d+)?/, 'translate(' + setX);
            $gPath.setAttribute('transform', trans);
        }
    }
    // 处理每行 path 路径的偏移
    function setPathsTrans($g, wrapWidth, width, justify)
    {
        // 1：不存在 data-x 属性、或只有一个 path，返回
        var $$gPaths = $g.querySelectorAll('.font-path');
        var pathsNum = $$gPaths.length;
        if (pathsNum === 0){
            return;
        }
        var $lastPath = $$gPaths[pathsNum - 1];
        var lastX = parseFloat($lastPath.getAttribute('data-x') || 0);
        if (!lastX){
            return;
        }
        // 2：取 data-justify，判断对齐模式、是否需要计算
        var justifyDone = Boolean(parseFloat($g.getAttribute('data-justify')));
        if (justify) {
            if (justifyDone) return;
            $g.setAttribute('data-justify', '1');
        } else {
            if (!justifyDone) return;
            $g.setAttribute('data-justify', '0');
        }
        // 3：计算偏移量
        if (justifyDone) {
            doDefault($$gPaths);
        } else {
            doJustify($$gPaths, wrapWidth, width);
        }
    }
    // 设置 单行 偏移
    function setTranslateX ($g)
    {
        // 计算前，非 justify 则先复位
        if (alignType !== 'justify') {
            setPathsTrans($g, wrapWidth);
        }

        // 执行计算
        var dx, boxX, boxWidth, transX;
        dx = parseFloat($g.getAttribute("data-dx") || 0);
        dx = dx > 0 ? dx : 0;
        boxX = $g.getBBox().x;
        boxX = boxX > 0 ? Math.ceil(boxX) : 0;
        boxWidth = Math.round($g.getBBox().width + boxX);

        switch(alignType) {
            case "left": transX = dx; break;
            case "center":
                transX = dx + (wrapWidth - boxWidth) / 2;
                transX = transX > 0 ? transX : 0;
                break;
            case "right":
                transX = dx + wrapWidth - boxWidth;
                transX = transX > 0 ? transX : 0;
                break;
            case "justify":
                setPathsTrans($g, wrapWidth, boxWidth, 1);
                transX = dx;
                break;
        }
        $g.setAttribute("transform", "translate(" + transX + " " + $g.transform.baseVal[0].matrix.f + ")");
    }

    // 获取参数，节点
    material = material || media.tool.tempMaterial || media.getCurMaterial();
    $curElem = $curElem || media.tool.tempElement || media.tool.getCurSvgElement();
    if (!material || !$curElem)
        return;

    // 对齐操作之前，取消文字特效
    var textSpecial = material.textSpecial;
    var idObjArr = getIdObjArrFromMaterial(material);
    doTextSpecialSet('normal', idObjArr);

    // 主方法，执行对齐
    material.textAlign = alignType;
    $curElem.setAttribute("data-textalign",alignType);

    var letterSpacing = parseFloat(material.letterSpacing + '');
    var $gSvg = $curElem.querySelector("g");
    var $$svg = $gSvg.children;
    while ($$svg.length > 1)
        $gSvg.removeChild($$svg[0]);
    var $svg = $$svg[0];
    var wrapWidth = $svg.viewBox.baseVal.width;
    var $$gLine = $svg.children;
    wrapWidth = Math.round(wrapWidth);

    [].map.call($$gLine,function($g) {
        setTranslateX($g);
    });

    // 文字特效
    doTextSpecialSet(textSpecial, idObjArr);
}

//******* 3.6 文字缩放 **********//
function setTextZoom(textZoom, material, $curElem)
{
    //获取参数，节点
    material = material || media.tool.tempMaterial || media.getCurMaterial();
    $curElem = $curElem || media.tool.tempElement || media.tool.getCurSvgElement();

    if (!material || !$curElem)
        return;

    material.type = parseFloat(material.type);
    var $gSvg = $curElem.querySelector("g");
    var $$svg = $gSvg.children;
    var svgLength = $$svg.length;
    var $svg = $$svg[svgLength - 1];
    var $rect = $curElem.querySelector("rect");

    //处理
    textZoom = textZoom || material.textZoom;   //textZoom = "111 111"
    if (material.type !== 1 || !textZoom) {
        return;
    }

    var zoomData = textZoom.split(" ");
    var zoomFirst = parseFloat(zoomData[0]);
    var zoomSecond = parseFloat(zoomData[1]);
    var widthZoom, heightZoom;
    if (material.textVertical === 'normal'){
        widthZoom = zoomFirst;
        heightZoom = zoomSecond;
    } else {
        widthZoom = zoomSecond;
        heightZoom = zoomFirst;
    }
    var svgWidth = parseFloat($svg.getAttribute("width"));
    var svgHeight = parseFloat($svg.getAttribute("height"));
    var setWidth = svgWidth * widthZoom;
    var setHeight = svgHeight * heightZoom;

    // 设置宽高
    var $svgElem, i;
    for (i = 0;i < svgLength;i++) {
        $svgElem = $$svg[i];
        $svgElem.setAttribute("width", setWidth + '');
        $svgElem.setAttribute("height", setHeight + '');
    }
    $rect.setAttribute("width", setWidth + '');
    $rect.setAttribute("height", setHeight + '');
}

//******* 3.7 文字特效 **********//
function doTextSpecialSetClick(event)
{
    Z.E.forbidden(event);
    var textSpecial = event.currentTarget.getAttribute('data-type');
    if (!textSpecial)
        return;
    doTextSpecialSet(textSpecial, null, true);
    saveHistory();
}
function doTextSpecialSet(textSpecial, idObjArr, doDefault)
{
    // 0：normal
    function resetTextSpecial()
    {
        // 1：去除阴影
        function removeShadow1()
        {
            var $feBlend = $gInner.querySelector('defs[data-type="shadow-1"]');
            if (!$feBlend)
                return;
            var resetSize = parseFloat($feBlend.getAttribute('data-resetsize') || 0);
            $gInner.removeChild($feBlend);
            var svgViewBox = $svg.viewBox.baseVal;
            var setWidth = parseFloat($svg.getAttribute('width')) - resetSize;
            var setHeight = parseFloat($svg.getAttribute('height')) - resetSize;
            $rect.setAttribute('width', setWidth);
            $rect.setAttribute('height', setHeight);
            $svg.setAttribute('viewBox', '0 0 ' + (svgViewBox.width - resetSize) + ' ' + (svgViewBox.height - resetSize));
            $svg.setAttribute('width', setWidth);
            $svg.setAttribute('height', setHeight);
            $svg.removeAttribute('filter');
        }
        // 2：去除描边(多余的svg)
        function removeStroke1()
        {
            if (svgListLength <= 1)
                return;
            var i = 0;
            while(svgListLength > 1) {
                $gInner.removeChild($$svg[i]);
                svgListLength--;
                i++;
            }
            resetViewBoxByStrokeWidth(0, material, $curElem);
            material.textSpecialSize = -1;
            $curElem.removeAttribute("data-textspecialsize");
        }
        // 3：去除渐变1、渐变2、渐变4；去除mask属性
        function removeGradient1()
        {
            var $gradient1 = $gInner.querySelector('defs[data-type="gradient-1"]');
            var $gradient2 = $gInner.querySelector('defs[data-type="gradient-2"]');
            var $gradient4 = $gInner.querySelector('defs[data-type="gradient-4"]');
            if ($gradient1)
                $gInner.removeChild($gradient1);
            if ($gradient2)
                $gInner.removeChild($gradient2);
            if ($gradient4)
                $gInner.removeChild($gradient4);
            $svg.removeAttribute('mask');
        }
        // 4：去除渐变3
        function removeGradient3()
        {
            var $$gradient = $gInner.querySelectorAll('defs[data-type="gradient-3"]');
            if ($$gradient.length === 0)
                return;
            [].forEach.call($$gradient, function($gradient){
                $gInner.removeChild($gradient);
            });
        }
        // 5：去除图案1
        function removePattern1()
        {
            var $pattern = $gInner.querySelector('defs[data-type="pattern-1"]');
            if (!$pattern)
                return;
            $gInner.removeChild($pattern);
            $svg.removeAttribute('fill');
        }

        // 1：去除阴影1
        // removeShadow1();
        // 2：去除描边1、描边2、描边3、描边5
        removeStroke1();
        // 3：去除渐变1、渐变2
        // removeGradient1();
        // 4：去除渐变3
        // removeGradient3();
        // 5：去除图案1
        removePattern1();
    }
    // 1：shadow-1：偏移 13 对应 阴影 10，阴影 10 对应 字体 30pt
    function setTextShadow1()
    {    
        var textSize = material.fontSize;
        if (parseFloat(media.canvas.createMode) === 1)
            textSize = px2pt(textSize);
        var blurSize = 10/30 * textSize;
        var offsetSize = 13/10 * blurSize;
        var resetSize = 3 * offsetSize;
        var filterId = 'textSpecialFilter_' + new Date().getTime();
        var feBlendStr = '<defs data-type="shadow-1" data-resetsize="' + resetSize +'">\n' +
            '    <filter id="' + filterId + '" x="-100%" y="-100%" width="300%" height="300%">\n' +
            '      <feOffset result="offOut" in="SourceGraphic" dx="' + offsetSize + '" dy="' + offsetSize + '" />\n' +
            '      <feGaussianBlur result="blurOut" in="matrixOut" stdDeviation="' + blurSize + '" />\n' +
            '      <feBlend in="SourceGraphic" in2="blurOut" mode="normal" />\n' +
            '    </filter>\n' +
            '</defs>';
        $gInner.insertAdjacentHTML('afterbegin', feBlendStr);
        $svg.setAttribute('filter', 'url(#' + filterId + ')');
        // 重设 SVG 宽高
        var svgViewBox = $svg.viewBox.baseVal;
        var setWidth = parseFloat($svg.getAttribute('width')) + resetSize;
        var setHeight = parseFloat($svg.getAttribute('height')) + resetSize;
        $rect.setAttribute('width', setWidth);
        $rect.setAttribute('height', setHeight);
        $svg.setAttribute('viewBox', '0 0 ' + (svgViewBox.width + resetSize) + ' ' + (svgViewBox.height + resetSize));
        $svg.setAttribute('width', setWidth);
        $svg.setAttribute('height', setHeight);
    }   
    // 2：stroke-1：描边 15 对应 字体 20pt
    // 默认：字体颜色（#FFFFFF）特殊颜色（#000000）
    function setTextStroke1()
    {         
        if (svgListLength === 0)
            return;

        // 1：定义素材颜色
        if (doDefault) updateTextColor(material, $curElem,sessionStorage.getItem("valColor"));

        // 2：定义描边属性
        if (doDefault) material.textSpecialColor = "#000000";
        var specialColorArr = material.textSpecialColor.split(',');
        var strokeFill = specialColorArr[0];
        var textSize = material.fontSize;
        if (parseFloat(media.canvas.createMode) === 1)
            textSize = px2pt(textSize);
        var textSpecialSize = material.textSpecialSize;
        if (textSpecialSize <= 0)
            textSpecialSize = 15/20;
        var strokeWidth = textSpecialSize * textSize;

        // 3：计算大小
        resetViewBoxByStrokeWidth(strokeWidth, material, $curElem);

        // 4：插入克隆元素
        var $svgCopy = $svg.cloneNode(true);
        $svgCopy.setAttribute('stroke', strokeFill);
        $svgCopy.setAttribute('stroke-width', strokeWidth);
        $svgCopy.setAttribute('data-textspecialcolor', strokeFill);
        $svg.insertAdjacentElement('beforebegin', $svgCopy);

        // 4：定义属性特殊大小
        material.textSpecialSize = textSpecialSize;
        $curElem.setAttribute("data-textspecialsize", material.textSpecialSize);
    }
    // 3：stroke-2：内描边 6 对应 外描边 18，外描边 18 对应 字体 30pt
    // 默认：字体颜色（#FFFFFF）特殊颜色（#000000）
    function setTextStroke2()
    {   
        if (svgListLength === 0)
            return;

        // 1：定义素材颜色
        if (doDefault) updateTextColor(material, $curElem, sessionStorage.getItem("valColor"));

        // 2：定义描边属性
        if (doDefault) material.textSpecialColor = "#000000";
        var specialColorArr = material.textSpecialColor.split(',');
        var strokeFill = specialColorArr[0];
        var textSize = material.fontSize;
        if (parseFloat(media.canvas.createMode) === 1)
            textSize = px2pt(textSize);
        var strokeWidthOuter = 18/30 * textSize;
        var strokeWidthInner = 6/18 * strokeWidthOuter;

        // 2：计算大小
        resetViewBoxByStrokeWidth(strokeWidthOuter, material, $curElem);

        // 3：插入克隆元素
        var $svgInner = $svg.cloneNode(true);
        $svgInner.setAttribute('stroke', '#ffffff');
        $svgInner.setAttribute('stroke-width', strokeWidthInner);
        $svg.insertAdjacentElement('beforebegin', $svgInner);
        var $svgOuter = $svg.cloneNode(true);
        $svgOuter.setAttribute('stroke', strokeFill);
        $svgOuter.setAttribute('stroke-width', strokeWidthOuter);
        $svgOuter.setAttribute('data-textspecialcolor', strokeFill);
        $svgInner.insertAdjacentElement('beforebegin', $svgOuter);
    }
    // 4：stroke-3：内描边 10 对应 中描边 12，中描边 12 对应 外描边 20pt，外描边 20 对应 字体 30pt
    // 默认：字体颜色（#FFFFFF）特殊颜色（#000000）
    function setTextStroke3()
    {   
        if (svgListLength === 0)
            return;

        // 1：定义素材颜色
        if (doDefault) updateTextColor(material, $curElem, sessionStorage.getItem("valColor"));

        // 2：定义描边属性
        if (doDefault) material.textSpecialColor = '#BB0000,#BB0000';
        var specialColorArr = material.textSpecialColor.split(',');
        var strokeOuterFill = specialColorArr[0];
        var strokeInnerFill = specialColorArr[1] || '#BB0000';
        var textSize = material.fontSize;
        if (parseFloat(media.canvas.createMode) === 1)
            textSize = px2pt(textSize);
        var strokeWidthOuter = 20/30 * textSize;
        var strokeWidthMiddle = 12/20 * strokeWidthOuter;
        var strokeWidthInner = 10/12 * strokeWidthMiddle;

        // 2：计算大小
        resetViewBoxByStrokeWidth(strokeWidthOuter, material, $curElem);

        // 3：插入克隆元素
        var $svgInner = $svg.cloneNode(true);
        $svgInner.setAttribute('stroke', strokeInnerFill);
        $svgInner.setAttribute('stroke-width', strokeWidthInner);
        $svgInner.setAttribute('data-textspecialcolor', strokeInnerFill);
        $svg.insertAdjacentElement('beforebegin', $svgInner);
        var $svgMiddle = $svg.cloneNode(true);
        $svgMiddle.setAttribute('stroke', '#000000');
        $svgMiddle.setAttribute('stroke-width', strokeWidthMiddle);
        $svgInner.insertAdjacentElement('beforebegin', $svgMiddle);
        var $svgOuter = $svg.cloneNode(true);
        $svgOuter.setAttribute('stroke', strokeOuterFill);
        $svgOuter.setAttribute('stroke-width', strokeWidthOuter);
        $svgOuter.setAttribute('data-textspecialcolor', strokeOuterFill);
        $svgMiddle.insertAdjacentElement('beforebegin', $svgOuter);
    }
    // 5：stroke-4

    // 6：stroke-5：重复叠加实现3D效果，叠加距离 12 对应 字体 30pt
    function setTextStroke5()
    {
        // 1：定义变量
        if (svgListLength === 0)
            return;
        var strokeFill = '#777777';
        var stepWidth = .25;
        var textSize = material.fontSize;
        if (parseFloat(media.canvas.createMode) === 1)
            textSize = px2pt(textSize);
        var spaceWidth = 10/30 * textSize;
        var num = Math.round(spaceWidth / stepWidth);

        // 2：重设大小
        resetViewBoxByStrokeWidth(spaceWidth, material, $curElem);

        // 3：插入特效节点
        var $svgClone = $svg.cloneNode(true);
        var $$path = $svgClone.querySelectorAll('.font-path>path');
        [].forEach.call($$path, function($path){
            $path.setAttribute('fill', strokeFill);
        });
        var i = 1, $svgStep, viewBoxObj, setView;
        for (i;i <= num;i++)
        {
            $svgStep = $svgClone.cloneNode(true);
            viewBoxObj = $svgStep.viewBox.baseVal;
            setView = (viewBoxObj.x - i * stepWidth) + ' ' + (viewBoxObj.y - i * stepWidth) +
                ' ' + viewBoxObj.width + ' ' + viewBoxObj.height;
            $svgStep.setAttribute('viewBox', setView);
            $svg.insertAdjacentElement('beforebegin', $svgStep);
        }
        $svgStep.setAttribute('data-textspecialcolor', strokeFill);
    }
    // 7：cartoon-1
    // 8：cartoon-2

    // 9：gradient-1
    function setTextGradient1()
    {
        var gradientId = 'textSpecialLinear_' + new Date().getTime();
        var maskId = 'textSpecialMask_' + new Date().getTime();
        var maskStr = '<defs data-type="gradient-1">' +
            '    <linearGradient id=' + gradientId + ' x1="0%" y1="0%" x2="0%" y2="100%">' +
            '        <stop offset="40%" stop-color="#fff"></stop>\n' +
            '        <stop offset="95%" stop-color="#000"></stop>\n' +
            '    </linearGradient>\n' +
            '    <mask id="' + maskId + '">\n' +
            '        <rect x="0" y="0" width="' + $rect.getAttribute('width') + '" height="' + $rect.getAttribute('height') + '" fill="url(#' + gradientId + ')"></rect>\n' +
            '    </mask>' +
            '</defs>';
        $gInner.insertAdjacentHTML('afterbegin', maskStr);
        $svg.setAttribute('mask', 'url(#' + maskId + ')');
    }
    // 10：gradient-2：默认颜色为 #0088dd （蓝色）
    function setTextGradient2()
    {
        var textColor = material.color;
        var gradientFill = material.textSpecialColor.split(',')[0];
        if (textColor === gradientFill){
            material.textSpecialColor = '#0088dd';
            gradientFill = material.textSpecialColor;
        }

        var dateTime = new Date().getTime();
        var gradientId = 'textSpecialGradient_' + dateTime;
        var maskId = 'textSpecialMask_' + dateTime;
        var maskStr = '<defs data-type="gradient-2">' +
            '    <linearGradient id=' + gradientId + '>' +
            '        <stop offset="0%" stop-color="#ffffff"></stop>\n' +
            '        <stop offset="100%" stop-color="#000000"></stop>\n' +
            '    </linearGradient>\n' +
            '    <mask id="' + maskId + '">\n' +
            '        <rect x="0" y="0" width="' + $rect.getAttribute('width') + '" height="' + $rect.getAttribute('height') + '" fill="url(#' + gradientId + ')"></rect>\n' +
            '    </mask>' +
            '</defs>';
        $gInner.insertAdjacentHTML('afterbegin', maskStr);

        var $svgMask = $svg.cloneNode(true);
        var $$path = $svgMask.querySelectorAll('.font-path>path');
        [].forEach.call($$path, function($path){
            $path.setAttribute('fill', gradientFill);
        });
        $svgMask.setAttribute('data-textspecialcolor', gradientFill);
        $svg.insertAdjacentElement('beforebegin', $svgMask);
        $svg.setAttribute('mask', 'url(#' + maskId + ')');
    }
    // 11：gradient-3：默认颜色为 #0088dd（蓝色）, #00cc00（绿色）
    function setTextGradient3()
    {
        function getMaskStr(color1,color2,color3)
        {
            return '<defs data-type="gradient-3">' +
            '    <linearGradient id=' + gradientId + '>' +
            '        <stop offset="0%" stop-color="'+color1+'"></stop>\n' +
            '        <stop offset="50%" stop-color="'+color2+'"></stop>\n' +
            '        <stop offset="100%" stop-color="'+color3+'"></stop>\n' +
            '    </linearGradient>\n' +
            '    <mask id="' + maskId + '">\n' +
            '        <rect x="0" y="0" width="' + $rect.getAttribute('width') + '" height="' + $rect.getAttribute('height') + '" fill="url(#' + gradientId + ')"></rect>\n' +
            '    </mask>' +
            '</defs>';
        }

        var specialArr = material.textSpecialColor.split(',');
        var middleColor = specialArr[0];
        var rightColor = specialArr[1];
        if (!middleColor || !rightColor){
            middleColor = '#0088dd';
            rightColor = '#00cc00';
        }
        var $svgMiddle = $svg.cloneNode(true);
        var $svgRight = $svg.cloneNode(true);

        var dateTime = new Date().getTime();
        var gradientId = 'textSpecialGradient_' + dateTime;
        var maskId = 'textSpecialMask_' + dateTime;
        var maskStr = getMaskStr('#ffffff', '#000000', '#000000');
        $gInner.insertAdjacentHTML('afterbegin', maskStr);
        $svg.setAttribute('mask', 'url(#' + maskId + ')');

        //中间段插入
        var $$middlePath = $svgMiddle.querySelectorAll('.font-path>path');
        [].forEach.call($$middlePath, function($path){
            $path.setAttribute('fill', middleColor);
        });
        $svgMiddle.setAttribute('data-textspecialcolor', middleColor);
        $svg.insertAdjacentElement('beforebegin', $svgMiddle);

        //结尾段插入
        var $$rightPath = $svgRight.querySelectorAll('.font-path>path');
        [].forEach.call($$rightPath, function($path){
            $path.setAttribute('fill', rightColor);
        });
        $svgRight.setAttribute('data-textspecialcolor', rightColor);
        $svg.insertAdjacentElement('beforebegin', $svgRight);
        //结尾段mask
        gradientId = 'textSpecialGradient_' + (dateTime + 1);
        maskId = 'textSpecialMask_' + (dateTime + 1);
        maskStr = getMaskStr('#000000', '#000000', '#ffffff');
        $gInner.insertAdjacentHTML('afterbegin', maskStr);
        $svgRight.setAttribute('mask', 'url(#' + maskId + ')');
    }
    // 12：gradient-4：描边+蒙版
    function setTextGradient4()
    {
        var textColor = material.color;
        var gradientFill = material.textSpecialColor.split(',')[0];
        if (textColor === gradientFill){
            material.textSpecialColor = '#ffffff';
            gradientFill = material.textSpecialColor;
        }

        var dateTime = new Date().getTime();
        var maskId = 'textSpecialMask_' + dateTime;
        var rectWidth = $rect.getAttribute('width');
        var rectHeight = parseFloat($rect.getAttribute('height')) / 2;
        var maskStr = '<defs data-type="gradient-4">' +
            '    <mask id="' + maskId + '">\n' +
            '        <rect x="0" y="0" width="' + rectWidth + '" height="' + rectHeight + '" fill="#000000"></rect>\n' +
            '        <rect x="0" y="' + rectHeight + '" width="' + rectWidth + '" height="' + rectHeight + '" fill="#ffffff"></rect>\n' +
            '    </mask>' +
            '</defs>';
        $gInner.insertAdjacentHTML('afterbegin', maskStr);

        //颜色段插入
        var $svgMask = $svg.cloneNode(true);
        var $$path = $svgMask.querySelectorAll('.font-path>path');
        [].forEach.call($$path, function($path){
            $path.setAttribute('fill', gradientFill);
        });
        $svgMask.setAttribute('data-textspecialcolor', gradientFill);
        $svg.insertAdjacentElement('beforebegin', $svgMask);

        //插入描边段
        var $svgStroke = $svg.cloneNode(true);
        var textSize = material.fontSize;
        if (parseFloat(media.canvas.createMode) === 1)
            textSize = px2pt(textSize);
        var strokeWidth = 2/20 * textSize;
        $svgStroke.setAttribute('stroke', '#000000');
        $svgStroke.setAttribute('stroke-width', strokeWidth);
        $svgMask.insertAdjacentElement('beforebegin', $svgStroke);

        //原svg属性设置
        $svg.setAttribute('mask', 'url(#' + maskId + ')');
    }
    // 13：pattern-1：图片背景填充
    function setTextPattern1()
    {
        var dateTime = new Date().getTime();
        var patternId = 'textSpecialPattern_' + dateTime;
        var patternStr = '<defs data-type="pattern-1">' +
            '    <pattern id="' + patternId + '" patternUnits="userSpaceOnUse" width="300" height="150">\n' +
            '        <image xlink:href="https://st-gdx.dancf.com/www/8/design/20180404-195855-1.png" x="0" y="0" width="300" height="150"/>\n' +
            '    </pattern>' +
            '</defs>';
        $gInner.insertAdjacentHTML('afterbegin', patternStr);

        var $$path = $svg.querySelectorAll('.font-path>path');
        [].forEach.call($$path, function($path){
            $path.removeAttribute('fill');
        });
        $svg.setAttribute('fill', 'url(#' + patternId + ')');
    }
    // 分类处理
    function switchSpecialType()
    {
        // 1：重置素材
        resetTextSpecial();
        // 2：修改素材
        switch(textSpecial)
        {
            case 'shadow-1': setTextShadow1(); break;
            case 'stroke-1': setTextStroke1(); break;
            case 'stroke-2': setTextStroke2(); break;
            case 'stroke-3': setTextStroke3(); break;
            case 'stroke-4': break;
            case 'stroke-5': setTextStroke5(); break;
            case 'cartoon-1': break;
            case 'cartoon-2': break;
            case 'gradient-1': setTextGradient1(); break;
            case 'gradient-2': setTextGradient2(); break;
            case 'gradient-3': setTextGradient3(); break;
            case 'gradient-4': setTextGradient4(); break;
            case 'pattern-1': setTextPattern1(); break;
        }
        // 3：素材属性
        material.textSpecial = textSpecial;
        // 4：选择框定位
        selectionTool_show();
        // 5：设置标识
        $curElem.setAttribute('data-textspecial', textSpecial);
        $curElem.setAttribute('data-textspecialcolor', material.textSpecialColor);
    }

    // 1：主方法，定义变量
    if (!textSpecial)
    {// 1.1：当前素材参数
        var curMaterial = media.getCurMaterial();
        if (curMaterial && curMaterial.textSpecial)
            textSpecial = curMaterial.textSpecial;
    }
    if (!textSpecial)
        return;

    // 2：获取midArr、bidArr
    setIdArr(idObjArr);
    var midLength = midArr.length;
    if (midLength === 0)
        return;

    // 3：循环所有待处理素材
    var i, material, $curElem, $rect, $gInner, $$svg, svgListLength, $svg;
    for (i = 0;i < midLength;i++)
    {
        if (bidArr[i] !== media.curPage)
            continue;
        $curElem = media.tool.getSvgElementByMid(midArr[i]);
        $rect = $curElem.querySelector('rect');
        material = media.getMaterialByMid(midArr[i], bidArr[i]);
        $gInner = $curElem.querySelector('g');
        $$svg = Z($gInner).children('svg');
        svgListLength = $$svg.length;
        $svg = $$svg[svgListLength - 1];
        switchSpecialType();
        updateMaterialSource(material,$curElem);
    }

    // 4：显示额外的颜色设置
    showSpecialColorPicker(textSpecial, midArr[0]);

    // 5：显示大小滑块
    showTextSpecialSize(textSpecial, midArr[0]);
}
// 文字特效：描边大小计算
function resetViewBoxByStrokeWidth(exWidth, material, $curElem)
{
    var $svg = Z($curElem)[0].querySelector("svg");
    var $rect = Z($curElem)[0].querySelector("rect");
    var svgViewBox = $svg.viewBox.baseVal;
    var zoomData = material.textZoom.split(' ');
    var originWidth = svgViewBox.width + 2 * svgViewBox.x;
    var originHeight = svgViewBox.height + 2 * svgViewBox.y;
    var setWidth = originWidth + 2 * exWidth;
    var setHeight = originHeight + 2 * exWidth;
    var setViewBox = - exWidth + ' ' + ( - exWidth) + ' ' + setWidth + ' ' + setHeight;
    setWidth *= parseFloat(zoomData[0]);
    setHeight *= parseFloat(zoomData[1]);
    $svg.setAttribute('viewBox', setViewBox);
    $svg.setAttribute('width', setWidth + '');
    $svg.setAttribute('height', setHeight + '');
    $rect.setAttribute('width', setWidth + '');
    $rect.setAttribute('height', setHeight + '');
}
// 设置特殊文字效果大小
function setTextSpecialSize(per, $curElem, material)
{
    // 文字特效大小：stroke-1
    function setSpecialSizeToStroke1()
    {
        if (listLength !== 2)
            return;
        var $strokeSvg = $$svg[0];
        var baseStroke = 30/20 * fontSize;
        setSpecialSize = per * baseStroke;

        // 重计算素材大小
        resetViewBoxByStrokeWidth(setSpecialSize, material, $curElem);

        // 设置描边
        $strokeSvg.setAttribute('stroke-width', setSpecialSize);
        $strokeSvg.setAttribute('viewBox', $svg.getAttribute('viewBox'));
        $strokeSvg.setAttribute('width', $svg.getAttribute('width'));
        $strokeSvg.setAttribute('height', $svg.getAttribute('height'));

        // 设置描边属性
        var textSize = material.fontSize;
        if (parseFloat(media.canvas.createMode) === 1)
            textSize = px2pt(textSize);
        material.textSpecialSize = setSpecialSize / textSize;
        $curElem.setAttribute("data-textspecialsize", material.textSpecialSize);
    }

    // 1：获取素材，节点
    $curElem = $curElem || media.tool.tempElement || media.tool.getCurSvgElement();
    material = material || media.tool.tempMaterial || media.getCurMaterial();
    if (!$curElem  || !material)
        return;
    var $$svg = Z($curElem).children('g').children('svg');
    var listLength = $$svg.length;
    var $svg = $$svg[listLength - 1];
    var $rect = $curElem.querySelector('rect');
    var fontSize = material.fontSize;
    if (parseFloat(media.canvas.createMode) === 1)
        fontSize = px2pt(fontSize);

    // 2：分类处理
    var setSpecialSize = -1;
    switch (material.textSpecial)
    {
        case 'stroke-1':
            setSpecialSizeToStroke1();
            break;
        default:
            return;
    }

    // 3：选中更新
    selectTheElement_group();
}
