/*
 * Decompiled with CFR 0.152.
 */
package com.zhiqim.media.service.util;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.batik.transcoder.SVGAbstractTranscoder;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.image.ImageTranscoder;
import org.apache.batik.transcoder.image.JPEGTranscoder;
import org.apache.batik.transcoder.image.PNGTranscoder;
import org.apache.fop.svg.PDFTranscoder;

public class SvgUtil {
    public static void svg2Pdf(File svgFile, File pdfFile, float width, float height) throws Exception {
        FileInputStream in = new FileInputStream(svgFile);
        OutputStream out = new FileOutputStream(pdfFile);
        out = new BufferedOutputStream(out);
        PDFTranscoder transcoder = new PDFTranscoder();
        try {
            TranscoderInput input = new TranscoderInput((InputStream)in);
            TranscoderOutput output = new TranscoderOutput(out);
            transcoder.addTranscodingHint(SVGAbstractTranscoder.KEY_WIDTH, Float.valueOf(width));
            transcoder.addTranscodingHint(SVGAbstractTranscoder.KEY_HEIGHT, Float.valueOf(height));
            transcoder.addTranscodingHint(ImageTranscoder.KEY_PIXEL_UNIT_TO_MILLIMETER, Float.valueOf(1.0f));
            transcoder.transcode(input, output);
        }
        finally {
            out.close();
            ((InputStream)in).close();
        }
    }

    public static void svg2Pdf(File svgFile, File pdfFile, double width, double height) throws Exception {
        SvgUtil.svg2Pdf(svgFile, pdfFile, (float)width, (float)height);
    }

    public static void svg2Pdf(String svgCode, String pdfPath, double width, double height) throws Exception {
        SvgUtil.svg2Pdf(svgCode, pdfPath, (float)width, (float)height);
    }

    public static void svg2Pdf(String svgCode, String pdfPath, float width, float height) throws Exception {
        byte[] buf = svgCode.getBytes("utf-8");
        ByteArrayInputStream bis = new ByteArrayInputStream(buf);
        OutputStream out = new FileOutputStream(pdfPath);
        out = new BufferedOutputStream(out);
        PDFTranscoder transcoder = new PDFTranscoder();
        try {
            TranscoderInput input = new TranscoderInput((InputStream)bis);
            TranscoderOutput output = new TranscoderOutput(out);
            transcoder.addTranscodingHint(SVGAbstractTranscoder.KEY_WIDTH, Float.valueOf(width));
            transcoder.addTranscodingHint(SVGAbstractTranscoder.KEY_HEIGHT, Float.valueOf(height));
            transcoder.addTranscodingHint(ImageTranscoder.KEY_PIXEL_UNIT_TO_MILLIMETER, Float.valueOf(1.0f));
            transcoder.transcode(input, output);
        }
        finally {
            out.close();
            bis.close();
        }
    }

    public static void svg2Png(String svgCode, String pngPath, int width, int height) throws Exception {
        byte[] buf = svgCode.getBytes("utf-8");
        ByteArrayInputStream bis = new ByteArrayInputStream(buf);
        OutputStream out = new FileOutputStream(pngPath);
        out = new BufferedOutputStream(out);
        PNGTranscoder transcoder = new PNGTranscoder();
        try {
            TranscoderInput input = new TranscoderInput((InputStream)bis);
            TranscoderOutput output = new TranscoderOutput(out);
            if (width > 0) {
                transcoder.addTranscodingHint(PNGTranscoder.KEY_WIDTH, (Object)Float.valueOf(width));
            }
            if (height > 0) {
                transcoder.addTranscodingHint(PNGTranscoder.KEY_HEIGHT, (Object)Float.valueOf(height));
            }
            transcoder.transcode(input, output);
        }
        finally {
            out.close();
            bis.close();
        }
    }

    public static void svg2Png(String svgCode, String pngPath, float width, float height) throws Exception {
        byte[] buf = svgCode.getBytes("utf-8");
        ByteArrayInputStream bis = new ByteArrayInputStream(buf);
        OutputStream out = new FileOutputStream(pngPath);
        out = new BufferedOutputStream(out);
        PNGTranscoder transcoder = new PNGTranscoder();
        try {
            TranscoderInput input = new TranscoderInput((InputStream)bis);
            TranscoderOutput output = new TranscoderOutput(out);
            if (width > 0.0f) {
                transcoder.addTranscodingHint(PNGTranscoder.KEY_WIDTH, (Object)Float.valueOf(width));
            }
            if (height > 0.0f) {
                transcoder.addTranscodingHint(PNGTranscoder.KEY_HEIGHT, (Object)Float.valueOf(height));
            }
            transcoder.transcode(input, output);
        }
        finally {
            out.close();
            bis.close();
        }
    }

    public static void svg2Png(String svgCode, String pngPath) throws Exception {
        byte[] buf = svgCode.getBytes("utf-8");
        ByteArrayInputStream bis = new ByteArrayInputStream(buf);
        OutputStream out = new FileOutputStream(pngPath);
        out = new BufferedOutputStream(out);
        PNGTranscoder transcoder = new PNGTranscoder();
        try {
            TranscoderInput input = new TranscoderInput((InputStream)bis);
            TranscoderOutput output = new TranscoderOutput(out);
            transcoder.transcode(input, output);
        }
        finally {
            out.close();
            bis.close();
        }
    }

    public static void svg2Png(File svgFile, File pngFile, int width, int height) throws Exception {
        FileInputStream in = new FileInputStream(svgFile);
        OutputStream out = new FileOutputStream(pngFile);
        out = new BufferedOutputStream(out);
        PNGTranscoder transcoder = new PNGTranscoder();
        try {
            TranscoderInput input = new TranscoderInput((InputStream)in);
            TranscoderOutput output = new TranscoderOutput(out);
            transcoder.addTranscodingHint(PNGTranscoder.KEY_WIDTH, (Object)Float.valueOf(width));
            transcoder.addTranscodingHint(PNGTranscoder.KEY_HEIGHT, (Object)Float.valueOf(height));
            transcoder.transcode(input, output);
        }
        finally {
            out.close();
            ((InputStream)in).close();
        }
    }

    public static void svg2Png(File svgFile, File pngFile) throws Exception {
        FileInputStream in = new FileInputStream(svgFile);
        OutputStream out = new FileOutputStream(pngFile);
        out = new BufferedOutputStream(out);
        PNGTranscoder transcoder = new PNGTranscoder();
        try {
            TranscoderInput input = new TranscoderInput((InputStream)in);
            TranscoderOutput output = new TranscoderOutput(out);
            transcoder.transcode(input, output);
        }
        finally {
            out.close();
            ((InputStream)in).close();
        }
    }

    public static void svg2Jpeg(String svgCode, String jpgPath, int width, int height) throws Exception {
        byte[] buf = svgCode.getBytes("utf-8");
        ByteArrayInputStream bis = new ByteArrayInputStream(buf);
        OutputStream out = new FileOutputStream(jpgPath);
        out = new BufferedOutputStream(out);
        JPEGTranscoder transcoder = new JPEGTranscoder();
        try {
            TranscoderInput input = new TranscoderInput((InputStream)bis);
            TranscoderOutput output = new TranscoderOutput(out);
            transcoder.addTranscodingHint(JPEGTranscoder.KEY_WIDTH, (Object)Float.valueOf(width));
            transcoder.addTranscodingHint(JPEGTranscoder.KEY_HEIGHT, (Object)Float.valueOf(height));
            transcoder.addTranscodingHint(JPEGTranscoder.KEY_QUALITY, (Object)Float.valueOf(0.85f));
            transcoder.transcode(input, output);
        }
        finally {
            out.close();
            bis.close();
        }
    }

    public static void svg2Jpeg(String svgCode, String jpgPath) throws Exception {
        byte[] buf = svgCode.getBytes("utf-8");
        ByteArrayInputStream bis = new ByteArrayInputStream(buf);
        OutputStream out = new FileOutputStream(jpgPath);
        out = new BufferedOutputStream(out);
        JPEGTranscoder transcoder = new JPEGTranscoder();
        try {
            TranscoderInput input = new TranscoderInput((InputStream)bis);
            TranscoderOutput output = new TranscoderOutput(out);
            transcoder.addTranscodingHint(JPEGTranscoder.KEY_QUALITY, (Object)Float.valueOf(0.85f));
            transcoder.transcode(input, output);
        }
        finally {
            out.close();
            bis.close();
        }
    }

    public static void svg2Jpeg(File svgFile, File jpgFile, int width, int height) throws Exception {
        FileInputStream in = new FileInputStream(svgFile);
        OutputStream out = new FileOutputStream(jpgFile);
        out = new BufferedOutputStream(out);
        JPEGTranscoder transcoder = new JPEGTranscoder();
        try {
            TranscoderInput input = new TranscoderInput((InputStream)in);
            TranscoderOutput output = new TranscoderOutput(out);
            transcoder.addTranscodingHint(JPEGTranscoder.KEY_WIDTH, (Object)Float.valueOf(width));
            transcoder.addTranscodingHint(JPEGTranscoder.KEY_HEIGHT, (Object)Float.valueOf(height));
            transcoder.addTranscodingHint(JPEGTranscoder.KEY_QUALITY, (Object)Float.valueOf(0.85f));
            transcoder.transcode(input, output);
        }
        finally {
            out.close();
            ((InputStream)in).close();
        }
    }

    public static String buildImageSvg(String url, float width, float height) {
        StringBuffer strb = new StringBuffer();
        strb.append("<svg version=\"1.1\" xmlns=\"http://www.w3.org/2000/svg\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" preserveAspectRatio=\"none\" width=\"").append(width).append("\" height=\"").append(height).append("\" viewBox=\"0 0 ").append(width).append(" ").append(height).append("\">").append("\r\n").append("<g>").append("\r\n").append("<image xlink:href=\"").append(url).append("\" width=\"100%").append("\" height=\"100%").append("\"/>").append("\r\n").append("</g>").append("\r\n").append("</svg>");
        return strb.toString();
    }

    public static void main(String[] args) throws Exception {
        double fullWidthMm = 1.0;
        double fullHeightMm = 1.0;
        String svgCode = "<svg preserveAspectRatio=\"none\" width=\"732.2834\" height=\"496.0629\"><rect x=\"0\" y=\"0\" width=\"100%\" height=\"100%\" fill=\"#ffffff\"></rect></svg>";
        SvgUtil.svg2Pdf(svgCode, "d:/test.pdf", fullWidthMm, fullHeightMm);
    }
}

