/*
 * Decompiled with CFR 0.152.
 */
package com.zhiqim.media.service.svg;

import java.io.ByteArrayOutputStream;
import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public abstract class MediaSvgElement {
    public static final int DOC_TYPE = 0;
    public static final int BG_TYPE = 1;
    public static final int IMAGE_TYPE = 2;
    public static final int TEXT_TYPE = 3;
    public static final int GROUP_TYPE = 4;
    protected String svgCode;
    protected Document document;
    protected float tx = 0.0f;
    protected float ty = 0.0f;
    protected float deg = 0.0f;
    protected float rx = 0.0f;
    protected float ry = 0.0f;

    public MediaSvgElement(String svgCode) {
        this.svgCode = svgCode;
    }

    public void init() {
        if (this.svgCode == null) {
            return;
        }
        StringReader read = new StringReader(this.svgCode);
        InputSource is = new InputSource(read);
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            this.document = builder.parse(is);
        }
        catch (Exception exception) {}
        this.parse();
    }

    public abstract void parse();

    protected Element getChildNode(Node node, String nodeName) {
        NodeList nodelist = node.getChildNodes();
        int i = 0;
        while (i < nodelist.getLength()) {
            Node child = nodelist.item(i);
            if (child.getNodeType() == 1 && child.getNodeName().equals(nodeName)) {
                return (Element)child;
            }
            ++i;
        }
        return null;
    }

    protected void analysis(String transform) {
        int ind = transform.indexOf(40);
        if (ind == -1) {
            return;
        }
        int ind1 = transform.indexOf(41, ind);
        if (ind1 == -1) {
            return;
        }
        String translate = transform.substring(ind + 1, ind1).trim();
        String[] ts = translate.split(" ");
        this.tx = Float.parseFloat(ts[0]);
        this.ty = Float.parseFloat(ts[1]);
        ind = transform.indexOf(40, ind1);
        if (ind == -1) {
            return;
        }
        ind1 = transform.indexOf(41, ind);
        if (ind1 == -1) {
            return;
        }
        String rotate = transform.substring(ind + 1, ind1).trim();
        String[] rs = rotate.split(",");
        this.deg = Float.parseFloat(rs[0]);
        this.rx = Float.parseFloat(rs[1]);
        this.ry = Float.parseFloat(rs[2]);
    }

    public Document getDocument() {
        return this.document;
    }

    public String getSvgCode() {
        return this.svgCode;
    }

    public abstract Element toElement();

    public String toXml(Node node) {
        try {
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer t = tf.newTransformer();
            t.setOutputProperty("encoding", "utf-8");
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            t.transform(new DOMSource(node), new StreamResult(bos));
            String xml = bos.toString();
            return xml.substring(38);
        }
        catch (TransformerException transformerException) {
            return null;
        }
    }
}

