/*
 * Decompiled with CFR 0.152.
 */
package com.zhiqim.media.service.dao;

import com.zhiqim.media.dbo.MediaBg;
import com.zhiqim.media.dbo.MediaCanvas;
import com.zhiqim.media.dbo.MediaCoverMaterial;
import com.zhiqim.media.dbo.MediaMaterialParamEx;
import com.zhiqim.media.service.dao.MediaDao;
import com.zhiqim.media.service.dao.MediaPathDao;
import com.zhiqim.media.service.model.MediaBgModel;
import com.zhiqim.media.service.util.GraphicsMagickUtil;
import com.zhiqim.media.service.util.SvgUtil;
import java.util.ArrayList;
import java.util.List;
import org.zhiqim.kernel.util.DateTimes;
import org.zhiqim.kernel.util.Ids;
import org.zhiqim.kernel.util.Strings;

public class PdfDao {
    public static List<String> getPdfList(MediaCanvas canvas, int num, boolean isEditable, List<MediaBg> bgList, List<MediaMaterialParamEx> materials, List<MediaCoverMaterial> coverMaterials, String ResultType) throws Exception {
        long mediaId = canvas.getMediaId();
        String curDate = DateTimes.getDateTime8String();
        ArrayList<String> pdfList = new ArrayList<String>();
        double resultWidthMm = 0.0;
        double resultHeightMm = 0.0;
        if ("PDF".equals(ResultType)) {
            resultWidthMm = canvas.getFullWidthMm() != 0.0 ? canvas.getFullWidthMm() : canvas.getWidthMm();
            resultHeightMm = canvas.getFullHeightMm() != 0.0 ? canvas.getFullHeightMm() : canvas.getHeightMm();
        } else {
            resultWidthMm = canvas.getWidthMm();
            resultHeightMm = canvas.getHeightMm();
        }
        double baseWidthMm = canvas.getBaseWidthMm();
        double baseHeightMm = canvas.getBaseHeightMm();
        String url_pre = MediaPathDao.MEDIA_URL_PRE;
        List<MediaBgModel> svgList = MediaDao.toSvgList(mediaId, baseWidthMm, baseHeightMm, url_pre, isEditable, bgList, materials, coverMaterials, ResultType);
        int i = 0;
        while (i < svgList.size()) {
            if (num > 0 && i >= num) break;
            String pdfPath = String.valueOf(MediaPathDao.getTempLocalPre(curDate)) + Ids.longId13() + ".pdf";
            MediaBgModel bg = svgList.get(i);
            String svgCode = bg.getSvgCode();
            if (bg.getOddEven() == 1L) {
                SvgUtil.svg2Pdf(svgCode, pdfPath, resultHeightMm, resultWidthMm);
            } else {
                SvgUtil.svg2Pdf(svgCode, pdfPath, resultWidthMm, resultHeightMm);
            }
            pdfList.add(pdfPath);
            ++i;
        }
        return pdfList;
    }

    public static List<String> pdfToImage(List<String> pdfList, String prePath, String suffix, int width, int height, int num) throws Exception {
        ArrayList<String> imageList = new ArrayList<String>();
        int i = 0;
        while (i < pdfList.size()) {
            if (num > 0 && i >= num) break;
            String pdfPath = pdfList.get(i);
            String destPath = String.valueOf(Strings.addEndsWith((String)prePath, (String)"/")) + Ids.longId() + "." + suffix;
            GraphicsMagickUtil.pdfToPic(pdfPath, destPath, width, height, "100");
            imageList.add(destPath);
            ++i;
        }
        return imageList;
    }
}

