/*
 * Decompiled with CFR 0.152.
 */
package com.zhiqim.media.service.cdr;

import com.jacob.com.Dispatch;
import com.zhiqim.media.service.cdr.Application;
import com.zhiqim.media.service.cdr.Bitmap;
import com.zhiqim.media.service.cdr.CdrConstants;
import com.zhiqim.media.service.cdr.CdrDispatch;
import com.zhiqim.media.service.cdr.Curve;
import com.zhiqim.media.service.cdr.Document;
import com.zhiqim.media.service.cdr.Ellipse;
import com.zhiqim.media.service.cdr.Group;
import com.zhiqim.media.service.cdr.Text;
import com.zhiqim.media.service.util.Colors;
import com.zhiqim.media.service.util.FontUtil;
import com.zhiqim.media.service.util.UnitUtil;
import java.awt.Font;
import java.awt.font.LineMetrics;
import java.awt.geom.Rectangle2D;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.zhiqim.kernel.json.Jsons;
import org.zhiqim.kernel.util.Ids;

public class Shape
extends CdrDispatch
implements CdrConstants {
    private double leftX;
    private double rightX;
    private double topY;
    private double bottomY;
    private double positionX;
    private double positionY;
    private double sizeWidth;
    private double sizeHeight;
    private double rotationAngle;
    private double rotationCenterX;
    private double rotationCenterY;
    private boolean isSimpleShape;
    private String name;
    private int type;
    private Text text;
    private Bitmap bitmap;
    private Curve curve;
    private Group group;
    private Ellipse ellipse;

    public Shape(Application application, Dispatch dispatch) {
        super(application, dispatch);
        this.parse();
    }

    @Override
    protected void parseComposite() {
        switch (this.type) {
            case 6: {
                Dispatch dispatchText = Dispatch.get((Dispatch)this.dispatch, (String)"Text").toDispatch();
                this.text = new Text(this.application, dispatchText);
                break;
            }
            case 5: {
                Dispatch dispatchBitmap = Dispatch.get((Dispatch)this.dispatch, (String)"Bitmap").toDispatch();
                this.bitmap = new Bitmap(this.application, dispatchBitmap);
                this.export();
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                Dispatch dispatchEllipse = Dispatch.get((Dispatch)this.dispatch, (String)"Ellipse").toDispatch();
                this.ellipse = new Ellipse(this.application, dispatchEllipse);
                break;
            }
            case 3: {
                Dispatch dispatchCurve = Dispatch.get((Dispatch)this.dispatch, (String)"Curve").toDispatch();
                this.curve = new Curve(this.application, dispatchCurve, this);
                break;
            }
            case 7: {
                Dispatch dispatchGroup = Dispatch.get((Dispatch)this.dispatch, (String)"Shapes").toDispatch();
                this.group = new Group(this.application, dispatchGroup);
                break;
            }
        }
    }

    public void createSelection() {
        Dispatch.call((Dispatch)this.dispatch, (String)"CreateSelection");
    }

    public void export() {
        if (this.bitmap.isTransparent()) {
            String filepath = this.application.getFileDestDir();
            this.name = String.valueOf(Ids.longId()) + ".png";
            String imagePath = String.valueOf(filepath) + this.name;
            Dispatch exportOptions = this.application.createPngExportOptions();
            Dispatch.call((Dispatch)this.dispatch, (String)"CreateSelection");
            Document document = this.application.getDocument();
            document.exportSelection(imagePath, 802, exportOptions);
            document.clearSelection();
        } else {
            String filepath = this.application.getFileDestDir();
            this.name = String.valueOf(Ids.longId()) + ".jpg";
            String imagePath = String.valueOf(filepath) + this.name;
            Dispatch exportOptions = this.application.createJpgExportOptions();
            Dispatch.call((Dispatch)this.dispatch, (String)"CreateSelection");
            Document document = this.application.getDocument();
            document.exportSelection(imagePath, 774, exportOptions);
            document.clearSelection();
        }
    }

    public double getLeftX() {
        return this.leftX;
    }

    public void setLeftX(double leftX) {
        this.leftX = leftX;
    }

    public double getRightX() {
        return this.rightX;
    }

    public void setRightX(double rightX) {
        this.rightX = rightX;
    }

    public double getTopY() {
        return this.topY;
    }

    public void setTopY(double topY) {
        this.topY = topY;
    }

    public double getBottomY() {
        return this.bottomY;
    }

    public void setBottomY(double bottomY) {
        this.bottomY = bottomY;
    }

    public double getPositionX() {
        return this.positionX;
    }

    public void setPositionX(double positionX) {
        this.positionX = positionX;
    }

    public double getPositionY() {
        return this.positionY;
    }

    public void setPositionY(double positionY) {
        this.positionY = positionY;
    }

    public double getSizeWidth() {
        return this.sizeWidth;
    }

    public void setSizeWidth(double sizeWidth) {
        this.sizeWidth = sizeWidth;
    }

    public double getSizeHeight() {
        return this.sizeHeight;
    }

    public void setSizeHeight(double sizeHeight) {
        this.sizeHeight = sizeHeight;
    }

    public double getRotationAngle() {
        return this.rotationAngle;
    }

    public void setRotationAngle(double rotationAngle) {
        this.rotationAngle = rotationAngle;
    }

    public double getRotationCenterX() {
        return this.rotationCenterX;
    }

    public void setRotationCenterX(double rotationCenterX) {
        this.rotationCenterX = rotationCenterX;
    }

    public double getRotationCenterY() {
        return this.rotationCenterY;
    }

    public void setRotationCenterY(double rotationCenterY) {
        this.rotationCenterY = rotationCenterY;
    }

    public boolean isSimpleShape() {
        return this.isSimpleShape;
    }

    public void setSimpleShape(boolean isSimpleShape) {
        this.isSimpleShape = isSimpleShape;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public Text getText() {
        return this.text;
    }

    public void setText(Text text) {
        this.text = text;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Bitmap getBitmap() {
        return this.bitmap;
    }

    public void setBitmap(Bitmap bitmap) {
        this.bitmap = bitmap;
    }

    public Curve getCurve() {
        return this.curve;
    }

    public void setCurve(Curve curve) {
        this.curve = curve;
    }

    public Group getGroup() {
        return this.group;
    }

    public void setGroup(Group group) {
        this.group = group;
    }

    public Ellipse getEllipse() {
        return this.ellipse;
    }

    public void setEllipse(Ellipse ellipse) {
        this.ellipse = ellipse;
    }

    public String getFill() {
        Dispatch dispatchFill = Dispatch.get((Dispatch)this.dispatch, (String)"Fill").toDispatch();
        int type = Dispatch.get((Dispatch)dispatchFill, (String)"Type").getInt();
        if (type == 0) {
            return "None";
        }
        try {
            Dispatch dispatchUniformColor = Dispatch.get((Dispatch)dispatchFill, (String)"UniformColor").toDispatch();
            Dispatch.call((Dispatch)dispatchUniformColor, (String)"ConvertToRGB");
            int red = Dispatch.get((Dispatch)dispatchUniformColor, (String)"RGBRed").getInt();
            int green = Dispatch.get((Dispatch)dispatchUniformColor, (String)"RGBGreen").getInt();
            int blue = Dispatch.get((Dispatch)dispatchUniformColor, (String)"RGBBlue").getInt();
            return Colors.rgb2hex(red, green, blue);
        }
        catch (Exception exception) {
            return "None";
        }
    }

    public String toSvg() {
        StringBuffer strb = new StringBuffer();
        switch (this.type) {
            case 6: {
                strb.append(this.toTextSvg());
                break;
            }
            case 5: {
                strb.append(this.toBitmapSvg());
                break;
            }
            case 1: {
                strb.append(this.toRectangeSvg());
                break;
            }
            case 2: {
                strb.append(this.toEllipseSvg());
                break;
            }
            case 3: {
                strb.append(this.toCurveSvg());
                break;
            }
            case 7: {
                strb.append(this.group.toSvg());
                break;
            }
        }
        return strb.toString();
    }

    public String toTextSvg() {
        String textContent = this.text.getTextRange().getText();
        ArrayList<Integer> posList = new ArrayList<Integer>();
        int i = 0;
        while (i < textContent.length()) {
            if (textContent.charAt(i) == '\r') {
                posList.add(i);
            }
            ++i;
        }
        Font font = new Font(this.text.getTextRange().getFont(), 0, (int)UnitUtil.point2pixel(this.text.getTextRange().getSize(), 300));
        List<String> strs = FontUtil.toPathData(font, textContent);
        LineMetrics lm = FontUtil.getLineMetrics(font, textContent);
        Rectangle2D rect = FontUtil.getRectangle2D(font, textContent);
        StringBuffer strb = new StringBuffer();
        strb.append("<g opacity=\"1\" transform=\"translate(" + this.application.getDocument().getRealX(this) + " " + this.application.getDocument().getRealY(this) + ") rotate(0," + this.sizeWidth / 2.0 + "," + this.sizeHeight / 2.0 + ") scale(1 1)\" ").append("data-fontfamily=\"").append(this.text.getTextRange().getFont()).append("\" ").append("data-fontsize=\"").append(this.text.getTextRange().getSize()).append("pt\" ").append("data-text=\"").append(textContent).append("\" ").append("data-underlineoffset=\"").append(lm.getUnderlineOffset()).append("\" ").append("data-underlinethickness=\"").append(lm.getUnderlineThickness()).append("\" ").append("data-letterspacing=\"").append(0).append("\" ").append("data-mathheight=\"").append(0).append("\" ").append("data-singleheight=\"").append(0).append("\" ").append("data-lineheight=\"").append(0).append("\" ").append("data-fontweight=\"").append(0).append("\" ").append("data-texty=\"").append(0).append("\" ").append("data-textzoom=\"1 1\">").append("<svg ").append("width=\"").append(this.sizeWidth).append("\" ").append("height=\"").append(this.sizeHeight).append("\" ").append("viewBox=\"0 0 ").append(this.sizeWidth).append(" ").append(this.sizeHeight).append("\" ").append("preserveAspectRatio=\"none\">").append("<g transform=\"translate(0," + -rect.getY() + ")\">");
        int index = 0;
        double dy = Math.abs(rect.getHeight());
        double py = 0.0;
        double lx = 0.0;
        for (String str : strs) {
            BigDecimal data2;
            BigDecimal data1;
            String d = Jsons.getString((String)str, (String)"d");
            String sx = Jsons.getString((String)str, (String)"x");
            String w = Jsons.getString((String)str, (String)"width");
            String h = Jsons.getString((String)str, (String)"height");
            double y = 0.0;
            if (posList.size() > 0) {
                int i2 = 0;
                while (i2 < posList.size()) {
                    if (index <= (Integer)posList.get(i2)) {
                        y = (double)i2 * dy;
                        break;
                    }
                    ++i2;
                }
            }
            if ((data1 = new BigDecimal(py)).compareTo(data2 = new BigDecimal(y)) != 0) {
                lx = Double.parseDouble(sx);
            }
            double x = Double.parseDouble(sx) - lx;
            strb.append("<g class=\"font-path\" transform=\"translate(" + x + "," + y + ") skewX(0)\" data-width=\"" + w + "\" data-heihgt=\"" + h + "\">");
            strb.append("<path fill=\"" + this.getFill() + "\" d=\"" + d + "\" >");
            strb.append("</path></g>");
            ++index;
            py = y;
        }
        strb.append("</g></svg></g>");
        return strb.toString();
    }

    public String toBitmapSvg() {
        StringBuffer strb = new StringBuffer();
        strb.append("<g opacity=\"1\" transform=\"translate(" + this.application.getDocument().getRealX(this) + " " + this.application.getDocument().getRealY(this) + ") rotate(0," + this.sizeWidth / 2.0 + "," + this.sizeHeight / 2.0 + ") scale(1 1)\">").append("<svg ").append("width=\"").append(this.sizeWidth).append("\" ").append("height=\"").append(this.sizeHeight).append("\" ").append("viewBox=\"0 0 ").append(this.sizeWidth).append(" ").append(this.sizeHeight).append("\" ").append("preserveAspectRatio=\"none\">").append("<image ").append("width=\"").append(this.sizeWidth).append("\" ").append("height=\"").append(this.sizeHeight).append("\" ").append("xlink:href=\"").append(this.name).append("\" ").append(">").append("</image>").append("</svg></g>");
        return strb.toString();
    }

    public String toRectangeSvg() {
        StringBuffer strb = new StringBuffer();
        strb.append("<g opacity=\"1\" transform=\"translate(" + this.application.getDocument().getRealX(this) + " " + this.application.getDocument().getRealY(this) + ") rotate(" + this.rotationAngle + "," + this.sizeWidth / 2.0 + "," + this.sizeHeight / 2.0 + ") scale(1 1)\">").append("<svg ").append("width=\"").append(this.sizeWidth).append("\" ").append("height=\"").append(this.sizeHeight).append("\" ").append("viewBox=\"0 0 ").append(this.sizeWidth).append(" ").append(this.sizeHeight).append("\" ").append("preserveAspectRatio=\"none\">").append("<rect fill=\"" + this.getFill() + "\" ").append("width=\"").append(this.sizeWidth).append("\" ").append("height=\"").append(this.sizeHeight).append("\" ").append(">").append("</rect>").append("</svg></g>");
        return strb.toString();
    }

    public String toEllipseSvg() {
        StringBuffer strb = new StringBuffer();
        strb.append("<g opacity=\"1\" transform=\"translate(" + this.application.getDocument().getRealX(this) + " " + this.application.getDocument().getRealY(this) + ") rotate(" + this.rotationAngle + "," + this.sizeWidth / 2.0 + "," + this.sizeHeight / 2.0 + ") scale(1 1)\">").append("<svg ").append("width=\"").append(this.sizeWidth).append("\" ").append("height=\"").append(this.sizeHeight).append("\" ").append("viewBox=\"0 0 ").append(this.sizeWidth).append(" ").append(this.sizeHeight).append("\" ").append("preserveAspectRatio=\"none\">").append("<ellipse fill=\"" + this.getFill() + "\" ").append("cx=\"").append(this.application.getDocument().getRealX(this, this.ellipse.getCenterX()) - this.application.getDocument().getRealX(this)).append("\" ").append("cy=\"").append(this.application.getDocument().getRealY(this, -this.ellipse.getCenterY()) - this.application.getDocument().getRealY(this)).append("\" ").append("rx=\"").append(this.ellipse.gethRadius()).append("\" ").append("ry=\"").append(this.ellipse.getvRadius()).append("\" ").append(">").append("</ellipse>").append("</svg></g>");
        return strb.toString();
    }

    public String toCurveSvg() {
        StringBuffer strb = new StringBuffer();
        strb.append("<g opacity=\"1\" transform=\"translate(" + this.application.getDocument().getRealX(this) + " " + this.application.getDocument().getRealY(this) + ") rotate(0," + this.sizeWidth / 2.0 + "," + this.sizeHeight / 2.0 + ") scale(1 1)\">").append("<svg ").append("width=\"").append(this.sizeWidth).append("\" ").append("height=\"").append(this.sizeHeight).append("\" ").append("viewBox=\"0 0 ").append(this.sizeWidth).append(" ").append(this.sizeHeight).append("\" ").append("preserveAspectRatio=\"none\">").append("<g>").append(this.curve.toSvg()).append("</g></svg></g>");
        return strb.toString();
    }
}

