/*
 * Decompiled with CFR 0.152.
 */
package com.zhiqim.media.service.cdr;

import com.jacob.com.Dispatch;
import com.zhiqim.media.service.cdr.Application;
import com.zhiqim.media.service.cdr.CdrConstants;
import com.zhiqim.media.service.cdr.CdrDispatch;
import com.zhiqim.media.service.cdr.Node;
import com.zhiqim.media.service.cdr.Shape;

public class Segment
extends CdrDispatch
implements CdrConstants {
    private int type;
    private double length;
    private Node startNode;
    private Node endNode;
    private Shape shape;

    public Segment(Application application, Dispatch dispatch, Shape shape) {
        super(application, dispatch);
        this.shape = shape;
        this.parse();
    }

    @Override
    protected void parseComposite() {
        Dispatch dispatchStartNode = Dispatch.get((Dispatch)this.dispatch, (String)"StartNode").toDispatch();
        Dispatch dispatchEndNode = Dispatch.get((Dispatch)this.dispatch, (String)"EndNode").toDispatch();
        this.setStartNode(new Node(this.application, dispatchStartNode));
        this.setEndNode(new Node(this.application, dispatchEndNode));
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public double getLength() {
        return this.length;
    }

    public void setLength(double length) {
        this.length = length;
    }

    public Node getStartNode() {
        return this.startNode;
    }

    public void setStartNode(Node startNode) {
        this.startNode = startNode;
    }

    public Node getEndNode() {
        return this.endNode;
    }

    public void setEndNode(Node endNode) {
        this.endNode = endNode;
    }

    public String toSvg() {
        StringBuffer strb = new StringBuffer();
        Node endNode = this.getEndNode();
        double ex = this.application.getDocument().getRealX(this.shape, endNode.getPositionX()) - this.application.getDocument().getRealX(this.shape, this.shape.getLeftX());
        double ey = this.application.getDocument().getRealY(this.shape, -endNode.getPositionY()) - this.application.getDocument().getRealY(this.shape, -this.shape.getTopY());
        switch (this.getType()) {
            case 0: {
                strb.append("L" + ex + "," + ey + " ");
                break;
            }
            case 1: {
                double startPX = this.application.getDocument().getRealX(this.shape, this.getDouble("StartingControlPointX")) - this.application.getDocument().getRealX(this.shape, this.shape.getLeftX());
                double startPY = this.application.getDocument().getRealY(this.shape, -this.getDouble("StartingControlPointY")) - this.application.getDocument().getRealY(this.shape, -this.shape.getTopY());
                double endPx = this.application.getDocument().getRealX(this.shape, this.getDouble("EndingControlPointX")) - this.application.getDocument().getRealX(this.shape, this.shape.getLeftX());
                double endPy = this.application.getDocument().getRealY(this.shape, -this.getDouble("EndingControlPointY")) - this.application.getDocument().getRealY(this.shape, -this.shape.getTopY());
                strb.append("C" + startPX + "," + startPY + " ");
                strb.append(String.valueOf(endPx) + "," + endPy + " ");
                strb.append(String.valueOf(ex) + "," + ey + " ");
                break;
            }
        }
        return strb.toString();
    }
}

