/*
 * Decompiled with CFR 0.152.
 */
package com.zhiqim.media.service.cache;

import com.zhiqim.media.dbo.MaterialCat;
import com.zhiqim.media.service.cache.MediaFontCache;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.zhiqim.kernel.annotation.AnAlias;
import org.zhiqim.kernel.logging.Log;
import org.zhiqim.kernel.logging.LogFactory;
import org.zhiqim.kernel.util.Lists;
import org.zhiqim.kernel.util.Validates;
import org.zhiqim.orm.ORM;
import org.zhiqim.orm.ZTable;
import org.zhiqim.orm.dbo.Selector;

@AnAlias(value={"MaterialCatCache"})
public class MaterialCatCache {
    private static final Log log = LogFactory.getLog(MediaFontCache.class);
    private List<MaterialCat> catList = new ArrayList<MaterialCat>();
    private Map<String, MaterialCat> catMap = new HashMap<String, MaterialCat>();

    public List<MaterialCat> list() {
        return this.catList;
    }

    public MaterialCat get(String catCode) {
        return this.catMap.get(catCode);
    }

    public List<MaterialCat> getCatList(String typeCode) {
        ArrayList<MaterialCat> tempList = new ArrayList<MaterialCat>();
        for (MaterialCat item : this.catList) {
            if (!item.getTypeCode().equals(typeCode)) continue;
            tempList.add(item);
        }
        return tempList;
    }

    public List<String> getCatLabelList(String catCode) {
        MaterialCat cat = this.catMap.get(catCode);
        if (cat != null) {
            return Lists.toStringList((String)cat.getCatLabel());
        }
        return new ArrayList<String>();
    }

    public String getName(String catCode) {
        if (Validates.isEmpty((String)catCode)) {
            return "";
        }
        return this.catMap.get(catCode).getCatName();
    }

    public synchronized MaterialCatCache doRefresh() {
        try {
            this.catList.clear();
            this.catMap.clear();
            Selector selector = new Selector();
            selector.addOrderbyAsc("catSeq");
            selector.addMust("catStatus", (Object)0);
            this.catList = ((ZTable)ORM.get(ZTable.class)).list(MaterialCat.class, selector);
            for (MaterialCat cat : this.catList) {
                this.catMap.put(cat.getCatCode(), cat);
            }
        }
        catch (Exception e) {
            log.error((Object)"\u5237\u65b0\u7d20\u6750\u5206\u7c7b\u7f13\u5b58\u5f02\u5e38", (Throwable)e, new Object[0]);
        }
        return this;
    }
}

