/*
 * Decompiled with CFR 0.152.
 */
package com.zhiqim.media.service.cache;

import com.zhiqim.media.dbo.MaterialSvg;
import com.zhiqim.media.service.cache.MediaFontCache;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.zhiqim.kernel.annotation.AnAlias;
import org.zhiqim.kernel.logging.Log;
import org.zhiqim.kernel.logging.LogFactory;
import org.zhiqim.kernel.util.Validates;
import org.zhiqim.orm.ORM;
import org.zhiqim.orm.ZTable;
import org.zhiqim.orm.dbo.Selector;

@AnAlias(value={"MaterialCache"})
public class MaterialCache {
    private static final Log log = LogFactory.getLog(MediaFontCache.class);
    private List<MaterialSvg> materialList = new ArrayList<MaterialSvg>();
    private Map<Long, MaterialSvg> cacheMap = new HashMap<Long, MaterialSvg>();
    private Map<String, List<MaterialSvg>> catMap = new HashMap<String, List<MaterialSvg>>();
    private Map<String, List<MaterialSvg>> typeMap = new HashMap<String, List<MaterialSvg>>();

    public MaterialSvg item(long svgId) {
        return this.cacheMap.get(svgId);
    }

    public List<MaterialSvg> list(String typeCode) {
        if (Validates.isEmpty((String)typeCode)) {
            return new ArrayList<MaterialSvg>();
        }
        return this.typeMap.get(typeCode);
    }

    public List<MaterialSvg> list(String catCode, String keyword) {
        if (Validates.isEmpty((String)catCode)) {
            return new ArrayList<MaterialSvg>();
        }
        if (Validates.isEmpty((String)keyword)) {
            return this.catMap.get(catCode);
        }
        ArrayList<MaterialSvg> tempList = new ArrayList<MaterialSvg>();
        for (MaterialSvg svg : this.catMap.get(catCode)) {
            String keywords = svg.getKeywords();
            if (!Validates.isNotEmpty((String)keywords) || !keywords.contains(keyword)) continue;
            tempList.add(svg);
        }
        return tempList;
    }

    public synchronized MaterialCache doRefresh() {
        try {
            this.materialList.clear();
            this.typeMap.clear();
            this.cacheMap.clear();
            this.catMap.clear();
            Selector selector = new Selector();
            selector.addOrderbyAsc("svgSeq");
            selector.addMust("svgStatus", (Object)0);
            this.materialList = ((ZTable)ORM.get(ZTable.class)).list(MaterialSvg.class, selector);
            for (MaterialSvg item : this.materialList) {
                this.cacheMap.put(item.getSvgId(), item);
                String key = item.getCatCode();
                if (this.catMap.containsKey(key)) {
                    this.catMap.get(key).add(item);
                } else {
                    ArrayList<MaterialSvg> tempList = new ArrayList<MaterialSvg>();
                    tempList.add(item);
                    this.catMap.put(key, tempList);
                }
                String typeCode = item.getTypeCode();
                if (this.typeMap.containsKey(typeCode)) {
                    this.typeMap.get(typeCode).add(item);
                    continue;
                }
                ArrayList<MaterialSvg> tempList = new ArrayList<MaterialSvg>();
                tempList.add(item);
                this.typeMap.put(typeCode, tempList);
            }
        }
        catch (Exception e) {
            log.error((Object)"\u5237\u65b0\u7d20\u6750\u7f13\u5b58\u5f02\u5e38", (Throwable)e, new Object[0]);
        }
        return this;
    }
}

