/*
 * Decompiled with CFR 0.152.
 */
package com.zhiqim.media.manage.presenter;

import com.zhiqim.media.dbo.MaterialSvg;
import com.zhiqim.media.dbo.MediaBg;
import com.zhiqim.media.dbo.MediaCanvas;
import com.zhiqim.media.dbo.MediaCoverMaterial;
import com.zhiqim.media.dbo.MediaMaterial;
import com.zhiqim.media.dbo.MediaTempImage;
import com.zhiqim.media.manage.MediaEditBootstrap;
import com.zhiqim.media.service.dao.BaiduDao;
import com.zhiqim.media.service.dao.MediaDao;
import com.zhiqim.media.service.dao.MediaPathDao;
import com.zhiqim.media.service.dao.PdfDao;
import com.zhiqim.media.service.handler.MediaHandlePdfModel;
import com.zhiqim.media.service.model.MediaModel;
import com.zhiqim.media.service.util.FontUtil;
import com.zhiqim.media.service.util.SanselanUtil;
import com.zhiqim.media.service.util.UnitUtil;
import com.zhiqim.media.service.util.qrcode.QrcodeUtil;
import java.awt.Font;
import java.awt.font.LineMetrics;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.zhiqim.httpd.HttpRequest;
import org.zhiqim.httpd.context.annotation.AnIntercept;
import org.zhiqim.httpd.validate.Validate;
import org.zhiqim.httpd.validate.ones.IsNotEmpty;
import org.zhiqim.httpd.validate.onex.IsInteger;
import org.zhiqim.kernel.annotation.AnAlias;
import org.zhiqim.kernel.annotation.AnFilterNot;
import org.zhiqim.kernel.annotation.AnTransaction;
import org.zhiqim.kernel.extend.HashMapSO;
import org.zhiqim.kernel.extend.HashMapSV;
import org.zhiqim.kernel.httpclient.HttpGetStream;
import org.zhiqim.kernel.json.Jsons;
import org.zhiqim.kernel.logging.Log;
import org.zhiqim.kernel.logging.LogFactory;
import org.zhiqim.kernel.paging.PageResult;
import org.zhiqim.kernel.util.DateTimes;
import org.zhiqim.kernel.util.Files;
import org.zhiqim.kernel.util.Ids;
import org.zhiqim.kernel.util.Lists;
import org.zhiqim.kernel.util.Objects;
import org.zhiqim.kernel.util.Strings;
import org.zhiqim.kernel.util.Validates;
import org.zhiqim.kernel.util.Zips;
import org.zhiqim.kernel.util.codes.Base64;
import org.zhiqim.orm.ORM;
import org.zhiqim.orm.ZTable;
import org.zhiqim.orm.dbo.Selector;
import org.zhiqim.orm.dbo.Updater;
import org.zhiqim.uploadlarge.dbo.UpllFile;

@AnAlias(value={"MediaPresenter"})
@AnIntercept(value={"chkZmrLogin"})
public class MediaPresenter {
    private static Log log = LogFactory.getLog(MediaPresenter.class);

    @AnFilterNot
    public static void getMediaSvg(HttpRequest request, long svgId) throws Exception {
        MaterialSvg item = (MaterialSvg)((ZTable)ORM.get(ZTable.class)).item(MaterialSvg.class, new Object[]{svgId});
        request.setResponseResult(item.toString());
    }

    @AnFilterNot
    public static void getPathData(HttpRequest request, String name, int style, String fontSize, String str, String wordsList) {
        int size = UnitUtil.convert(fontSize);
        Font font = new Font(name, style, size);
        List words = null;
        if (!Validates.isEmpty((String)wordsList)) {
            words = Jsons.toList((String)wordsList, String.class);
        }
        String[] strArray = str.split("\n");
        int wordsIndex = 0;
        ArrayList<String> dataList = new ArrayList<String>();
        ArrayList<Double> lhList = new ArrayList<Double>();
        ArrayList<Double> tyList = new ArrayList<Double>();
        ArrayList<Float> ulOffsetList = new ArrayList<Float>();
        ArrayList<Float> ulThicknessList = new ArrayList<Float>();
        int i = 0;
        while (i < strArray.length) {
            String lineStr = strArray[i];
            if (Validates.isEmpty((String)lineStr)) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("dx", 0);
                map.put("width", 0);
                map.put("x", 0);
                map.put("y", 0);
                map.put("pathList", "");
                dataList.add(Jsons.toString(map));
            } else {
                List<String> list = FontUtil.toPathData(font, lineStr);
                Rectangle2D rect = FontUtil.getRectangle2D(font, lineStr);
                LineMetrics lm = FontUtil.getLineMetrics(font, str);
                if (words != null) {
                    int j = 0;
                    while (j < lineStr.length()) {
                        if (wordsIndex < words.size()) {
                            HashMapSV word = Jsons.toMapSV((String)((String)words.get(wordsIndex)), String.class);
                            ++wordsIndex;
                            int wordWeight = "1".equals(word.get("fontWeight")) ? 1 : 0;
                            String fontFamily = (String)word.get("fontFamily");
                            if (!name.equals(fontFamily) || style != wordWeight) {
                                Font wordFont = new Font(fontFamily, wordWeight, size);
                                Map<String, Object> wordPath = FontUtil.toEachPathByChar(wordFont, lineStr.charAt(j));
                                String pathD = Strings.valueOf((Object)wordPath.get("d"));
                                Map map = Jsons.toMapSV((String)list.get(j), String.class).instance();
                                map.put("d", pathD);
                                list.set(j, Jsons.toString((Object)map));
                            }
                        }
                        ++j;
                    }
                }
                lhList.add(rect.getHeight());
                tyList.add(rect.getY());
                ulOffsetList.add(Float.valueOf(lm.getUnderlineOffset()));
                ulThicknessList.add(Float.valueOf(lm.getUnderlineThickness()));
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("dx", FontUtil.getShape(font, lineStr, 0).getBounds().getX());
                map.put("width", rect.getWidth());
                map.put("x", rect.getX());
                map.put("y", rect.getY());
                map.put("pathList", list);
                map.put("underlineOffset", Float.valueOf(lm.getUnderlineOffset()));
                map.put("underlineThickness", Float.valueOf(lm.getUnderlineThickness()));
                dataList.add(Jsons.toString(map));
            }
            ++i;
        }
        Double lineHeight = (Double)Collections.max(lhList);
        Double textY = (Double)Collections.max(tyList);
        Float underlineOffset = (Float)Collections.max(ulOffsetList);
        Float underlineThickness = (Float)Collections.max(ulThicknessList);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("textY", textY);
        map.put("lineHeight", lineHeight);
        map.put("underlineOffset", underlineOffset);
        map.put("underlineThickness", underlineThickness);
        map.put("data", Jsons.toString(dataList));
        request.setResponseResult(Jsons.toString(map));
    }

    @AnFilterNot
    public static void downloadImage(HttpRequest request, String imgUrl, long mediaId) throws Exception {
        HttpGetStream conn = new HttpGetStream(imgUrl);
        conn.setConnectTimeout(10);
        conn.execute();
        if (conn.getResponseStatus() != 200) {
            request.setResponseResult(701, "\u8bfb\u53d6\u7f51\u7edc\u56fe\u7247\u8d85\u65f6\uff0c\u8bf7\u91cd\u8bd5");
            return;
        }
        byte[] bytes = conn.getBytes();
        SanselanUtil.checkImageInfo(bytes);
        String fileName = String.valueOf(Ids.longId()) + ".jpg";
        String curDate = DateTimes.getDateTime8String();
        String jpgFile = String.valueOf(MediaPathDao.getDesignMaterialLocalPre(curDate)) + fileName;
        if (bytes.length > 0xA00000) {
            request.setResponseResult(701, "\u56fe\u7247\u6700\u5927\u652f\u630110M");
            return;
        }
        UpllFile file = MediaPathDao.createUpllFile(bytes, jpgFile);
        if (file == null) {
            request.setResponseResult(703, "\u52a0\u8f7d\u7f51\u7edc\u56fe\u7247\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5!");
            return;
        }
        request.setResponseResult(Jsons.toString((String)"fileId", (Object)file.getFileId(), (String)"fileUrl", (Object)file.getFileUrl()));
    }

    public static void saveLocalImage(HttpRequest request, String fileData, long mediaId) throws Exception {
        String[] str = fileData.split(",");
        byte[] bytes = Base64.decode((String)str[1]);
        String fileName = String.valueOf(Ids.longId19()) + ".jpg";
        String curDate = DateTimes.getDateTime8String();
        if (bytes.length > 0x500000) {
            request.setResponseResult(701, "\u56fe\u7247\u6700\u5927\u652f\u630110M");
            return;
        }
        SanselanUtil.checkImageInfo(bytes);
        String jpgFile = String.valueOf(MediaPathDao.getDesignMaterialLocalPre(curDate)) + fileName;
        UpllFile file = MediaPathDao.createUpllFile(bytes, jpgFile);
        if (file == null) {
            request.setResponseResult(701, "\u8bfb\u53d6\u56fe\u7247\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5\uff01");
            return;
        }
        request.setResponseResult(Jsons.toString((String)"fileId", (Object)file.getFileId(), (String)"fileUrl", (Object)file.getFileUrl()));
    }

    @AnFilterNot
    public static void doSaveMediaData(HttpRequest request) throws Exception {
        String mediaJson = request.getParameterNoFilter("mediaJson");
        if (Validates.isEmptyBlank((String)mediaJson)) {
            request.setResponseError("\u7d20\u6750\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a");
            return;
        }
        long mediaId = request.getParameterLong("mediaId");
        if (mediaId < 0L) {
            request.setResponseError("\u672a\u77e5\u6a21\u677f\u53f7");
            return;
        }
        MediaCanvas canvas = (MediaCanvas)((ZTable)ORM.get(ZTable.class)).item(MediaCanvas.class, new Object[]{mediaId});
        if (canvas != null && canvas.getIsEdit() == 1) {
            request.setResponseError("\u8be5\u6a21\u677f\u4e3a\u4e0d\u5141\u8bb8\u7f16\u8f91\u72b6\u6001");
            return;
        }
        MediaModel media = (MediaModel)Jsons.toObject((String)mediaJson, MediaModel.class);
        MediaDao.saveMedia(media);
    }

    public static void doIsSaveingOrTopdf(HttpRequest request) throws Exception {
        long mediaId = request.getParameterLong("mediaId");
        mediaId = mediaId < 0L ? 0L : mediaId;
        MediaCanvas canvas = (MediaCanvas)((ZTable)ORM.get(ZTable.class)).item(MediaCanvas.class, new Object[]{mediaId});
        if (canvas != null && canvas.getIsEdit() == 1) {
            request.setResponseError("\u8be5\u6a21\u677f\u4e3a\u4e0d\u5141\u8bb8\u7f16\u8f91\u72b6\u6001");
            return;
        }
        HashMap<String, Boolean> jsonMap = new HashMap<String, Boolean>();
        jsonMap.put("isSaveing", canvas != null ? canvas.getIsEdit() == 2 : false);
        jsonMap.put("isHandelTopdf", canvas != null ? canvas.getIsEdit() == 3 : false);
        request.setResponseResult(Jsons.toString(jsonMap));
    }

    @AnFilterNot
    public static void doSaveMedia(HttpRequest request) throws Exception {
        String mediaJson = request.getParameterNoFilter("mediaJson");
        String paramJson = request.getParameterNoFilter("paramJson");
        if (Validates.isEmptyBlank((String)mediaJson)) {
            request.setResponseError("\u7d20\u6750\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a");
            return;
        }
        long mediaId = request.getParameterLong("mediaId");
        if (mediaId < 0L) {
            request.setResponseError("\u672a\u77e5\u6a21\u677f\u53f7");
            return;
        }
        MediaCanvas canvas = (MediaCanvas)((ZTable)ORM.get(ZTable.class)).item(MediaCanvas.class, new Object[]{mediaId});
        if (canvas != null && canvas.getIsEdit() == 1) {
            request.setResponseError("\u8be5\u6a21\u677f\u4e3a\u4e0d\u5141\u8bb8\u7f16\u8f91\u72b6\u6001");
            return;
        }
        long saveHandelId = MediaDao.doSaveMediaHandleModel(mediaId, mediaJson, paramJson);
        if (saveHandelId <= 0L) {
            request.setResponseError("\u670d\u52a1\u7aef\u672a\u80fd\u6b63\u786e\u5904\u7406");
            return;
        }
        request.setResponseResult(Jsons.toString((String)"saveHandelId", (Object)saveHandelId));
    }

    @AnFilterNot
    public static void doAutoSaveMedia(HttpRequest request) throws Exception {
        long saveHandelId;
        request.addValidate((Validate)new IsNotEmpty("mediaJson", "\u7d20\u6750\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a"));
        if (!request.chkValidate()) {
            request.setResponseError(request.getAlertMsg());
            return;
        }
        String mediaJson = request.getParameterNoFilter("mediaJson");
        String paramJson = request.getParameterNoFilter("paramJson");
        boolean isDoImg = request.getParameterBoolean("isDoImg", false);
        long mediaId = request.getParameterLong("mediaId");
        if (mediaId < 0L) {
            request.setResponseError("\u672a\u77e5\u6a21\u677f\u53f7");
            return;
        }
        MediaCanvas canvas = (MediaCanvas)((ZTable)ORM.get(ZTable.class)).item(MediaCanvas.class, new Object[]{mediaId});
        if (canvas != null && canvas.getIsEdit() == 1) {
            request.setResponseError("\u8be5\u6a21\u677f\u4e3a\u4e0d\u5141\u8bb8\u7f16\u8f91\u72b6\u6001");
            return;
        }
        if (canvas == null) {
            request.setResponseError("\u6a21\u677f\u6a21\u677f\u4e0d\u5b58\u5728");
            return;
        }
        if (((ZTable)ORM.get(ZTable.class)).count(MediaCanvas.class, new Object[]{mediaId}) <= 0) {
            isDoImg = true;
        }
        if ((saveHandelId = MediaDao.doSaveMediaHandleModel(mediaId, mediaJson, paramJson, isDoImg, isDoImg)) <= 0L) {
            request.setResponseError("\u670d\u52a1\u7aef\u672a\u80fd\u6b63\u786e\u5904\u7406");
            return;
        }
        request.setResponseResult(Jsons.toString((String)"saveHandelId", (Object)saveHandelId));
    }

    public static void doQuerySaveMediaStatus(HttpRequest request) throws Exception {
        long saveHandelId = request.getParameterLong("saveHandelId");
        request.setResponseResult(Jsons.toString((Object)MediaDao.doQueryMediaHandleModel(saveHandelId, true)));
    }

    public static void doQueryHandelPdfStatus(HttpRequest request) throws Exception {
        long pdfHandelId = request.getParameterLong("pdfHandelId");
        MediaHandlePdfModel m = MediaDao.doQueryMediaHandlePdfModel(pdfHandelId, true);
        request.setResponseResult(Jsons.toString((Object)m));
    }

    public static void doQueryMaterial(HttpRequest request) throws Exception {
        String typeCode = request.getParameter("typeCode");
        String catCode = request.getParameter("catCode");
        String q = request.getParameter("q");
        int page = request.getParameterInt("page", 1);
        int pageSize = request.getParameterInt("pageSize", 27);
        Selector sel = new Selector();
        if (Validates.isNotEmpty((String)typeCode) && !typeCode.equals("search")) {
            sel.addMaybe("typeCode", (Object)typeCode);
        }
        sel.addMust("svgStatus", (Object)0);
        sel.addMaybe("catCode", (Object)catCode);
        sel.addMaybeLike("keywords", (Object)q);
        sel.addOrderbyAsc("svgSeq");
        PageResult materialResult = ((ZTable)ORM.get(ZTable.class)).page(MaterialSvg.class, page, pageSize, sel);
        HashMapSO attrMap = new HashMapSO();
        attrMap.put("result", (Object)materialResult);
        attrMap.put("typeCode", (Object)typeCode);
        attrMap.put("catCode", (Object)catCode);
        attrMap.put("page", (Object)page);
        attrMap.put("q", (Object)q);
        attrMap.put("pageSize", (Object)pageSize);
        attrMap.put("totalPages", (Object)materialResult.totalPages());
        request.setResponseResult(Jsons.toString((Object)attrMap));
    }

    public static void doAddMaterialKeywords(HttpRequest request) throws Exception {
        request.addValidate((Validate)new IsInteger("svgId", "\u8bf7\u9009\u62e9\u7d20\u6750ID"));
        if (!request.chkValidate()) {
            request.setResponseError(request.getAlertMsg());
            return;
        }
        long svgId = request.getParameterLong("svgId");
        String keywords = request.getParameter("keywords");
        if (Validates.isEmpty((String)keywords)) {
            return;
        }
        ((ZTable)ORM.get(ZTable.class)).update(MaterialSvg.class, ((Updater)new Updater().addMust("svgId", (Object)svgId)).addField("keywords", (Object)keywords));
    }

    public static void doUpdateMaterialStatus(HttpRequest request) throws Exception {
        request.addValidate((Validate)new IsInteger("svgId", "\u8bf7\u9009\u62e9\u7d20\u6750ID"));
        if (!request.chkValidate()) {
            request.setResponseError(request.getAlertMsg());
            return;
        }
        long svgId = request.getParameterLong("svgId");
        int svgStatus = request.getParameterInt("svgStatus", 0);
        ((ZTable)ORM.get(ZTable.class)).update(MaterialSvg.class, ((Updater)new Updater().addMust("svgId", (Object)svgId)).addField("svgStatus", (Object)svgStatus));
    }

    public static void doUpdateMaterialSeq(HttpRequest request) throws Exception {
        request.addValidate((Validate)new IsInteger("svgId", "\u8bf7\u9009\u62e9\u7d20\u6750ID"));
        if (!request.chkValidate()) {
            request.setResponseError(request.getAlertMsg());
            return;
        }
        long svgId = request.getParameterLong("svgId");
        int svgSeq = request.getParameterInt("svgSeq", 0);
        ((ZTable)ORM.get(ZTable.class)).update(MaterialSvg.class, ((Updater)new Updater().addMust("svgId", (Object)svgId)).addField("svgSeq", (Object)svgSeq));
    }

    public static void doRecordUpload(HttpRequest request) {
        request.addValidate((Validate)new IsInteger("mediaId", "\u4e0d\u80fd\u4e3a\u7a7a"));
        request.addValidate((Validate)new IsNotEmpty("fileId", "\u4e0d\u80fd\u4e3a\u7a7a"));
        if (!request.chkValidate()) {
            return;
        }
        int type = request.getParameterInt("type", 1);
        long mediaId = request.getParameterLong("mediaId");
        String fileId = request.getParameter("fileId");
        MediaTempImage temp = new MediaTempImage();
        temp.setFileId(fileId);
        temp.setMediaId(mediaId);
        temp.setCreateTime(DateTimes.getDateTimeString());
        temp.setId(Ids.longId());
        temp.setType(type);
        try {
            ((ZTable)ORM.get(ZTable.class)).insert((Object)temp);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e, new Object[0]);
        }
    }

    public static void doRefreshCache(HttpRequest request) throws Exception {
        MediaEditBootstrap.initCache();
    }

    public static void doDownloadFile(HttpRequest request) throws Exception {
        request.addValidate((Validate)new IsInteger("mediaId", "\u4e0d\u80fd\u4e3a\u7a7a"));
        if (!request.chkValidate()) {
            request.setResponseError(request.getAlertMsg());
            return;
        }
        int fileType = request.getParameterInt("fileType", 0);
        long mediaId = request.getParameterLong("mediaId");
        String curDate = DateTimes.getDateTime8String();
        long pdfHandelId = 0L;
        MediaCanvas canvas = (MediaCanvas)((ZTable)ORM.get(ZTable.class)).item(MediaCanvas.class, new Object[]{mediaId});
        if (canvas == null) {
            request.setResponseError("\u8bf7\u5148\u4fdd\u5b58\u6a21\u677f\u540e\u518d\u4e0b\u8f7d");
            return;
        }
        String downloadUrl = null;
        boolean nonsynchronousTopdf = false;
        double width = canvas.getWidth();
        double height = canvas.getHeight();
        double fullWidth = canvas.getFullWidth();
        double fullHeight = canvas.getFullHeight();
        long id = Ids.longId();
        if (fileType == 3) {
            String pre_url = MediaPathDao.MEDIA_URL_PRE;
            double baseWidthMm = canvas.getBaseWidthMm();
            double baseHeightMm = canvas.getBaseHeightMm();
            String content = MediaDao.toSvgFileContent(mediaId, pre_url, baseWidthMm, baseHeightMm, fullWidth, fullHeight, null, null, null, "SVG");
            String fileName = String.valueOf(Ids.longId()) + ".svg";
            boolean isSuccess = Files.writeUTF8((String)(String.valueOf(MediaPathDao.getTempLocalPre(curDate)) + fileName), (String)content);
            downloadUrl = String.valueOf(MediaPathDao.getTempUrlPre(curDate)) + fileName;
            if (!isSuccess) {
                request.setResponseError("\u751f\u6210svg\u6587\u4ef6\u5931\u8d25");
                return;
            }
        } else if (fileType == 4) {
            downloadUrl = MediaDao.toAiZipFile(mediaId);
        } else if (fileType == 5 || fileType == 2) {
            String savePath = String.valueOf(MediaPathDao.getTempLocalPre(curDate)) + id + ".pdf";
            MediaHandlePdfModel model = new MediaHandlePdfModel(canvas, -1, false, savePath);
            model.setDownloadUrl(String.valueOf(MediaPathDao.getTempUrlPre(curDate)) + id + ".pdf");
            pdfHandelId = MediaDao.doMediaHandleToPdf(model);
            nonsynchronousTopdf = true;
            if (pdfHandelId <= 0L) {
                request.setResponseError("\u670d\u52a1\u7aefPDF\u672a\u80fd\u6b63\u786e\u5904\u7406");
                return;
            }
        } else {
            String suffix = "jpg";
            if (fileType == 1) {
                suffix = "png";
            }
            List<String> pdfList = PdfDao.getPdfList(canvas, -1, false, null, null, null, "IMAGE");
            String fileDirPath = MediaPathDao.getTempLocalPre(String.valueOf(curDate) + "/" + id);
            PdfDao.pdfToImage(pdfList, fileDirPath, suffix, (int)width, (int)height, -1);
            String zipExportPath = String.valueOf(MediaPathDao.getTempLocalPre(curDate)) + id + ".zip";
            Zips.zip((String)fileDirPath, (String)zipExportPath);
            downloadUrl = String.valueOf(MediaPathDao.getTempUrlPre(curDate)) + id + ".zip";
        }
        HashMap<String, Object> jsonMap = new HashMap<String, Object>();
        jsonMap.put("downloadUrl", downloadUrl);
        jsonMap.put("nonsynchronousTopdf", nonsynchronousTopdf);
        jsonMap.put("pdfHandelId", pdfHandelId);
        request.setResponseResult(Jsons.toString(jsonMap));
    }

    public static void doNewPage(HttpRequest request) throws Exception {
        request.addValidate((Validate)new IsInteger("mediaId", "\u4e0d\u80fd\u4e3a\u7a7a"));
        if (!request.chkValidate()) {
            request.setResponseError(request.getAlertMsg());
            return;
        }
        request.addValidate((Validate)new IsInteger("bid", "\u4e0d\u80fd\u4e3a\u7a7a"));
        if (!request.chkValidate()) {
            request.setResponseError(request.getAlertMsg());
            return;
        }
        long mediaId = request.getParameterLong("mediaId");
        int bid = request.getParameterInt("bid");
        MediaCanvas canvas = (MediaCanvas)((ZTable)ORM.get(ZTable.class)).item(MediaCanvas.class, new Object[]{mediaId});
        if (canvas == null) {
            request.setResponseError("\u6a21\u677f\u4e0d\u5b58\u5728");
            return;
        }
        if (((ZTable)ORM.get(ZTable.class)).count(MediaBg.class, new Selector("mediaId", (Object)mediaId)) >= 32) {
            request.setResponseError("\u6700\u591a\u652f\u6301\u521b\u5efa32\u4e2a\u7248\u9762");
            return;
        }
        MediaBg newBg = new MediaBg();
        newBg.setMediaId(mediaId);
        newBg.setBid(bid);
        newBg.setSource("<svg preserveAspectRatio=\"none\" width=\"" + canvas.getWidth() + "\" height=\"" + canvas.getHeight() + "\"><rect x=\"0\" y=\"0\" width=\"100%\" height=\"100%\" fill=\"#ffffff\"></rect></svg>");
        ((ZTable)ORM.get(ZTable.class)).insert((Object)newBg);
        int mid = 0;
        String coverMString = request.getParameterNoFileterOnCNT("coverMaterialList");
        for (String cmStr : Lists.toStringList((String)coverMString)) {
            MediaCoverMaterial cm = new MediaCoverMaterial();
            cm.setMediaId(mediaId);
            cm.setBid(bid);
            cm.setMid(mid);
            cm.setSource(cmStr);
            ((ZTable)ORM.get(ZTable.class)).insert((Object)cm);
            ++mid;
        }
        String json = Jsons.toString((Object)MediaDao.getMedia(mediaId));
        request.setResponseResult(json);
    }

    @AnTransaction
    public static void doCopyPage(HttpRequest request) throws Exception {
        request.addValidate((Validate)new IsInteger("mediaId", "\u4e0d\u80fd\u4e3a\u7a7a"));
        request.addValidate((Validate)new IsInteger("bid", "\u7248\u9762\u4e0d\u80fd\u4e3a\u7a7a"));
        if (!request.chkValidate()) {
            request.setResponseError(request.getAlertMsg());
            return;
        }
        long mediaId = request.getParameterLong("mediaId");
        int bid = request.getParameterInt("bid");
        MediaCanvas canvas = (MediaCanvas)((ZTable)ORM.get(ZTable.class)).item(MediaCanvas.class, new Object[]{mediaId});
        if (canvas == null) {
            request.setResponseError("\u6a21\u677f\u4e0d\u5b58\u5728");
            return;
        }
        int newIndex = ((ZTable)ORM.get(ZTable.class)).count(MediaBg.class, new Selector("mediaId", (Object)mediaId));
        if (newIndex >= 32) {
            request.setResponseError("\u6700\u591a\u652f\u6301\u521b\u5efa16\u4e2a\u7248\u9762");
            return;
        }
        MediaBg maxBg = (MediaBg)((ZTable)ORM.get(ZTable.class)).item(MediaBg.class, new Selector("mediaId", (Object)mediaId).addOrderbyDesc("bid"));
        int newBid = maxBg.getBid() + 1;
        MediaBg bg = (MediaBg)((ZTable)ORM.get(ZTable.class)).item(MediaBg.class, new Object[]{mediaId, bid});
        MediaBg newBg = new MediaBg();
        Objects.copy((Object)bg, (Object)newBg);
        newBg.setBid(newBid);
        Selector selector = ((Selector)new Selector("mediaId", (Object)mediaId).addMust("bid", (Object)bid)).addOrderbyAsc("mid");
        List materialList = ((ZTable)ORM.get(ZTable.class)).list(MediaMaterial.class, selector);
        ArrayList<MediaMaterial> newMaterialList = new ArrayList<MediaMaterial>();
        for (MediaMaterial m : materialList) {
            MediaMaterial newM = new MediaMaterial();
            Objects.copy((Object)m, (Object)newM);
            newM.setBid(newBid);
            newMaterialList.add(newM);
        }
        Selector sel = ((Selector)new Selector("mediaId", (Object)mediaId).addMust("bid", (Object)bid)).addOrderbyAsc("mid");
        List coverMaterialList = ((ZTable)ORM.get(ZTable.class)).list(MediaCoverMaterial.class, sel);
        ArrayList<MediaCoverMaterial> newCoverMaterialList = new ArrayList<MediaCoverMaterial>();
        MediaDao.updateCanvasFullSize(canvas, canvas.getBaseWidthMm(), canvas.getBaseHeightMm(), true);
        double width = canvas.getWidth();
        double height = canvas.getHeight();
        double fullWidth = canvas.getFullWidth();
        double fullHeight = canvas.getFullHeight();
        int i = 0;
        while (i < coverMaterialList.size()) {
            MediaCoverMaterial cm = (MediaCoverMaterial)coverMaterialList.get(i);
            MediaCoverMaterial newCM = new MediaCoverMaterial();
            Objects.copy((Object)cm, (Object)newCM);
            newCM.setBid(newBid);
            String cmSource = MediaPresenter.updateCoverMaterialSource(cm.getSource(), width, height, fullWidth, fullHeight, bg.getOddEven(), newIndex, cm.getMid());
            newCM.setSource(cmSource);
            newCoverMaterialList.add(newCM);
            ++i;
        }
        ((ZTable)ORM.get(ZTable.class)).insert((Object)newBg);
        ((ZTable)ORM.get(ZTable.class)).insertBatch(newMaterialList);
        ((ZTable)ORM.get(ZTable.class)).insertBatch(newCoverMaterialList);
        String json = Jsons.toString((Object)MediaDao.getMedia(mediaId));
        request.setResponseResult(json);
    }

    @AnTransaction
    public static void doCopyOtherPage(HttpRequest request) throws Exception {
        request.addValidate((Validate)new IsInteger("mediaSrcId", "\u8bf7\u9009\u62e9\u9700\u590d\u5236\u7684\u6a21\u677f"));
        request.addValidate((Validate)new IsInteger("bid", "\u7248\u9762\u4e0d\u80fd\u4e3a\u7a7a"));
        request.addValidate((Validate)new IsInteger("newBid", "\u4e0d\u80fd\u4e3a\u7a7a"));
        request.addValidate((Validate)new IsInteger("mediaId", "\u4e0d\u80fd\u4e3a\u7a7a"));
        if (!request.chkValidate()) {
            request.setResponseError(request.getAlertMsg());
            return;
        }
        long mediaSrcId = request.getParameterLong("mediaSrcId");
        long mediaId = request.getParameterLong("mediaId");
        int bid = request.getParameterInt("bid");
        int newBid = request.getParameterInt("newBid");
        MediaCanvas canvasSrc = (MediaCanvas)((ZTable)ORM.get(ZTable.class)).item(MediaCanvas.class, new Object[]{mediaSrcId});
        if (canvasSrc == null) {
            request.setResponseError("\u5f85\u590d\u5236\u7684\u6a21\u677f\u4e0d\u5b58\u5728");
            return;
        }
        if (((ZTable)ORM.get(ZTable.class)).count(MediaBg.class, new Selector("mediaId", (Object)mediaId)) >= 32) {
            request.setResponseError("\u6700\u591a\u652f\u6301\u521b\u5efa16\u4e2a\u7248\u9762");
            return;
        }
        MediaBg bgSrc = (MediaBg)((ZTable)ORM.get(ZTable.class)).item(MediaBg.class, new Object[]{mediaSrcId, bid});
        if (bgSrc == null) {
            request.setResponseError("\u5f85\u590d\u5236\u7684\u6a21\u677f\u7248\u9762\u4e0d\u5b58\u5728");
            return;
        }
        MediaBg newBg = new MediaBg();
        Objects.copy((Object)bgSrc, (Object)newBg);
        newBg.setMediaId(mediaId);
        newBg.setBid(newBid);
        MediaCanvas canvas = (MediaCanvas)((ZTable)ORM.get(ZTable.class)).item(MediaCanvas.class, new Selector("mediaId", (Object)mediaId));
        String bgSource = newBg.getSource();
        String widthMatch = "width(\\s+)?=(\\s+)?\"\\d+(\\.\\d+)?\"";
        String heightMatch = "height(\\s+)?=(\\s+)?\"\\d+(\\.\\d+)?\"";
        bgSource = bgSource.replaceFirst(widthMatch, "width=\"" + canvas.getWidth() + "\"");
        bgSource = bgSource.replaceFirst(heightMatch, "height=\"" + canvas.getHeight() + "\"");
        newBg.setSource(bgSource);
        ((ZTable)ORM.get(ZTable.class)).insert((Object)newBg);
        Selector select = ((Selector)new Selector("mediaId", (Object)mediaSrcId).addMust("bid", (Object)bid)).addOrderbyAsc("mid");
        List materialSrcList = ((ZTable)ORM.get(ZTable.class)).list(MediaMaterial.class, select);
        ArrayList<MediaMaterial> newMaterialList = new ArrayList<MediaMaterial>();
        for (MediaMaterial m : materialSrcList) {
            MediaMaterial newM = new MediaMaterial();
            Objects.copy((Object)m, (Object)newM);
            newM.setMediaId(mediaId);
            newM.setBid(newBid);
            newMaterialList.add(newM);
        }
        ((ZTable)ORM.get(ZTable.class)).insertBatch(newMaterialList);
        int mid = 0;
        String coverMString = request.getParameterNoFileterOnCNT("coverMaterialList");
        for (String cmStr : Lists.toStringList((String)coverMString)) {
            MediaCoverMaterial cm = new MediaCoverMaterial();
            cm.setMediaId(mediaId);
            cm.setBid(newBid);
            cm.setMid(mid);
            cm.setSource(cmStr);
            ((ZTable)ORM.get(ZTable.class)).insert((Object)cm);
            ++mid;
        }
        String json = Jsons.toString((Object)MediaDao.getMedia(mediaId));
        request.setResponseResult(json);
    }

    @AnTransaction
    public static void doDelPage(HttpRequest request) throws Exception {
        request.addValidate((Validate)new IsInteger("mediaId", "\u4e0d\u80fd\u4e3a\u7a7a"));
        request.addValidate((Validate)new IsInteger("bid", "\u7248\u9762\u4e0d\u80fd\u4e3a\u7a7a"));
        if (!request.chkValidate()) {
            request.setResponseError(request.getAlertMsg());
            return;
        }
        long mediaId = request.getParameterLong("mediaId");
        int bid = request.getParameterInt("bid");
        MediaCanvas canvas = (MediaCanvas)((ZTable)ORM.get(ZTable.class)).item(MediaCanvas.class, new Object[]{mediaId});
        if (canvas == null) {
            request.setResponseError("\u6a21\u677f\u4e0d\u5b58\u5728");
            return;
        }
        if (bid <= 0) {
            request.setResponseError("\u7b2c\u4e00\u7248\u9762\u4e0d\u5141\u8bb8\u5220\u9664");
            return;
        }
        ((ZTable)ORM.get(ZTable.class)).delete(MediaBg.class, new Object[]{mediaId, bid});
        ((ZTable)ORM.get(ZTable.class)).delete(MediaMaterial.class, (Selector)new Selector("mediaId", (Object)mediaId).addMust("bid", (Object)bid));
        ((ZTable)ORM.get(ZTable.class)).delete(MediaCoverMaterial.class, (Selector)new Selector("mediaId", (Object)mediaId).addMust("bid", (Object)bid));
        List materialBgList = ((ZTable)ORM.get(ZTable.class)).list(MediaBg.class, new Selector("mediaId", (Object)mediaId).addOrderbyAsc("bid"));
        int i = 0;
        while (i < materialBgList.size()) {
            MediaBg bg = (MediaBg)materialBgList.get(i);
            int bgBid = bg.getBid();
            if (bgBid >= bid) {
                Selector sel = ((Selector)new Selector("mediaId", (Object)mediaId).addMust("bid", (Object)bgBid)).addOrderbyAsc("mid");
                List coverMaterialList = ((ZTable)ORM.get(ZTable.class)).list(MediaCoverMaterial.class, sel);
                if (coverMaterialList.size() != 0) {
                    double width = canvas.getWidth();
                    double height = canvas.getHeight();
                    double fullWidth = canvas.getFullWidth();
                    double fullHeight = canvas.getFullHeight();
                    for (MediaCoverMaterial cm : coverMaterialList) {
                        String cmSource = MediaPresenter.updateCoverMaterialSource(cm.getSource(), width, height, fullWidth, fullHeight, bg.getOddEven(), i, cm.getMid());
                        Updater updater = new Updater();
                        ((Updater)((Updater)((Updater)updater.addMust("mediaId", (Object)cm.getMediaId())).addMust("bid", (Object)cm.getBid())).addMust("mid", (Object)cm.getMid())).addField("source", (Object)cmSource);
                        ((ZTable)ORM.get(ZTable.class)).update(MediaCoverMaterial.class, updater);
                    }
                }
            }
            ++i;
        }
        String json = Jsons.toString((Object)MediaDao.getMedia(mediaId));
        request.setResponseResult(json);
    }

    public static String updateCoverMaterialSource(String source, double width, double height, double fullWidth, double fullHeight, long bgOddEven, int bgIndex, int cmMid) {
        String matchStr = "translate(\\s+)?\\([^\\)]+\\)";
        double widthSpace = width - fullWidth;
        double heightSpace = height - fullHeight;
        source = bgOddEven == 0L ? (bgIndex % 2 == 0 ? (cmMid == 0 ? source.replaceFirst(matchStr, "translate(" + width + " 0)") : source.replaceFirst(matchStr, "translate(0 " + height + ")")) : (cmMid == 0 ? source.replaceFirst(matchStr, "translate(" + widthSpace + " 0)") : source.replaceFirst(matchStr, "translate(" + widthSpace + " " + height + ")"))) : (bgIndex % 2 == 0 ? (cmMid == 0 ? source.replaceFirst(matchStr, "translate(0 " + widthSpace + ")") : source.replaceFirst(matchStr, "translate(" + height + " " + widthSpace + ")")) : (cmMid == 0 ? source.replaceFirst(matchStr, "translate(0 " + widthSpace + ")") : source.replaceFirst(matchStr, "translate(" + heightSpace + " " + widthSpace + ")")));
        return source;
    }

    public static void doCreateQrcode(HttpRequest request) throws Exception {
        request.addValidate((Validate)new IsNotEmpty("qrcodeText", "\u4e8c\u7ef4\u7801\u6587\u672c\u4e0d\u80fd\u4e3a\u7a7a"));
        if (!request.chkValidate()) {
            request.setResponseError(request.getAlertMsg());
            return;
        }
        String qrcodeText = request.getParameter("qrcodeText");
        String showLogo = request.getParameter("showLogo");
        String qrcodeData = request.getParameter("qrcodeData");
        int width = 600;
        int height = 600;
        String suffix = "png";
        String curDate = DateTimes.getDateTime8String();
        String qrcodePrePath = MediaPathDao.getTempLocalPre(curDate);
        String qrcodeName = Ids.longId() + "." + suffix;
        if (Validates.isEmpty((String)showLogo)) {
            QrcodeUtil.makeQrcode(qrcodeText, width, height, qrcodePrePath, qrcodeName);
        } else {
            String fileExt = Files.getFileExt((String)showLogo);
            if (!"jpg".equalsIgnoreCase(fileExt) && !"png".equals(fileExt)) {
                request.setResponseError("\u8bf7\u4e0a\u4f20jpg\u3001png\u683c\u5f0f\u7684\u56fe\u7247");
                return;
            }
            int idx = qrcodeData.indexOf(",");
            byte[] imageData = Base64.decode((String)qrcodeData.substring(idx + 1));
            String logoPath = String.valueOf(MediaPathDao.getTempLocalPre(curDate)) + Ids.longId() + "." + fileExt;
            if (!Files.write((String)logoPath, (byte[])imageData)) {
                request.setResponseError("logo\u56fe\u7247\u5b58\u50a8\u5931\u8d25");
                return;
            }
            QrcodeUtil.makeQrcode(qrcodeText, width, height, logoPath, qrcodePrePath, qrcodeName);
        }
        byte[] bytes = Files.read((String)(String.valueOf(qrcodePrePath) + qrcodeName));
        String jpgFile = String.valueOf(MediaPathDao.getDesignMaterialLocalPre(curDate)) + qrcodeName;
        UpllFile file = MediaPathDao.createUpllFile(bytes, jpgFile);
        if (file == null) {
            request.setResponseResult(703, "\u4e8c\u7ef4\u7801\u751f\u6210\u4fdd\u5b58\u5931\u8d25");
            return;
        }
        String json = Jsons.toString((String)"fileId", (Object)file.getFileId(), (String)"fileUrl", (Object)file.getFileUrl());
        request.setResponseResult(json);
    }

    public static void doAutoQrcode(HttpRequest request) throws Exception {
        request.addValidate((Validate)new IsNotEmpty("qrcodeData", "\u8bf7\u9009\u62e9\u9700\u8bc6\u522b\u7684\u4e8c\u7ef4\u7801"));
        if (!request.chkValidate()) {
            request.setResponseError(request.getAlertMsg());
            return;
        }
        String showLogo = request.getParameter("showLogo");
        String qrcodeData = request.getParameter("qrcodeData");
        String curDate = DateTimes.getDateTime8String();
        String fileExt = Files.getFileExt((String)showLogo);
        if (!"jpg".equalsIgnoreCase(fileExt) && !"png".equals(fileExt)) {
            request.setResponseError("\u8bf7\u4e0a\u4f20jpg\u3001png\u683c\u5f0f\u7684\u4e8c\u7ef4\u7801\u56fe\u7247");
            return;
        }
        int idx = qrcodeData.indexOf(",");
        byte[] imageData = Base64.decode((String)qrcodeData.substring(idx + 1));
        String logoPath = String.valueOf(MediaPathDao.getTempLocalPre(curDate)) + Ids.longId() + "." + fileExt;
        if (!Files.write((String)logoPath, (byte[])imageData)) {
            request.setResponseError("\u4e8c\u7ef4\u7801\u56fe\u7247\u4fdd\u5b58\u5931\u8d25");
            return;
        }
        String dest = QrcodeUtil.parseQrcode(logoPath);
        if (dest == null) {
            request.setResponseError("\u4e8c\u7ef4\u7801\u8bc6\u522b\u5931\u8d25\uff0c\u8bf7\u4e0a\u4f20\u66f4\u6e05\u6670\u7684");
            return;
        }
        request.setResponseResult(dest);
    }

    public static void doUploadOcrImage(HttpRequest request) throws Exception {
        request.addValidate((Validate)new IsNotEmpty("data", "\u8bf7\u9009\u62e9\u56fe\u7247"));
        request.addValidate((Validate)new IsNotEmpty("suffix", "\u6269\u5c55\u540d\u4e0d\u80fd\u4e3a\u7a7a"));
        if (!request.chkValidate()) {
            request.setResponseError(request.getAlertMsg());
            return;
        }
        String data = request.getParameter("data");
        String suffix = request.getParameter("suffix");
        int idx = data.indexOf(",");
        byte[] bytes = Base64.decode((String)data.substring(idx + 1));
        String curDate = DateTimes.getDateTime8String();
        String filePath = String.valueOf(MediaPathDao.getTempLocalPre(curDate)) + Ids.longId13() + "." + suffix;
        boolean isSuccess = Files.write((String)filePath, (byte[])bytes);
        if (!isSuccess) {
            request.setResponseError("\u56fe\u7247\u4fdd\u5b58\u5931\u8d25\uff0c\u8bf7\u91cd\u65b0\u4e0a\u4f20");
            return;
        }
        List<String> dataList = BaiduDao.generalOcr(filePath);
        if (dataList.isEmpty()) {
            request.setResponseError("\u672a\u8bc6\u522b\u5230\u6709\u6548\u6587\u5b57");
            return;
        }
        request.setResponseResult(Lists.toString(dataList, (String)"\r\n"));
    }

    public static void checkImage(HttpRequest request) throws Exception {
        request.addValidate((Validate)new IsNotEmpty("fileId", "\u56fe\u7247ID\u4e0d\u80fd\u4e3a\u7a7a"));
        if (!request.chkValidate()) {
            request.setResponseError(request.getAlertMsg());
            return;
        }
        String fileId = request.getParameter("fileId");
        UpllFile file = (UpllFile)((ZTable)ORM.get(ZTable.class)).item(UpllFile.class, new Selector("fileId", (Object)fileId).addReplace("id", null));
        if (file == null) {
            request.setResponseError("\u4e0a\u4f20\u7684\u56fe\u7247\u4e0d\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u4e0a\u4f20");
            return;
        }
        try {
            SanselanUtil.checkImageInfo(file.getFilePath());
        }
        catch (Exception e) {
            Files.deleteFile((String)file.getFilePath());
            ((ZTable)ORM.get(ZTable.class)).delete(UpllFile.class, new Selector("fileId", (Object)fileId).addReplace("id", null));
            request.setResponseError(e.getMessage());
        }
    }

    public static void getMediaEffectData(HttpRequest request) throws Exception {
        long mediaId = request.getParameterLong("mediaId");
        if (mediaId < 0L) {
            request.setResponseError("\u672a\u77e5\u6a21\u677f\u53f7");
            return;
        }
        String fileName = "imp_" + Ids.longId() + ".jpg";
        String rootDir = MediaPathDao.getCanvasLocalPathPre(mediaId);
        String uploadPath = MediaPathDao.getCanvasMidPath(mediaId);
        String imgPath = String.valueOf(MediaPathDao.getCanvasLocalPre(mediaId)) + fileName;
        String mediaUrl = String.valueOf(MediaPathDao.getCanvasUrlPre(mediaId)) + fileName;
        HashMap<String, String> dataMap = new HashMap<String, String>();
        dataMap.put("fileName", fileName);
        dataMap.put("rootDir", rootDir);
        dataMap.put("uploadPath", uploadPath);
        dataMap.put("imgPath", imgPath);
        dataMap.put("mediaUrl", mediaUrl);
        request.setResponseResult(Jsons.toString(dataMap));
    }

    public static void updateMediaEffectData(HttpRequest request) throws Exception {
        long mediaId = request.getParameterLong("mediaId");
        if (mediaId < 0L) {
            request.setResponseError("\u672a\u77e5\u6a21\u677f\u53f7");
            return;
        }
        String mediaUrl = request.getParameter("mediaUrl");
        if (Validates.isEmpty((String)mediaUrl)) {
            request.setResponseError("\u7f29\u7565\u56fe\u5730\u5740\u6709\u8bef");
            return;
        }
        Updater updater = new Updater();
        updater.addMust("mediaId", (Object)mediaId);
        updater.addField("mediaUrl", (Object)mediaUrl);
        ((ZTable)ORM.get(ZTable.class)).update(MediaCanvas.class, updater);
    }
}

