/*
 * Decompiled with CFR 0.152.
 */
package com.zhiqim.media.manage.presenter;

import com.zhiqim.media.dbo.MaterialSvg;
import com.zhiqim.media.service.dao.MediaPathDao;
import com.zhiqim.media.service.util.SvgUtil;
import org.zhiqim.httpd.HttpRequest;
import org.zhiqim.httpd.context.annotation.AnIntercept;
import org.zhiqim.kernel.annotation.AnAlias;
import org.zhiqim.kernel.logging.Log;
import org.zhiqim.kernel.logging.LogFactory;
import org.zhiqim.kernel.util.Ids;
import org.zhiqim.orm.ORM;
import org.zhiqim.orm.ZTable;
import org.zhiqim.orm.dbo.Selector;

@AnAlias(value={"MediaGetPresenter"})
@AnIntercept(value={"chkFmrLogin"})
public class MediaGetPresenter {
    private static Log log = LogFactory.getLog(MediaGetPresenter.class);

    public static void doGetSvgCode(HttpRequest request) throws Exception {
        String svgCode = request.getParameterNoFilter("svgCode");
        String typeCode = request.getParameter("typeCode");
        String catCode = request.getParameter("catCode");
        String keywords = request.getParameter("keywords");
        try {
            Selector sel = new Selector();
            int svgSeq = ((ZTable)ORM.get(ZTable.class)).count(MaterialSvg.class, sel) + 1;
            long svgId = Ids.longId();
            String thumbnailName = String.valueOf(svgId) + "_thumbnail.png";
            String thumbnailPath = String.valueOf(MediaPathDao.getSysMaterialLocalPre(String.valueOf(catCode) + "/thumbnail")) + thumbnailName;
            String fileUrl = String.valueOf(MediaPathDao.getSysMaterialUrlPre(String.valueOf(catCode) + "/thumbnail")) + thumbnailName;
            try {
                SvgUtil.svg2Png(svgCode, thumbnailPath, 150, 0);
            }
            catch (Exception e) {
                log.error((Object)"\u975e\u6587\u5b57\u7d20\u6750\u8bf7\u8f93\u5165\u6b63\u786e\u683c\u5f0f\u7684SVG\u5185\u5bb9", (Throwable)e, new Object[0]);
                request.setResponseError("\u975e\u6587\u5b57\u7d20\u6750\u8bf7\u8f93\u5165\u6b63\u786e\u683c\u5f0f\u7684SVG\u5185\u5bb9");
                return;
            }
            MaterialSvg svg = new MaterialSvg();
            svg.setCatCode(catCode);
            svg.setSvgId(svgId);
            svg.setTypeCode(typeCode);
            svg.setIsEdit(0);
            svg.setKeywords(keywords);
            svg.setIsUpload(0);
            svg.setSvgStatus(0);
            svg.setSvgCode(svgCode);
            svg.setSvgSeq(svgSeq);
            svg.setSvgThumbnail(fileUrl);
            ((ZTable)ORM.get(ZTable.class)).insert((Object)svg);
            log.info((Object)("\u6570\u636e\u63d2\u5165\u6210\u529f\uff1a" + svgSeq));
        }
        catch (Exception e) {
            log.error((Object)"SVG\u5185\u5bb9\u4fdd\u5b58\u5f02\u5e38", (Throwable)e, new Object[0]);
            request.setResponseError("SVG\u5185\u5bb9\u4fdd\u5b58\u5f02\u5e38");
        }
    }
}

