/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.manager.dao;

import java.util.ArrayList;
import java.util.List;
import org.zhiqim.httpd.HttpRequest;
import org.zhiqim.kernel.annotation.AnAlias;
import org.zhiqim.kernel.util.Arrays;
import org.zhiqim.kernel.util.Validates;
import org.zhiqim.manager.ZmrBootstrap;
import org.zhiqim.manager.ZmrSessionUser;
import org.zhiqim.manager.dao.ZmrOperatorDao;
import org.zhiqim.manager.dbo.ZmrMenu;
import org.zhiqim.manager.dbo.ZmrOrg;
import org.zhiqim.manager.dbo.ZmrOrgRule;
import org.zhiqim.orm.dbo.Selector;

@AnAlias(value={"ZmrOrgDao"})
public class ZmrOrgDao {
    public static List<ZmrOrg> list(HttpRequest request) throws Exception {
        return ZmrBootstrap.tableOpr(request).list(ZmrOrg.class, new Selector().addOrderbyAsc("orgLevel,orgSeq,orgId"));
    }

    public static List<ZmrOrg> listForStatus(HttpRequest request) throws Exception {
        return ZmrBootstrap.tableOpr(request).list(ZmrOrg.class, ((Selector)new Selector().addMust("orgStatus", (Object)0)).addOrderbyAsc("orgLevel,orgSeq,orgId"));
    }

    public static List<ZmrOrg> getOrgList(HttpRequest request, String operatorCode) throws Exception {
        ZmrSessionUser sessionUser = (ZmrSessionUser)request.getSessionUser(ZmrSessionUser.class);
        long orgId = sessionUser.getOperatorOrgId();
        ZmrOrg org = (ZmrOrg)ZmrBootstrap.tableOpr(request).item(ZmrOrg.class, new Selector("orgId", (Object)orgId));
        ArrayList<ZmrOrg> list = new ArrayList();
        if (org.getOrgLevel() == 0) {
            list = ZmrOrgDao.list(request);
        }
        if (org.getOrgLevel() == 1) {
            list.add(org);
        }
        return list;
    }

    public static List<ZmrOrg> levelList(HttpRequest request, int orgLevel) throws Exception {
        return ZmrBootstrap.tableOpr(request).list(ZmrOrg.class, ((Selector)new Selector().addMust("orgLevel", (Object)orgLevel)).addOrderbyAsc("orgSeq,orgId"));
    }

    public static long getOrgRootId(HttpRequest request) throws Exception {
        return ((ZmrOrg)ZmrBootstrap.tableOpr(request).item(ZmrOrg.class, new Selector("orgLevel", (Object)0))).getOrgId();
    }

    public static String getOrgName(HttpRequest request, long orgId) throws Exception {
        ZmrOrg org = (ZmrOrg)ZmrBootstrap.tableOpr(request).item(ZmrOrg.class, new Object[]{orgId});
        return Validates.isEmpty((Object)org) ? "" : org.getOrgName();
    }

    public static boolean isOrgManager(HttpRequest request, String operatorCode) throws Exception {
        return !ZmrBootstrap.tableOpr(request).list(ZmrOrg.class, new Selector("orgId", "orgManager", (Object)operatorCode)).isEmpty();
    }

    public static void setTopOrgRule(HttpRequest request, long orgId) throws Exception {
        List menuList = ZmrBootstrap.table(request).list(ZmrMenu.class, new Selector());
        List orgRuleList = ZmrBootstrap.table(request).list(ZmrOrgRule.class, new Selector("orgId", (Object)orgId));
        String allMenu = "";
        for (ZmrMenu menu : menuList) {
            allMenu = String.valueOf(allMenu) + menu.getMenuCode() + ",";
        }
        String orgMenu = "";
        for (ZmrOrgRule rule : orgRuleList) {
            orgMenu = String.valueOf(orgMenu) + rule.getMenuCode() + ",";
        }
        if (!allMenu.equals(orgMenu)) {
            ZmrBootstrap.table(request).delete(ZmrOrgRule.class, new Selector("orgId", (Object)orgId));
            ArrayList<ZmrOrgRule> newRuleList = new ArrayList<ZmrOrgRule>();
            for (ZmrMenu menu : menuList) {
                ZmrOrgRule rule = new ZmrOrgRule();
                rule.setOrgId(orgId);
                rule.setMenuCode(menu.getMenuCode());
                newRuleList.add(rule);
            }
            ZmrBootstrap.table(request).insertBatch(newRuleList);
            ZmrOperatorDao.refresh(request);
        }
    }

    public static List<ZmrMenu> getMenuList(HttpRequest request, long orgId) throws Exception {
        ZmrOrg org = (ZmrOrg)ZmrBootstrap.tableOpr(request).item(ZmrOrg.class, new Object[]{orgId});
        if (org != null && org.getOrgLevel() == 0) {
            ZmrOrgDao.setTopOrgRule(request, orgId);
        }
        List orgRuleList = ZmrBootstrap.table(request).list(ZmrOrgRule.class, new Selector("orgId", (Object)orgId));
        String codeS = "";
        for (ZmrOrgRule rule : orgRuleList) {
            codeS = Validates.isEmptyBlank((String)codeS) ? rule.getMenuCode() : String.valueOf(codeS) + "," + rule.getMenuCode();
        }
        List menuList = ZmrBootstrap.table(request).list(ZmrMenu.class, (Selector)((Selector)new Selector().addMustIn("menuCode", Arrays.toStringArray((String)codeS))).addMust("menuStatus", (Object)0));
        return menuList;
    }

    public static ZmrOrg getOrg(HttpRequest request, long orgId) throws Exception {
        return (ZmrOrg)ZmrBootstrap.tableOpr(request).item(ZmrOrg.class, new Object[]{orgId});
    }
}

