/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.manager.action;

import java.util.ArrayList;
import org.zhiqim.httpd.HttpRequest;
import org.zhiqim.httpd.context.extend.StdSwitchAction;
import org.zhiqim.httpd.validate.Validate;
import org.zhiqim.httpd.validate.ones.IsIntegerValue;
import org.zhiqim.httpd.validate.ones.IsLen;
import org.zhiqim.httpd.validate.onex.IsInteger;
import org.zhiqim.kernel.tree.Tree;
import org.zhiqim.kernel.util.Lists;
import org.zhiqim.kernel.util.Validates;
import org.zhiqim.manager.ZmrBootstrap;
import org.zhiqim.manager.ZmrConstants;
import org.zhiqim.manager.ZmrSessionUser;
import org.zhiqim.manager.dao.ZmrDeptDao;
import org.zhiqim.manager.dbo.ZmrDept;
import org.zhiqim.manager.dbo.ZmrOperator;
import org.zhiqim.orm.dbo.Selector;

public class DeptAction
extends StdSwitchAction
implements ZmrConstants {
    protected void validateId(HttpRequest request) {
        request.addValidate((Validate)new IsInteger("deptId", "\u8bf7\u9009\u62e9\u4e00\u4e2a\u9009\u9879"));
    }

    protected void validateForm(HttpRequest request) {
        request.addValidate((Validate)new IsInteger("deptId", "\u8bf7\u9009\u62e9\u4e00\u4e2a\u9009\u9879"));
        request.addValidate((Validate)new IsLen("deptName", "\u90e8\u95e8\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u4e14\u4e0d\u80fd\u8d85\u8fc732\u4e2a\u6c49\u5b57", 1, 32));
        request.addValidate((Validate)new IsIntegerValue("deptSeq", "\u90e8\u95e8\u6392\u5e8f\u5fc5\u987b\u662f[0, 999999]\u8303\u56f4\u7684\u975e\u8d1f\u6574\u6570", 0, 999999));
        request.addValidate((Validate)new IsLen("deptDesc", "\u90e8\u95e8\u63cf\u8ff0\u53ef\u4e3a\u7a7a\u6216\u4e0d\u80fd\u8d85\u8fc7100\u4e2a\u6c49\u5b57", 0, 100));
    }

    protected void list(HttpRequest request) throws Exception {
        ZmrSessionUser sessionUser = (ZmrSessionUser)request.getSessionUser(ZmrSessionUser.class);
        long orgId = sessionUser.getSelectedOrgId();
        Tree<ZmrDept> tree = ZmrDeptDao.getOrgDeptTree(request, orgId);
        request.setAttribute("tree", tree);
        request.setAttribute("size", (Object)tree.size());
    }

    protected void add(HttpRequest request) throws Exception {
        long deptId = request.getParameterLong("deptId");
        if (deptId == -1L) {
            request.returnHistory("\u4e0a\u7ea7\u90e8\u95e8\u4e0d\u5b58\u5728\uff0c\u8bf7\u9009\u62e9\u6b63\u786e\u7684\u90e8\u95e8");
            return;
        }
        ZmrDept parent = (ZmrDept)ZmrBootstrap.table(request).item(ZmrDept.class, new Object[]{deptId});
        if (parent == null) {
            request.returnHistory("\u4e0a\u7ea7\u90e8\u95e8\u4e0d\u5b58\u5728\uff0c\u8bf7\u9009\u62e9\u6b63\u786e\u7684\u90e8\u95e8");
            return;
        }
        request.setAttribute("parent", (Object)parent);
    }

    protected void modify(HttpRequest request) throws Exception {
        long deptId = request.getParameterLong("deptId");
        ZmrDept item = (ZmrDept)ZmrBootstrap.table(request).item(ZmrDept.class, new Object[]{deptId});
        if (item == null) {
            request.returnHistory("\u90e8\u95e8\u4e0d\u5b58\u5728\uff0c\u8bf7\u9009\u62e9\u6b63\u786e\u7684\u90e8\u95e8");
            return;
        }
        request.setAttribute("item", (Object)item);
    }

    protected void insert(HttpRequest request) throws Exception {
        ZmrDept item = (ZmrDept)request.getParameter(ZmrDept.class);
        ZmrDept parent = (ZmrDept)ZmrBootstrap.table(request).item(ZmrDept.class, new Object[]{item.getParentId()});
        if (parent == null || parent.getDeptStatus() != 0) {
            request.returnHistory("\u4e0a\u7ea7\u90e8\u95e8\u4e0d\u5b58\u5728\u6216\u505c\u7528\uff0c\u8bf7\u9009\u62e9\u6b63\u786e\u7684\u90e8\u95e8");
            return;
        }
        item.setDeptLevel(parent.getDeptLevel() + 1);
        if (parent.getDeptLevel() == 0) {
            item.setDeptParentAll("" + parent.getDeptId());
        } else {
            item.setDeptParentAll(String.valueOf(parent.getDeptParentAll()) + "," + parent.getDeptId());
        }
        ZmrBootstrap.table(request).insert((Object)item);
        ArrayList<String> operatorCodeList = new ArrayList<String>();
        if (Validates.isNotEmptyBlank((String)item.getDeptManager())) {
            operatorCodeList.add(item.getDeptManager());
        }
        if (Validates.isNotEmptyBlank((String)item.getDeptSubManager())) {
            operatorCodeList.addAll(Lists.toStringList((String)item.getDeptSubManager()));
        }
        ZmrDeptDao.doUpdateDeptManeger(request, operatorCodeList, String.valueOf(item.getDeptId()), item.getDeptParentAll());
    }

    protected void update(HttpRequest request) throws Exception {
        ZmrDept item = (ZmrDept)request.getParameter(ZmrDept.class);
        ZmrBootstrap.table(request).update((Object)item);
        ArrayList<String> operatorCodeList = new ArrayList<String>();
        if (Validates.isNotEmptyBlank((String)item.getDeptManager())) {
            operatorCodeList.add(item.getDeptManager());
        }
        if (Validates.isNotEmptyBlank((String)item.getDeptSubManager())) {
            operatorCodeList.addAll(Lists.toStringList((String)item.getDeptSubManager()));
        }
        ZmrDeptDao.doUpdateDeptManeger(request, operatorCodeList, String.valueOf(item.getDeptId()), item.getDeptParentAll());
    }

    protected void delete(HttpRequest request) throws Exception {
        long deptId = request.getParameterLong("deptId");
        ZmrDept item = (ZmrDept)ZmrBootstrap.table(request).item(ZmrDept.class, new Object[]{deptId});
        if (item == null) {
            request.returnHistory("\u90e8\u95e8\u4e0d\u5b58\u5728\uff0c\u8bf7\u9009\u62e9\u6b63\u786e\u7684\u90e8\u95e8");
            return;
        }
        if (item.getDeptLevel() == 0) {
            request.returnHistory("\u9876\u7ea7\u90e8\u95e8\u4e0d\u80fd\u5220\u9664\uff0c\u53ea\u5141\u8bb8\u4fee\u6539");
            return;
        }
        if (ZmrBootstrap.table(request).count(ZmrDept.class, new Selector("parentId", (Object)deptId)) > 0) {
            request.returnHistory("\u8be5\u90e8\u95e8\u6709\u4e0b\u7ea7\u90e8\u95e8\uff0c\u8981\u5148\u5220\u9664\u4e0b\u7ea7\u90e8\u95e8\u624d\u80fd\u5220\u9664\u672c\u90e8\u95e8");
            return;
        }
        if (ZmrBootstrap.tableOpr(request).count(ZmrOperator.class, (Selector)new Selector().addMustLike("operatorDept", (Object)deptId)) > 0) {
            request.returnHistory("\u8be5\u90e8\u95e8\u5df2\u6709\u64cd\u4f5c\u5458\uff0c\u8bf7\u5220\u9664\u90e8\u95e8\u6210\u5458\u540e\u518d\u5220\u9664\u672c\u90e8\u95e8");
            return;
        }
        ZmrBootstrap.table(request).delete(ZmrDept.class, new Object[]{deptId});
    }
}

