/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.manager;

import com.aliyuncs.AcsRequest;
import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.dysmsapi.model.v20170525.SendSmsRequest;
import com.aliyuncs.dysmsapi.model.v20170525.SendSmsResponse;
import com.aliyuncs.profile.DefaultProfile;
import com.aliyuncs.profile.IClientProfile;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.regex.Pattern;
import org.zhiqim.httpd.HttpRequest;
import org.zhiqim.kernel.Global;
import org.zhiqim.kernel.logging.Log;
import org.zhiqim.kernel.logging.LogFactory;
import org.zhiqim.kernel.util.Validates;

public class SmsUtils {
    private static final Log log = LogFactory.getLog(SmsUtils.class);
    public static final String product = "Dysmsapi";
    public static final String domain = "dysmsapi.aliyuncs.com";
    public static final String accessKeyId = Global.getString((String)"aliyun.sms", (String)"accessKeyId");
    public static final String accessKeySecret = Global.getString((String)"aliyun.sms", (String)"accessKeySecret");

    public static void sendSmsCode(HttpRequest request, String mobile, String templateCode) throws Exception {
        boolean isMatch;
        if (Validates.isEmpty((String)mobile)) {
            return;
        }
        if (Validates.isNotEmpty((String)mobile) && !(isMatch = Pattern.matches("^0?(13|14|15|16|17|18|19)[0-9]{9}$", mobile))) {
            return;
        }
        if (Validates.isEmpty((String)templateCode)) {
            templateCode = "SMS_174195343";
        }
        int smsCode = 123456;
        if (SmsUtils.isProdSystem(request)) {
            smsCode = (int)((Math.random() * 9.0 + 1.0) * 100000.0);
        }
        SmsUtils.doSendSms(mobile, smsCode, templateCode);
        request.setSessionAttribute("_smscode_", (Object)smsCode);
    }

    private static void doSendSms(String mobile, int smsCode, String templateCode) throws Exception {
        if (Validates.isEmpty((String)templateCode)) {
            templateCode = "SMS_174195343";
        }
        System.setProperty("sun.net.client.defaultConnectTimeout", "10000");
        System.setProperty("sun.net.client.defaultReadTimeout", "10000");
        DefaultProfile profile = DefaultProfile.getProfile((String)"cn-hangzhou", (String)accessKeyId, (String)accessKeySecret);
        DefaultProfile.addEndpoint((String)"cn-hangzhou", (String)"cn-hangzhou", (String)product, (String)domain);
        DefaultAcsClient acsClient = new DefaultAcsClient((IClientProfile)profile);
        SendSmsRequest request = new SendSmsRequest();
        request.setPhoneNumbers(mobile);
        request.setSignName("\u79d2\u7ed8\u79d1\u6280");
        request.setTemplateCode(templateCode);
        request.setTemplateParam("{\"code\":\"" + smsCode + "\"}");
        SendSmsResponse sendSmsResponse = (SendSmsResponse)acsClient.getAcsResponse((AcsRequest)request);
        if (sendSmsResponse.getCode() == null || !sendSmsResponse.getCode().equals("OK")) {
            log.error((Object)("\u624b\u673a\u53f7\u3010" + mobile + "\u3011\u53d1\u9001\u77ed\u4fe1\u9a8c\u8bc1\u7801\u3010" + smsCode + "\u3011\u5931\u8d25\uff0c" + sendSmsResponse.getMessage()));
        }
    }

    private static boolean isProdSystem(HttpRequest request) {
        try {
            URI uri = new URI(request.getRequestURL().toString());
            if (!(uri.getHost().startsWith("localhost") || uri.getHost().startsWith("127") || uri.getHost().startsWith("192"))) {
                return true;
            }
        }
        catch (URISyntaxException e) {
            log.error((Object)e.getMessage(), (Throwable)e, new Object[0]);
        }
        return false;
    }
}

