/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.httpd.nio;

import java.nio.ByteBuffer;
import org.zhiqim.httpd.HttpContext;
import org.zhiqim.httpd.HttpInputStream;
import org.zhiqim.httpd.HttpWebsocketConnection;
import org.zhiqim.httpd.HttpWebsocketConnectionAbs;
import org.zhiqim.httpd.HttpWebsocketMessage;
import org.zhiqim.httpd.HttpWebsocketMessageAsync;
import org.zhiqim.httpd.nio.HttpNioConnection;
import org.zhiqim.httpd.nio.HttpNioSslBuffer;
import org.zhiqim.httpd.nio.HttpNioSslConnection;

public class HttpNioWebsocketConnection
extends HttpWebsocketConnectionAbs {
    private HttpNioConnection conn;
    private HttpInputStream input;
    private HttpWebsocketMessageAsync data;
    private boolean hasSsl;
    private HttpNioSslBuffer buffer;

    public HttpNioWebsocketConnection(HttpNioConnection conn, HttpContext context, String protocol, String sessionId) {
        super(context, protocol, sessionId);
        this.conn = conn;
        this.input = new HttpInputStream();
        if (conn instanceof HttpNioSslConnection) {
            HttpNioSslConnection sslconn = (HttpNioSslConnection)conn;
            this.hasSsl = true;
            this.buffer = new HttpNioSslBuffer(sslconn.getSSLEngine());
        }
    }

    @Override
    public HttpNioConnection getConnection() {
        return this.conn;
    }

    @Override
    public synchronized void open() {
        if (this.isRunning) {
            return;
        }
        this.isRunning = true;
    }

    @Override
    public synchronized void close() {
        if (!this.isRunning) {
            return;
        }
        this.isRunning = false;
        if (this.conn != null) {
            this.conn.close();
            this.conn = null;
        }
        super.close();
    }

    @Override
    public synchronized void exception(Throwable e) {
        if (!this.isRunning) {
            return;
        }
        this.isRunning = false;
        if (this.conn != null) {
            this.conn.close();
            this.conn = null;
        }
        super.exception(e);
    }

    public int execute(ByteBuffer buf) {
        int result = this.buffer(buf);
        if (result <= 0) {
            return result;
        }
        if (this.data == null || this.data.isParsed()) {
            this.data = new HttpWebsocketMessageAsync();
        }
        boolean readNext = this.parse();
        while (readNext && this.input.available() > 0) {
            this.data = new HttpWebsocketMessageAsync();
            readNext = this.parse();
        }
        return 1;
    }

    private int buffer(ByteBuffer buf) {
        int result = 1;
        if (this.hasSsl) {
            result = this.buffer.parseBuffer(buf, this.input);
        } else {
            this.input.addBuffer(buf);
        }
        return result;
    }

    private boolean parse() {
        block11: {
            block10: {
                block9: {
                    block8: {
                        try {
                            if (this.data.parse(this.input)) break block8;
                            return false;
                        }
                        catch (Throwable e) {
                            this.exception(e);
                            return false;
                        }
                    }
                    if (!this.data.isPong()) break block9;
                    return true;
                }
                if (!this.data.isPing()) break block10;
                HttpWebsocketMessage message = new HttpWebsocketMessage().buildPong();
                this.send(message.toBytes());
                return true;
            }
            if (!this.data.isClose()) break block11;
            this.close();
            return false;
        }
        if (this.data.isText()) {
            this.context.getSessionManager().updateLastAccessed(this.sessionId);
            if (this.websocket != null) {
                this.websocket.onMessage((HttpWebsocketConnection)this, this.data.getText());
            }
            return true;
        }
        return true;
    }
}

