/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.httpd.entities;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.zhiqim.httpd.HttpContext;
import org.zhiqim.httpd.HttpEntity;
import org.zhiqim.httpd.HttpHeader;
import org.zhiqim.httpd.HttpSender;
import org.zhiqim.httpd.constants.HttpMimeType;
import org.zhiqim.kernel.util.DateTimes;
import org.zhiqim.kernel.util.Files;
import org.zhiqim.kernel.util.Streams;
import org.zhiqim.kernel.util.Urls;

public class FileResourceEntity
implements HttpEntity {
    @Override
    public boolean isMatch(String pathInContext) {
        return true;
    }

    @Override
    public void handle(HttpHeader header, HttpSender sender) throws IOException {
        File file;
        HttpContext context = header.getContext();
        String filePath = header.getPathOnResource();
        if (filePath == null) {
            filePath = String.valueOf(context.getResourcePath()) + header.getPathInContext();
            filePath = Urls.decode((String)filePath, (String)header.getCharacterEncoding());
        }
        if (!(file = new File(filePath)).exists() || !file.isFile()) {
            context.getNotFoundHandler().handle(header, sender);
            return;
        }
        if (file.isHidden() || !file.canRead()) {
            sender.sendError(403);
            return;
        }
        String fileExt = Files.getFileExt((String)filePath);
        String mimeType = header.getMimeType();
        if (mimeType == null) {
            mimeType = HttpMimeType.getResourceMimeType(fileExt);
        }
        if ("text/html".equals(mimeType)) {
            sender.setContentType("text/html; charset=" + header.getCharacterEncoding());
        } else {
            sender.setContentType(mimeType);
        }
        long lastModified = file.lastModified();
        String lastModifiedTime = DateTimes.getDateTimeHttp((long)lastModified);
        String ifModifiedSince = header.getHeader("If-Modified-Since");
        if (ifModifiedSince != null && ifModifiedSince.indexOf(lastModifiedTime) != -1) {
            sender.setHeader("Cache-Control", "max-age=" + context.getExpires());
            sender.sendError(304);
            return;
        }
        sender.setHeader("Accept-Ranges", "bytes");
        sender.setHeader("Last-Modified", lastModifiedTime);
        if (header.isMethodResponseContent()) {
            sender.setHeader("Cache-Control", "max-age=" + context.getExpires());
            sender.setHeader("Content-Length", file.length());
            Throwable throwable = null;
            Object var13_13 = null;
            try (FileInputStream fis = new FileInputStream(file);){
                Streams.putBytes((InputStream)fis, (OutputStream)sender.getOutputStream());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        sender.commit();
    }
}

