/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.httpd.context.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.zhiqim.httpd.context.ZmlConfig;
import org.zhiqim.httpd.context.ZmlContextConstants;
import org.zhiqim.httpd.context.config.ZAction;
import org.zhiqim.httpd.context.config.ZActionMap;
import org.zhiqim.httpd.context.config.ZActionPackage;
import org.zhiqim.httpd.context.config.ZAttribute;
import org.zhiqim.httpd.context.config.ZCResolver;
import org.zhiqim.httpd.context.config.ZComponent;
import org.zhiqim.httpd.context.config.ZInterceptor;
import org.zhiqim.httpd.context.core.Context;
import org.zhiqim.kernel.constants.XmlConstants;
import org.zhiqim.kernel.extend.LinkedMapSV;
import org.zhiqim.kernel.util.Asserts;
import org.zhiqim.kernel.util.Lists;
import org.zhiqim.kernel.util.Resources;
import org.zhiqim.kernel.util.Strings;
import org.zhiqim.kernel.util.Validates;
import org.zhiqim.kernel.xml.Xmls;

public class ZConfig
implements ZmlContextConstants,
XmlConstants {
    private final ZmlConfig zmlConfig;
    private final boolean isRootConfig;
    private final String resourceType;
    private final String resourcePath;
    private final String name;
    private final String path;
    private final List<ZComponent> componentList;
    private final List<ZConfig> configList;
    private final LinkedMapSV<ZAttribute> attributeMap;
    private final List<ZInterceptor> interceptorList;
    private final ZActionMap actionMap;

    public ZConfig(ZmlConfig zmlConfig, boolean isRootConfig, String resourceType, String resourcePath, String name, String path) {
        this.zmlConfig = zmlConfig;
        this.isRootConfig = isRootConfig;
        this.resourcePath = Strings.removeEndsWith((String)resourcePath, (String)"/");
        this.resourceType = resourceType;
        this.name = name;
        this.path = Strings.addStartsWith((String)path, (String)"/");
        this.componentList = new ArrayList<ZComponent>();
        this.configList = new ArrayList<ZConfig>();
        this.attributeMap = new LinkedMapSV();
        this.interceptorList = new ArrayList<ZInterceptor>();
        this.actionMap = new ZActionMap(zmlConfig, this);
    }

    public Context getContext() {
        return this.zmlConfig.getContext();
    }

    public String getName() {
        return this.name;
    }

    public String getPath() {
        return this.path;
    }

    public String toConfigString() {
        return "<config" + " name=" + '\"' + this.name + '\"' + " path=" + '\"' + this.path + '\"' + " />";
    }

    public String toString() {
        StringBuilder strb = new StringBuilder();
        strb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>").append("\r\n");
        strb.append("<!DOCTYPE ZHIQIM-CONTEXT PUBLIC \"-//ZHIQIM //DTD Zhiqim-Context Configuration 1.5.0//EN\" \"http://zhiqim.org/xmldtds/zhiqim_context_1_5_0.dtd\">").append("\r\n");
        strb.append("<zhiqim-context>").append("\r\n").append("\r\n");
        for (ZComponent component : this.componentList) {
            strb.append("    ").append(component.toString()).append("\r\n");
        }
        strb.append("\r\n");
        for (ZConfig context : this.configList) {
            strb.append("    ").append(context.toConfigString()).append("\r\n");
        }
        strb.append("\r\n");
        for (ZAttribute attribute : this.attributeMap.values()) {
            strb.append("    ").append(attribute.toString()).append("\r\n");
        }
        strb.append("\r\n");
        for (ZInterceptor interceptor : this.interceptorList) {
            strb.append("    ").append(interceptor.toString()).append("\r\n");
        }
        strb.append("\r\n");
        strb.append(this.actionMap.toString());
        strb.append("\r\n");
        strb.append("</zhiqim-context>");
        return strb.toString();
    }

    public void load() throws Exception {
        InputStream in = this.getInputStream();
        Document document = null;
        try {
            document = Xmls.buildDocument((InputStream)in, (EntityResolver)new ZCResolver(String.valueOf(this.resourcePath) + this.path));
        }
        catch (Exception e) {
            throw Asserts.exception((String)"\u52a0\u8f7d[%s%s]\u65f6\u5f02\u5e38", (Exception)e, (Object[])new Object[]{this.resourcePath, this.path});
        }
        NodeList componentList = document.getElementsByTagName("component");
        int i = 0;
        while (i < componentList.getLength()) {
            Node node = componentList.item(i);
            if (node.getNodeType() == 1) {
                String name = Xmls.getAttribute((Node)node, (String)"name");
                String path = Xmls.getAttribute((Node)node, (String)"path");
                this.addComponent(name, path);
            }
            ++i;
        }
        NodeList contextList = document.getElementsByTagName("config");
        int i2 = 0;
        while (i2 < contextList.getLength()) {
            Node node = contextList.item(i2);
            if (node.getNodeType() == 1) {
                String name = Xmls.getAttribute((Node)node, (String)"name");
                String path = Xmls.getAttribute((Node)node, (String)"path");
                this.addConfig(name, path);
            }
            ++i2;
        }
        NodeList attributeList = document.getElementsByTagName("attribute");
        int i3 = 0;
        while (i3 < attributeList.getLength()) {
            Node node = attributeList.item(i3);
            if (node.getNodeType() == 1) {
                String name = Xmls.getAttribute((Node)node, (String)"name");
                String key = Xmls.getAttribute((Node)node, (String)"key");
                String value = Xmls.getAttribute((Node)node, (String)"value");
                this.addAttrute(name, key, value);
            }
            ++i3;
        }
        NodeList interceptorList = document.getElementsByTagName("interceptor");
        int i4 = 0;
        while (i4 < interceptorList.getLength()) {
            Node node = interceptorList.item(i4);
            if (node.getNodeType() == 1) {
                String name = Xmls.getAttribute((Node)node, (String)"name");
                String key = Xmls.getAttribute((Node)node, (String)"key");
                String clazz = Xmls.getAttribute((Node)node, (String)"class");
                this.addInterceptor(name, key, clazz);
            }
            ++i4;
        }
        NodeList actionList = document.getElementsByTagName("action");
        int i5 = 0;
        while (i5 < actionList.getLength()) {
            Node node = actionList.item(i5);
            if (node.getNodeType() == 1) {
                NamedNodeMap namedNodeMap = node.getAttributes();
                String name = Xmls.getAttribute((NamedNodeMap)namedNodeMap, (String)"name");
                String path = Xmls.getAttribute((NamedNodeMap)namedNodeMap, (String)"path");
                String interceptor = Xmls.getAttribute((NamedNodeMap)namedNodeMap, (String)"interceptor");
                String forward = Xmls.getAttribute((NamedNodeMap)namedNodeMap, (String)"forward");
                String redirect = Xmls.getAttribute((NamedNodeMap)namedNodeMap, (String)"redirect");
                String view = Xmls.getAttribute((NamedNodeMap)namedNodeMap, (String)"view");
                String include = Xmls.getAttribute((NamedNodeMap)namedNodeMap, (String)"include");
                String clazz = Xmls.getAttribute((NamedNodeMap)namedNodeMap, (String)"class");
                String method = Xmls.getAttribute((NamedNodeMap)namedNodeMap, (String)"method");
                String success = Xmls.getAttribute((NamedNodeMap)namedNodeMap, (String)"success");
                String tips = Xmls.getAttribute((NamedNodeMap)namedNodeMap, (String)"tips");
                this.addAction(name, path, interceptor, forward, redirect, view, include, clazz, method, success, tips);
            }
            ++i5;
        }
        in.close();
        Lists.trim(this.configList);
        for (ZConfig conf : this.configList) {
            conf.load();
        }
    }

    private InputStream getInputStream() throws FileNotFoundException {
        String filePath = String.valueOf(this.resourcePath) + this.path;
        if ("classpath".equals(this.resourceType)) {
            if (!Resources.exists(ZConfig.class, (String)filePath)) {
                throw new FileNotFoundException(String.valueOf(filePath) + " \u4e0d\u5b58\u5728!");
            }
            return Resources.getResourceStream(ZConfig.class, (String)filePath);
        }
        File file = new File(filePath);
        if (!file.exists()) {
            throw new FileNotFoundException(String.valueOf(filePath) + " \u4e0d\u5b58\u5728!");
        }
        return new FileInputStream(file);
    }

    private void addConfig(String name, String path) {
        Asserts.as((String)(Validates.isNotEmptyBlank((String)path) ? null : "\u4e0a\u4e0b\u6587\u73af\u5883\u914d\u7f6e[%s], path\u4e0d\u80fd\u4e3a\u7a7a"), (Object[])new Object[]{name});
        for (ZConfig config : this.configList) {
            Asserts.as((String)(!config.getPath().equals(path) ? null : "\u6709\u76f8\u540c\u7684\u4e0a\u4e0b\u6587\u73af\u5883\u914d\u7f6e[%s],path[%s]"), (Object[])new Object[]{name, path});
        }
        this.configList.add(new ZConfig(this.zmlConfig, this.isRootConfig, this.resourceType, this.resourcePath, name, path));
    }

    private void addComponent(String name, String path) {
        Asserts.as(Validates.isNotEmptyBlank((String)path) ? null : "\u7ec4\u4ef6\u914d\u7f6e[" + name + "], path\u4e0d\u80fd\u4e3a\u7a7a");
        ZComponent component = new ZComponent();
        component.setName(name);
        component.setPath(Strings.removeEndsWith((String)path, (String)"/"));
        this.componentList.add(component);
    }

    private void addAttrute(String name, String key, String value) {
        Asserts.as((String)(Validates.isNotEmptyBlank((String)key) ? null : "\u5c5e\u6027\u914d\u7f6e[%s], key\u4e0d\u80fd\u4e3a\u7a7a"), (Object[])new Object[]{name});
        ZAttribute attribute = new ZAttribute();
        attribute.setName(name);
        attribute.setKey(key);
        attribute.setValue(value);
        this.attributeMap.put(key, (Object)attribute);
    }

    private void addInterceptor(String name, String key, String clazz) {
        Asserts.as((String)(Validates.isNotEmptyBlank((String)key) ? null : "\u62e6\u622a\u5668\u914d\u7f6e[%s], key\u4e0d\u80fd\u4e3a\u7a7a"), (Object[])new Object[]{name});
        Asserts.as((String)(Validates.isNotEmptyBlank((String)clazz) ? null : "\u62e6\u622a\u5668\u914d\u7f6e[%s], class\u4e0d\u80fd\u4e3a\u7a7a"), (Object[])new Object[]{name});
        ZInterceptor interceptor = new ZInterceptor();
        interceptor.setName(name);
        interceptor.setKey(key);
        interceptor.setClazz(clazz);
        this.interceptorList.add(interceptor);
    }

    private void addAction(String name, String path, String interceptor, String forward, String redirect, String view, String include, String clazz, String method, String success, String tips) {
        Asserts.as((String)(Validates.isNotEmptyBlank((String)path) ? null : "action\u914d\u7f6e[%s], path\u4e0d\u80fd\u4e3a\u7a7a"), (Object[])new Object[]{name});
        ZAction action = new ZAction();
        action.setName(name);
        action.setPath(path);
        action.setInterceptor(interceptor);
        action.setForward(forward);
        action.setRedirect(redirect);
        action.setView(view);
        action.setInclude(include);
        action.setClazz(clazz);
        action.setMethod(method);
        action.setSuccess(success);
        action.setTips(tips);
        this.actionMap.addAction(action);
    }

    public List<ZComponent> getComponentList() {
        return this.componentList;
    }

    public List<ZConfig> getConfigList() {
        return this.configList;
    }

    public Collection<ZAttribute> getAttributeList() {
        return this.attributeMap.values();
    }

    public List<ZInterceptor> getInterceptorList() {
        return this.interceptorList;
    }

    public Collection<ZAction> getExactActionList() {
        return this.actionMap.getExactActionList();
    }

    public Collection<ZAction> getFuzzyActionList() {
        return this.actionMap.getFuzzyActionList();
    }

    public void chkActionVariable() {
        this.actionMap.chkVariable();
    }

    public ZAction getInTurnAction(String path) {
        ZAction action = this.actionMap.getExactAction(path);
        if (action != null) {
            return action;
        }
        action = this.actionMap.getFuzzyAction(path);
        if (action != null) {
            return action;
        }
        int i = this.configList.size() - 1;
        while (i >= 0) {
            ZConfig context = this.configList.get(i);
            action = context.getInTurnAction(path);
            if (action != null) {
                return action;
            }
            --i;
        }
        return null;
    }

    public ZAction getExactAction(String path) {
        ZAction action = this.actionMap.getExactAction(path);
        if (action != null) {
            return action;
        }
        int i = this.configList.size() - 1;
        while (i >= 0) {
            ZConfig context = this.configList.get(i);
            action = context.getExactAction(path);
            if (action != null) {
                return action;
            }
            --i;
        }
        return null;
    }

    public ZAction getFuzzyAction(String path) {
        ZAction action = this.actionMap.getFuzzyAction(path);
        if (action != null) {
            return action;
        }
        int i = this.configList.size() - 1;
        while (i >= 0) {
            ZConfig context = this.configList.get(i);
            action = context.getFuzzyAction(path);
            if (action != null) {
                return action;
            }
            --i;
        }
        return null;
    }

    public ZAction getInTurnActionByClass(String clazz) {
        ZAction action = this.actionMap.getExactActionByClass(clazz);
        if (action != null) {
            return action;
        }
        action = this.actionMap.getFuzzyActionByClass(clazz);
        if (action != null) {
            return action;
        }
        int i = this.configList.size() - 1;
        while (i >= 0) {
            ZConfig context = this.configList.get(i);
            action = context.getInTurnActionByClass(clazz);
            if (action != null) {
                return action;
            }
            --i;
        }
        return null;
    }

    public ZAction getExactActionByClass(String clazz) {
        ZAction action = this.actionMap.getExactActionByClass(clazz);
        if (action != null) {
            return action;
        }
        int i = this.configList.size() - 1;
        while (i >= 0) {
            ZConfig context = this.configList.get(i);
            action = context.getExactActionByClass(clazz);
            if (action != null) {
                return action;
            }
            --i;
        }
        return null;
    }

    public ZAction getFuzzyActionByClass(String clazz) {
        ZAction action = this.actionMap.getFuzzyActionByClass(clazz);
        if (action != null) {
            return action;
        }
        int i = this.configList.size() - 1;
        while (i >= 0) {
            ZConfig context = this.configList.get(i);
            action = context.getFuzzyActionByClass(clazz);
            if (action != null) {
                return action;
            }
            --i;
        }
        return null;
    }

    public String getWebsocketClass() {
        ZAttribute attribute = (ZAttribute)this.attributeMap.get("websocket");
        if (attribute != null) {
            return attribute.getValue();
        }
        int i = this.configList.size() - 1;
        while (i >= 0) {
            ZConfig context = this.configList.get(i);
            attribute = (ZAttribute)context.attributeMap.get("websocket");
            if (attribute != null) {
                return attribute.getValue();
            }
            --i;
        }
        return null;
    }

    public String getBootstrapClass() {
        ZAttribute attribute = (ZAttribute)this.attributeMap.get("bootstrap");
        if (attribute != null) {
            return attribute.getValue();
        }
        int i = this.configList.size() - 1;
        while (i >= 0) {
            ZConfig context = this.configList.get(i);
            attribute = (ZAttribute)context.attributeMap.get("bootstrap");
            if (attribute != null) {
                return attribute.getValue();
            }
            --i;
        }
        return null;
    }

    public ZActionPackage getActionPackage(ZmlConfig zmlConfig) {
        ZAttribute attribute = (ZAttribute)this.attributeMap.get("actionPackage");
        if (attribute != null) {
            return new ZActionPackage(zmlConfig, this, attribute.getValue());
        }
        int i = this.configList.size() - 1;
        while (i >= 0) {
            ZConfig context = this.configList.get(i);
            attribute = (ZAttribute)context.attributeMap.get("actionPackage");
            if (attribute != null) {
                return new ZActionPackage(zmlConfig, this, attribute.getValue());
            }
            --i;
        }
        return null;
    }
}

