/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.httpd.context;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.zhiqim.httpd.HttpContext;
import org.zhiqim.httpd.HttpRequest;
import org.zhiqim.httpd.context.ZmlConfig;
import org.zhiqim.httpd.context.ZmlContextConstants;
import org.zhiqim.httpd.context.core.Context;
import org.zhiqim.kernel.annotation.AnAlias;
import org.zhiqim.kernel.extend.HashMapSO;
import org.zhiqim.kernel.extend.MapS;
import org.zhiqim.kernel.extend.MapSO;
import org.zhiqim.kernel.logging.Log;
import org.zhiqim.kernel.logging.LogFactory;
import org.zhiqim.kernel.util.Htmls;
import org.zhiqim.zml.Zml;
import org.zhiqim.zml.ZmlEngine;
import org.zhiqim.zml.Zmls;

@AnAlias(value={"ZmlContexts"})
public class ZmlContexts
implements ZmlContextConstants {
    private static final Log log = LogFactory.getLog(ZmlContexts.class);

    public static ZmlEngine getZmlEngine(HttpContext context) {
        return ((Context)context).getZmlEngine();
    }

    public static ZmlEngine getZmlEngine(HttpRequest request) {
        return ZmlContexts.getZmlEngine(request.getContext());
    }

    public static Zml getZml(HttpContext context, String zmlPath) throws IOException {
        ZmlEngine engine = ZmlContexts.getZmlEngine(context);
        if (engine == null) {
            return null;
        }
        return engine.getZml(zmlPath);
    }

    public static Zml getZml(HttpRequest request, String zmlPath) throws IOException {
        ZmlEngine engine = ZmlContexts.getZmlEngine(request);
        if (engine == null) {
            return null;
        }
        return engine.getZml(zmlPath);
    }

    public static String parseZmlPath(HttpRequest request, String zmlPath) throws Exception {
        ZmlEngine engine = ZmlContexts.getZmlEngine(request);
        if (engine == null) {
            return null;
        }
        Zml zml = engine.getZml(zmlPath);
        return ZmlContexts.parseZml(request, zml);
    }

    public static String parseZmlPath(HttpRequest request, String zmlPath, String key, Object value) throws Exception {
        return ZmlContexts.parseZmlPath(request, zmlPath, (MapSO)new HashMapSO(key, value));
    }

    public static String parseZmlPath(HttpRequest request, String zmlPath, MapSO variableMap) throws Exception {
        ZmlEngine engine = ZmlContexts.getZmlEngine(request);
        if (engine == null) {
            return null;
        }
        Zml zml = engine.getZml(zmlPath);
        return ZmlContexts.parseZml(request, zml, variableMap);
    }

    public static String parseZmlContent(HttpRequest request, String content) throws Exception {
        ZmlEngine engine = ZmlContexts.getZmlEngine(request);
        Zml zml = new Zml(engine, content);
        return ZmlContexts.parseZml(request, zml);
    }

    public static String parseZmlContent(HttpRequest request, String content, String key, Object value) throws Exception {
        ZmlEngine engine = ZmlContexts.getZmlEngine(request);
        Zml zml = new Zml(engine, content);
        return ZmlContexts.parseZml(request, zml, (MapSO)new HashMapSO(key, value));
    }

    public static String parseZmlContent(HttpRequest request, String content, MapSO variableMap) throws Exception {
        ZmlEngine engine = ZmlContexts.getZmlEngine(request);
        Zml zml = new Zml(engine, content);
        return ZmlContexts.parseZml(request, zml, variableMap);
    }

    public static String parseZml(HttpRequest request, Zml zml) throws Exception {
        return ZmlContexts.parseZml(request, zml, null);
    }

    public static String parseZml(HttpRequest request, Zml zml, String key, Object value) throws Exception {
        return ZmlContexts.parseZml(request, zml, (MapSO)new HashMapSO(key, value));
    }

    public static String parseZml(HttpRequest request, Zml zml, MapSO variableMap) throws Exception {
        HashMapSO pageVariableMap = new HashMapSO();
        HashMap<String, String> paramMap = request.getParameterMap();
        if (!paramMap.isEmpty()) {
            for (Map.Entry<String, String> entry : paramMap.entrySet()) {
                String key = entry.getKey();
                String value = Htmls.filterAll((String)entry.getValue());
                pageVariableMap.put(key, (Object)value);
            }
        }
        pageVariableMap.putAll(request.getAttributeMap());
        if (variableMap != null) {
            pageVariableMap.putAll(variableMap);
        }
        if (request.getSession() != null) {
            pageVariableMap.put("sessionId", (Object)request.getSessionId());
            pageVariableMap.put("sessionUser", (Object)request.getSessionUser());
            pageVariableMap.put("sessionName", (Object)request.getSessionName());
        }
        pageVariableMap.put("request", (Object)request);
        pageVariableMap.put("response", (Object)request.getResponse());
        pageVariableMap.put("session", (Object)request.getSession());
        pageVariableMap.put("context", (Object)request.getContext());
        pageVariableMap.put("log", (Object)log);
        Context context = (Context)request.getContext();
        ZmlConfig config = context.getConfig();
        return Zmls.parse((Zml)zml, (MapSO)pageVariableMap, (MapS[])new MapS[]{config});
    }

    public static String parseZmlContent(HttpContext context, String content) throws Exception {
        ZmlEngine engine = ZmlContexts.getZmlEngine(context);
        Zml zml = new Zml(engine, content);
        return ZmlContexts.parseZml(context, zml, null);
    }

    public static String parseZmlContent(HttpContext context, String content, String key, Object value) throws Exception {
        ZmlEngine engine = ZmlContexts.getZmlEngine(context);
        Zml zml = new Zml(engine, content);
        return ZmlContexts.parseZml(context, zml, (MapSO)new HashMapSO(key, value));
    }

    public static String parseZmlContent(HttpContext context, String content, MapSO variableMap) throws Exception {
        ZmlEngine engine = ZmlContexts.getZmlEngine(context);
        Zml zml = new Zml(engine, content);
        return ZmlContexts.parseZml(context, zml, variableMap);
    }

    public static String parseZml(HttpContext context, Zml zml, MapSO variableMap) throws Exception {
        HashMapSO pageVariableMap = new HashMapSO();
        if (variableMap != null) {
            pageVariableMap.putAll(variableMap);
        }
        ZmlConfig config = ((Context)context).getConfig();
        return Zmls.parse((Zml)zml, (MapSO)pageVariableMap, (MapS[])new MapS[]{config});
    }
}

