/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.httpd.bio;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.zhiqim.httpd.HttpRequestAbs;
import org.zhiqim.httpd.bio.HttpBioHeader;
import org.zhiqim.kernel.util.Streams;
import org.zhiqim.kernel.util.Urls;
import org.zhiqim.kernel.util.Zips;

public class HttpBioRequest
extends HttpRequestAbs {
    public HttpBioRequest(HttpBioHeader header) {
        super(header);
    }

    @Override
    public boolean parseContent() throws IOException {
        int cLen = this.getContentLength();
        if (cLen <= 0) {
            this.bis = new ByteArrayInputStream(new byte[0]);
            return true;
        }
        byte[] contentBytes = Streams.getBytes((InputStream)this.input, (int)cLen);
        this.bis = new ByteArrayInputStream(contentBytes, 0, cLen);
        if (this.isRequestGZip()) {
            this.bis = Zips.unGZip((InputStream)this.bis);
        }
        if ("POST".equals(this.header.getMethod()) && "application/x-www-form-urlencoded".equals(this.header.getMimeType())) {
            String line = new String(contentBytes, this.header.getCharacterEncoding());
            Urls.toMap((String)line, (Map)this.cntParamMap.instance(), (String)this.header.getCharacterEncoding());
        }
        return true;
    }
}

