/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.httpd;

import java.io.IOException;
import java.nio.charset.Charset;
import org.zhiqim.httpd.HttpConnection;
import org.zhiqim.httpd.HttpExecutor;
import org.zhiqim.httpd.HttpRequest;
import org.zhiqim.httpd.HttpRequestAbs;
import org.zhiqim.httpd.HttpResponse;
import org.zhiqim.httpd.HttpSession;
import org.zhiqim.kernel.util.codes.Base64;
import org.zhiqim.kernel.util.codes.SHA1;

public class HttpWebsocketService
implements HttpExecutor {
    @Override
    public boolean isMatch(String pathInContext) {
        return "/service/ws".equals(pathInContext);
    }

    @Override
    public void handle(HttpRequest request, HttpResponse response) throws IOException {
        if (!request.isWebSocket()) {
            response.sendError(403);
            return;
        }
        HttpSession session = request.getSession();
        if (session == null) {
            response.sendError(403);
            return;
        }
        response.setStatus(101);
        response.setHeader("Connection", "Upgrade");
        response.setHeader("Upgrade", "WebSocket");
        String key = request.getHeader("Sec-WebSocket-Key");
        String accept = Base64.encode((byte[])SHA1.encodeByte((String)(String.valueOf(key) + "258EAFA5-E914-47DA-95CA-C5AB0DC85B11"), (Charset)_UTF_8_C_));
        response.setHeader("Sec-WebSocket-Accept", accept);
        String protocol = request.getHeader("Sec-WebSocket-Protocol", null);
        if (protocol != null) {
            response.setHeader("Sec-WebSocket-Protocol", protocol);
        }
        HttpConnection conn = ((HttpRequestAbs)request).getConnection();
        conn.doWebsocket(request.getContext(), protocol, session.getId());
    }
}

