/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.httpd;

import java.lang.reflect.Method;
import org.zhiqim.httpd.HttpContext;
import org.zhiqim.httpd.HttpSession;
import org.zhiqim.kernel.Global;
import org.zhiqim.kernel.extend.HashMapSO;
import org.zhiqim.kernel.util.Asserts;
import org.zhiqim.kernel.util.Classes;
import org.zhiqim.kernel.util.Ints;
import org.zhiqim.kernel.util.Longs;
import org.zhiqim.kernel.util.Strings;
import org.zhiqim.kernel.util.Types;

public abstract class HttpSessionUser {
    protected transient HttpSession session;
    protected String className;
    protected String sessionName;
    protected HashMapSO valueMap = new HashMapSO();

    public HttpSessionUser() {
        this.className = this.getClass().getName();
    }

    public abstract String getSessionName();

    public void setSession(HttpSession session) {
        this.session = session;
        this.sessionName = this.getSessionName();
    }

    public HttpSession getSession() {
        return this.session;
    }

    public HttpContext getContext() {
        return this.session.getContext();
    }

    public String getSessionId() {
        return this.session.getId();
    }

    public boolean isNew() {
        return this.session.isNew();
    }

    public String getSessionIp() {
        return this.session.getSessionIp();
    }

    public String getUserAgent() {
        return this.session.getUserAgent();
    }

    public long getCreated() {
        return this.session.getCreated();
    }

    public String getCreateTime() {
        return this.session.getCreateTime();
    }

    public long getLastAccessed() {
        return this.session.getLastAccessed();
    }

    public String getLastAccessTime() {
        return this.session.getLastAccessTime();
    }

    public long getRemainSecond() {
        return this.session.getRemainSecond();
    }

    public long getRemainMinute() {
        return this.session.getRemainMinute();
    }

    public long[] getRemainTime() {
        return this.session.getRemainTime();
    }

    public String getRemainTimeDesc() {
        return this.session.getRemainTimeDesc();
    }

    public HashMapSO getAttributes() {
        return this.session.getAttributes();
    }

    public Object getAttribute(String name) {
        return this.session.getAttribute(name);
    }

    public Object removeAttribute(String name) {
        return this.session.removeAttribute(name);
    }

    public void setAttribute(String name, Object value) {
        this.session.setAttribute(name, value);
    }

    public boolean hasAttribute(String name) {
        return this.session.hasAttribute(name);
    }

    public HashMapSO getValues() {
        return this.valueMap;
    }

    public Object getValue(String key) {
        return this.valueMap.get(key);
    }

    public boolean hasValue(String key) {
        return this.valueMap.containsKey(key);
    }

    public Object removeValue(String key) {
        return this.valueMap.remove(key);
    }

    public void setValue(String key, Object value) {
        this.valueMap.put(key, value);
    }

    public void setValueTrue(String key) {
        this.valueMap.put(key, (Object)true);
    }

    public void setValueFalse(String key) {
        this.valueMap.put(key, (Object)false);
    }

    public String getValueString(String key) {
        return this.getValueString(key, null);
    }

    public String getValueString(String key, String defaultValue) {
        Object value = this.getValue(key);
        return value == null ? defaultValue : Strings.trim((String)String.valueOf(value));
    }

    public int getValueInt(String key) {
        return this.getValueInt(key, -1);
    }

    public int getValueInt(String key, int defaultValue) {
        return Ints.toInt((Object)this.valueMap.get(key), (int)defaultValue);
    }

    public long getValueLong(String key) {
        return this.getValueLong(key, -1L);
    }

    public long getValueLong(String key, long defaultValue) {
        return Longs.toLong((Object)this.valueMap.get(key), (long)defaultValue);
    }

    public boolean getValueBoolean(String key, boolean defaultValue) {
        Object value = this.valueMap.get(key);
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            return Boolean.parseBoolean((String)value);
        }
        return defaultValue;
    }

    public boolean isValue(String key, String className, String staticMethodName) {
        if (this.hasValue(key)) {
            Object value = this.getValue(key);
            return Types.isBoolean((Object)value) ? (Boolean)value : false;
        }
        Class clazz = Global.forName((String)className);
        Asserts.as((String)(clazz != null ? null : "\u5224\u65ad\u4f1a\u8bdd\u5c5e\u6027\u503c\u65f6\uff0c\u4f20\u5165\u7684\u7c7b\u540d\u6216\u7c7b\u522b\u540d\u4e0d\u6b63\u786e"));
        Method method = Classes.getMethodDeep((Class)clazz, (String)staticMethodName, (Class[])new Class[]{this.getClass()});
        Asserts.as((String)(method != null ? null : "\u5224\u65ad\u4f1a\u8bdd\u5c5e\u6027\u503c\u65f6\uff0c\u4f20\u5165\u7684\u9759\u6001\u65b9\u6cd5\u540d\u672a\u627e\u5230"));
        Asserts.as((String)(Classes.isStaticMethod((Method)method) ? null : "\u5224\u65ad\u4f1a\u8bdd\u5c5e\u6027\u503c\u65f6\uff0c\u4f20\u5165\u7684\u65b9\u6cd5\u540d\u4e0d\u662f\u9759\u6001\u65b9\u6cd5"));
        try {
            Object value = method.invoke(null, this);
            Asserts.as((String)(Types.isBoolean((Object)value) ? null : "\u5224\u65ad\u4f1a\u8bdd\u5c5e\u6027\u503c\u65f6\uff0c\u65b9\u6cd5\u8fd4\u56de\u7684\u503c\u4e0d\u662fboolean\u578b"));
            return (Boolean)value;
        }
        catch (Exception exception) {
            return false;
        }
    }
}

