/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.httpd;

import java.util.ArrayList;
import java.util.List;
import org.zhiqim.httpd.HttpContext;
import org.zhiqim.httpd.HttpListener;
import org.zhiqim.httpd.HttpdConstants;
import org.zhiqim.httpd.bio.HttpBioListener;
import org.zhiqim.httpd.bio.HttpBioSslListener;
import org.zhiqim.httpd.nio.HttpNioListener;
import org.zhiqim.httpd.nio.HttpNioSslListener;
import org.zhiqim.kernel.Global;
import org.zhiqim.kernel.Servicer;
import org.zhiqim.kernel.config.Group;
import org.zhiqim.kernel.extend.HashSetS;
import org.zhiqim.kernel.logging.Log;
import org.zhiqim.kernel.logging.LogFactory;
import org.zhiqim.kernel.util.Arrays;
import org.zhiqim.kernel.util.Asserts;
import org.zhiqim.kernel.util.Classes;
import org.zhiqim.kernel.util.Validates;

public class HttpServer
extends Servicer
implements HttpdConstants {
    private static final Log log = LogFactory.getLog(HttpServer.class);
    private boolean isRunning;
    private HttpListener listener;
    private final List<HttpContext> contextList = new ArrayList<HttpContext>();

    public boolean isRunning() {
        return this.isRunning;
    }

    public boolean create() throws Exception {
        String[] contextArr;
        Group group = Global.getGroup((String)this.id);
        Asserts.as((String)(group != null ? null : "HTTP\u670d\u52a1[%s]\u672a\u627e\u5230\u6574\u4e2a\u914d\u7f6e\u7ec4"), (Object[])new Object[]{this.id});
        log.info((Object)"\u521d\u59cb\u5316[HTTP\u670d\u52a1:%s]\u5f00\u59cb...", new Object[]{this.id});
        String contexts = group.getString("context");
        Asserts.as(Validates.isNotEmptyBlank((String)contexts) ? null : "HTTP\u670d\u52a1[" + this.id + "]\u672a\u627e\u5230[context]\u914d\u7f6e\u9879");
        String scheme = group.getString("scheme", "http");
        String io = group.getString("io", "BIO");
        this.listener = "https".equalsIgnoreCase(scheme) ? ("NIO".equalsIgnoreCase(io) ? new HttpNioSslListener(this) : new HttpBioSslListener(this)) : ("NIO".equalsIgnoreCase(io) ? new HttpNioListener(this) : new HttpBioListener(this));
        this.listener.setGroup(group);
        this.listener.open();
        String[] stringArray = contextArr = Arrays.toStringArray((String)contexts);
        int n = contextArr.length;
        int n2 = 0;
        while (n2 < n) {
            String contextId = stringArray[n2];
            Group cGroup = Global.getGroup((String)contextId);
            Asserts.as(cGroup != null ? null : "HTTP\u670d\u52a1[" + this.id + "]\u672a\u627e\u5230context[" + contextId + "]\u914d\u7f6e\u9879");
            String contextClass = cGroup.getString("class", "org.zhiqim.httpd.context.ZmlContext");
            Object obj = Classes.newInstance((String)contextClass);
            Asserts.as(obj instanceof HttpContext ? null : "HTTP\u670d\u52a1[" + this.id + "]context[" + contextId + "]\u7684[class]\u914d\u7f6e\u9879\u672a\u5b9e\u73b0HttpContext\u63a5\u53e3");
            HttpContext context = (HttpContext)obj;
            context.setServer(this);
            if (!context.create(cGroup)) {
                return false;
            }
            this.contextList.add(context);
            ++n2;
        }
        this.isRunning = true;
        log.info((Object)("\u521d\u59cb\u5316[HTTP\u670d\u52a1:%s]" + this.listener.toString() + "\u5b8c\u6210!!!%s"), new Object[]{this.id, "\r\n"});
        return true;
    }

    public void destroy() throws Exception {
        this.isRunning = false;
        if (this.listener != null) {
            this.listener.close();
            this.listener = null;
        }
        for (HttpContext context : this.contextList) {
            if (!context.isRunning()) continue;
            context.destroy();
        }
    }

    public void setRunning() {
        this.isRunning = true;
    }

    public void addContext(HttpContext context) {
        context.setServer(this);
        this.chkContextDomainPath(context.getContextDomains(), context.getContextPath());
        this.contextList.add(context);
    }

    public void removeContext(HttpContext context) {
        try {
            context.destroy();
            this.contextList.remove(context);
        }
        catch (Exception e) {
            log.error((Object)"\u79fb\u9664\u4e0a\u4e0b\u6587\u73af\u5883\u65f6\u5f02\u5e38", (Throwable)e, new Object[0]);
        }
    }

    public void removeContext(String contextId) {
        HttpContext context = this.getContext(contextId);
        if (context == null) {
            return;
        }
        this.removeContext(context);
    }

    public void chkContextDomainPath(HashSetS domains, String path) {
        if (domains.isEmpty()) {
            for (HttpContext ctx : this.contextList) {
                if (!ctx.getContextDomains().isEmpty() || !ctx.getContextPath().equals(path)) continue;
                throw Asserts.exception((String)"\u5b58\u5728\u76f8\u540c\u7684\u4e0a\u4e0b\u6587\u73af\u5883\u914d\u7f6e[%s]", (Object[])new Object[]{ctx.getContextPath()});
            }
        } else {
            for (HttpContext ctx : this.contextList) {
                HashSetS ds = ctx.getContextDomains();
                if (ds.isEmpty() || !ctx.getContextPath().equals(path)) continue;
                for (String d : domains.instance()) {
                    if (!ds.contains((Object)d)) continue;
                    throw Asserts.exception((String)"\u5b58\u5728\u76f8\u540c\u7684\u4e0a\u4e0b\u6587\u73af\u5883\u914d\u7f6e[%s][%s]", (Object[])new Object[]{d, ctx.getContextPath()});
                }
            }
        }
    }

    public HttpListener getListener() {
        return this.listener;
    }

    public List<HttpContext> getContextList() {
        return this.contextList;
    }

    public HttpContext getContext(String contextId) {
        Asserts.as((String)(contextId != null ? null : "\u4e0a\u4e0b\u6587\u73af\u5883\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a"));
        for (HttpContext context : this.contextList) {
            if (!contextId.equals(context.getId())) continue;
            return context;
        }
        return null;
    }

    public HttpContext getContext(String contextDomain, String contextPath) {
        Asserts.as((String)(contextPath != null ? null : "\u4e0a\u4e0b\u6587\u73af\u5883\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a"));
        if (!Validates.isEmptyBlank((String)contextDomain)) {
            for (HttpContext context : this.contextList) {
                HashSetS domains = context.getContextDomains();
                if (domains.isEmpty() || !domains.contains((Object)contextDomain) || !contextPath.equals(context.getContextPath())) continue;
                return context;
            }
        }
        for (HttpContext context : this.contextList) {
            if (!context.getContextDomains().isEmpty() || !contextPath.equals(context.getContextPath())) continue;
            return context;
        }
        return null;
    }

    public int getPort() {
        return this.listener.getPort();
    }

    public String getScheme() {
        return this.listener.getScheme();
    }
}

