/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.httpd;

import java.util.ArrayList;
import java.util.List;
import org.zhiqim.httpd.HttpHeaderInner;
import org.zhiqim.httpd.HttpRequest;
import org.zhiqim.httpd.util.Scripts;
import org.zhiqim.httpd.validate.OneValidate;
import org.zhiqim.httpd.validate.TwoValidate;
import org.zhiqim.httpd.validate.Validate;
import org.zhiqim.kernel.extend.HashMapSS;
import org.zhiqim.kernel.util.Validates;

public abstract class HttpRequestValidate
extends HttpHeaderInner
implements HttpRequest {
    private String confirm = null;
    private boolean isGray = true;
    private List<Validate> validateList;

    @Override
    public void setValidateConfirm(String confirm) {
        this.confirm = confirm;
    }

    @Override
    public void setValidateGray(boolean isGray) {
        this.isGray = isGray;
    }

    @Override
    public List<Validate> getValidateList() {
        return this.validateList == null ? new ArrayList() : this.validateList;
    }

    @Override
    public void addValidate(Validate validate) {
        if (this.validateList == null) {
            this.validateList = new ArrayList<Validate>(5);
        }
        this.validateList.add(validate);
    }

    @Override
    public boolean chkValidate() {
        if (this.validateList == null) {
            return true;
        }
        for (Validate validate : this.validateList) {
            String value2;
            String value1;
            TwoValidate two;
            if (validate instanceof OneValidate) {
                OneValidate one = (OneValidate)validate;
                String value = this.getParameter(one.getField());
                if (one.validate(value)) continue;
                this.setAlertMsg(one.getAlertMsg());
                return false;
            }
            if (!(validate instanceof TwoValidate) || (two = (TwoValidate)validate).validate(value1 = this.getParameter(two.getField()), value2 = this.getParameter(two.getField2()))) continue;
            this.setAlertMsg(two.getAlertMsg());
            return false;
        }
        return true;
    }

    @Override
    public void clearValidate() {
        if (this.validateList != null) {
            this.validateList.clear();
        }
    }

    @Override
    public String getValidateScript() {
        StringBuilder strb = new StringBuilder();
        strb.append(Scripts.head());
        strb.append("function validateForm(form)\r\n{\r\n");
        HashMapSS functionMap = new HashMapSS();
        if (!Validates.isEmpty(this.validateList)) {
            for (Validate validate : this.validateList) {
                strb.append(validate.getScript());
                functionMap.put(validate.getName(), validate.getFunction());
            }
        }
        if (!Validates.isEmpty((String)this.confirm)) {
            strb.append(Scripts.getConfirm(this.confirm));
        }
        if (this.isGray) {
            strb.append(Scripts.getGraySubmit(this.isFirefox()));
        }
        strb.append("    return true;\r\n}\r\n\r\n");
        strb.append(Scripts.setFormButtonGray());
        strb.append(Scripts.setFormButtonResume());
        for (String function : functionMap.values()) {
            strb.append(function);
        }
        if (strb.length() >= 4 && "\r\n\r\n".equals(strb.substring(strb.length() - 4))) {
            strb.setLength(strb.length() - 2);
        }
        strb.append(Scripts.tail());
        return strb.toString();
    }

    @Override
    public String getValidateSubmitScript() {
        StringBuilder strb = new StringBuilder();
        strb.append(Scripts.head());
        strb.append("function submitForm(form)\r\n{\r\n");
        HashMapSS functionMap = new HashMapSS();
        if (!Validates.isEmpty(this.validateList)) {
            for (Validate validate : this.validateList) {
                strb.append(validate.getScript());
                functionMap.put(validate.getName(), validate.getFunction());
            }
        }
        if (Validates.isEmpty((String)this.confirm)) {
            if (this.isGray) {
                strb.append(Scripts.getGraySubmit(this.isFirefox()));
            }
            strb.append("    ").append("form.submit();").append("\r\n");
        } else {
            strb.append("    ").append("Z.confirm(\"").append(this.confirm).append("\", function()").append("\r\n");
            strb.append("    ").append("{").append("\r\n");
            if (this.isGray) {
                if (!this.isFirefox()) {
                    strb.append("    ").append("    ").append("setFormButtonGray(form);").append("\r\n");
                } else {
                    strb.append("    ").append("    ").append("if (Z && Z.onload)").append("\r\n").append("    ").append("    ").append("{//firefox\u8981\u6c42F && Z.onload\u65f6\u624d\u652f\u6301\u63d0\u4ea4\u53d8\u7070\u548c\u56de\u9000\u6062\u590d").append("\r\n").append("\r\n").append("    ").append("    ").append("    ").append("setFormButtonGray(form);").append("\r\n").append("    ").append("    ").append("    ").append("Z.onload(function(form){setFormButtonResume(form);}, form);").append("\r\n").append("    ").append("    ").append("}").append("\r\n").append("\r\n");
                }
            }
            strb.append("    ").append("    ").append("form.submit();").append("\r\n");
            strb.append("    ").append("});").append("\r\n");
        }
        strb.append("}\r\n\r\n");
        strb.append(Scripts.setFormButtonGray());
        strb.append(Scripts.setFormButtonResume());
        for (String function : functionMap.values()) {
            strb.append(function);
        }
        if (strb.length() >= 4 && "\r\n\r\n".equals(strb.substring(strb.length() - 4))) {
            strb.setLength(strb.length() - 2);
        }
        strb.append(Scripts.tail());
        return strb.toString();
    }

    protected void destroy() {
        if (this.validateList != null) {
            this.validateList.clear();
            this.validateList = null;
        }
        this.confirm = null;
    }
}

