/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.kernel.util.codes;

import java.io.UnsupportedEncodingException;
import org.zhiqim.kernel.constants.CodeConstants;
import org.zhiqim.kernel.util.Asserts;
import org.zhiqim.kernel.util.Bytes;
import org.zhiqim.kernel.util.Hexs;

public class MD5Coder
implements CodeConstants {
    private static final byte PAD = -128;
    private static final int[] V = new int[]{1732584193, -271733879, -1732584194, 271733878};
    private static final int[] S = new int[]{7, 12, 17, 22, 5, 9, 14, 20, 4, 11, 16, 23, 6, 10, 15, 21};
    private static final int[] T = new int[]{-680876936, -389564586, 606105819, -1044525330, -176418897, 1200080426, -1473231341, -45705983, 1770035416, -1958414417, -42063, -1990404162, 1804603682, -40341101, -1502002290, 1236535329, -165796510, -1069501632, 643717713, -373897302, -701558691, 38016083, -660478335, -405537848, 568446438, -1019803690, -187363961, 1163531501, -1444681467, -51403784, 1735328473, -1926607734, -378558, -2022574463, 1839030562, -35309556, -1530992060, 1272893353, -155497632, -1094730640, 681279174, -358537222, -722521979, 76029189, -640364487, -421815835, 530742520, -995338651, -198630844, 1126891415, -1416354905, -57434055, 1700485571, -1894986606, -1051523, -2054922799, 1873313359, -30611744, -1560198380, 1309151649, -145523070, -1120210379, 718787259, -343485551};
    private int[] abcd = new int[]{V[0], V[1], V[2], V[3]};

    private byte[] digest(byte[] bytes) {
        int num = (bytes.length + 8) / 64 + 1;
        byte[] buffer = new byte[64 * num];
        Bytes.putBytes(buffer, 0, bytes);
        Bytes.putByte(buffer, bytes.length, (byte)-128);
        Bytes.LU.putLong(buffer, buffer.length - 8, (long)(bytes.length * 8));
        int[] m = new int[16 * num];
        int i = 0;
        while (i < 16 * num) {
            m[i] = Bytes.LU.getInt(buffer, i * 4);
            ++i;
        }
        buffer = null;
        i = 0;
        while (i < num) {
            this.update(MD5Coder.slice(m, i * 16, (i + 1) * 16));
            ++i;
        }
        byte[] result = new byte[16];
        Bytes.LU.putInt(result, 0, this.abcd[0]);
        Bytes.LU.putInt(result, 4, this.abcd[1]);
        Bytes.LU.putInt(result, 8, this.abcd[2]);
        Bytes.LU.putInt(result, 12, this.abcd[3]);
        return result;
    }

    private void update(int[] x) {
        int a = this.abcd[0];
        int b = this.abcd[1];
        int c = this.abcd[2];
        int d = this.abcd[3];
        a = MD5Coder.ff(a, b, c, d, x[0], S[0], T[0]);
        d = MD5Coder.ff(d, a, b, c, x[1], S[1], T[1]);
        c = MD5Coder.ff(c, d, a, b, x[2], S[2], T[2]);
        b = MD5Coder.ff(b, c, d, a, x[3], S[3], T[3]);
        a = MD5Coder.ff(a, b, c, d, x[4], S[0], T[4]);
        d = MD5Coder.ff(d, a, b, c, x[5], S[1], T[5]);
        c = MD5Coder.ff(c, d, a, b, x[6], S[2], T[6]);
        b = MD5Coder.ff(b, c, d, a, x[7], S[3], T[7]);
        a = MD5Coder.ff(a, b, c, d, x[8], S[0], T[8]);
        d = MD5Coder.ff(d, a, b, c, x[9], S[1], T[9]);
        c = MD5Coder.ff(c, d, a, b, x[10], S[2], T[10]);
        b = MD5Coder.ff(b, c, d, a, x[11], S[3], T[11]);
        a = MD5Coder.ff(a, b, c, d, x[12], S[0], T[12]);
        d = MD5Coder.ff(d, a, b, c, x[13], S[1], T[13]);
        c = MD5Coder.ff(c, d, a, b, x[14], S[2], T[14]);
        b = MD5Coder.ff(b, c, d, a, x[15], S[3], T[15]);
        a = MD5Coder.gg(a, b, c, d, x[1], S[4], T[16]);
        d = MD5Coder.gg(d, a, b, c, x[6], S[5], T[17]);
        c = MD5Coder.gg(c, d, a, b, x[11], S[6], T[18]);
        b = MD5Coder.gg(b, c, d, a, x[0], S[7], T[19]);
        a = MD5Coder.gg(a, b, c, d, x[5], S[4], T[20]);
        d = MD5Coder.gg(d, a, b, c, x[10], S[5], T[21]);
        c = MD5Coder.gg(c, d, a, b, x[15], S[6], T[22]);
        b = MD5Coder.gg(b, c, d, a, x[4], S[7], T[23]);
        a = MD5Coder.gg(a, b, c, d, x[9], S[4], T[24]);
        d = MD5Coder.gg(d, a, b, c, x[14], S[5], T[25]);
        c = MD5Coder.gg(c, d, a, b, x[3], S[6], T[26]);
        b = MD5Coder.gg(b, c, d, a, x[8], S[7], T[27]);
        a = MD5Coder.gg(a, b, c, d, x[13], S[4], T[28]);
        d = MD5Coder.gg(d, a, b, c, x[2], S[5], T[29]);
        c = MD5Coder.gg(c, d, a, b, x[7], S[6], T[30]);
        b = MD5Coder.gg(b, c, d, a, x[12], S[7], T[31]);
        a = MD5Coder.hh(a, b, c, d, x[5], S[8], T[32]);
        d = MD5Coder.hh(d, a, b, c, x[8], S[9], T[33]);
        c = MD5Coder.hh(c, d, a, b, x[11], S[10], T[34]);
        b = MD5Coder.hh(b, c, d, a, x[14], S[11], T[35]);
        a = MD5Coder.hh(a, b, c, d, x[1], S[8], T[36]);
        d = MD5Coder.hh(d, a, b, c, x[4], S[9], T[37]);
        c = MD5Coder.hh(c, d, a, b, x[7], S[10], T[38]);
        b = MD5Coder.hh(b, c, d, a, x[10], S[11], T[39]);
        a = MD5Coder.hh(a, b, c, d, x[13], S[8], T[40]);
        d = MD5Coder.hh(d, a, b, c, x[0], S[9], T[41]);
        c = MD5Coder.hh(c, d, a, b, x[3], S[10], T[42]);
        b = MD5Coder.hh(b, c, d, a, x[6], S[11], T[43]);
        a = MD5Coder.hh(a, b, c, d, x[9], S[8], T[44]);
        d = MD5Coder.hh(d, a, b, c, x[12], S[9], T[45]);
        c = MD5Coder.hh(c, d, a, b, x[15], S[10], T[46]);
        b = MD5Coder.hh(b, c, d, a, x[2], S[11], T[47]);
        a = MD5Coder.ii(a, b, c, d, x[0], S[12], T[48]);
        d = MD5Coder.ii(d, a, b, c, x[7], S[13], T[49]);
        c = MD5Coder.ii(c, d, a, b, x[14], S[14], T[50]);
        b = MD5Coder.ii(b, c, d, a, x[5], S[15], T[51]);
        a = MD5Coder.ii(a, b, c, d, x[12], S[12], T[52]);
        d = MD5Coder.ii(d, a, b, c, x[3], S[13], T[53]);
        c = MD5Coder.ii(c, d, a, b, x[10], S[14], T[54]);
        b = MD5Coder.ii(b, c, d, a, x[1], S[15], T[55]);
        a = MD5Coder.ii(a, b, c, d, x[8], S[12], T[56]);
        d = MD5Coder.ii(d, a, b, c, x[15], S[13], T[57]);
        c = MD5Coder.ii(c, d, a, b, x[6], S[14], T[58]);
        b = MD5Coder.ii(b, c, d, a, x[13], S[15], T[59]);
        a = MD5Coder.ii(a, b, c, d, x[4], S[12], T[60]);
        d = MD5Coder.ii(d, a, b, c, x[11], S[13], T[61]);
        c = MD5Coder.ii(c, d, a, b, x[2], S[14], T[62]);
        b = MD5Coder.ii(b, c, d, a, x[9], S[15], T[63]);
        this.abcd[0] = this.abcd[0] + a;
        this.abcd[1] = this.abcd[1] + b;
        this.abcd[2] = this.abcd[2] + c;
        this.abcd[3] = this.abcd[3] + d;
    }

    private static int cc(int q, int a, int b, int c, int d, int x, int s, int t) {
        a += q + x + t;
        a = a << s | a >>> 32 - s;
        return a + b;
    }

    private static int ff(int a, int b, int c, int d, int x, int s, int t) {
        return MD5Coder.cc(MD5Coder.f(b, c, d), a, b, c, d, x, s, t);
    }

    private static int gg(int a, int b, int c, int d, int x, int s, int t) {
        return MD5Coder.cc(MD5Coder.g(b, c, d), a, b, c, d, x, s, t);
    }

    private static int hh(int a, int b, int c, int d, int x, int s, int t) {
        return MD5Coder.cc(MD5Coder.h(b, c, d), a, b, c, d, x, s, t);
    }

    private static int ii(int a, int b, int c, int d, int x, int s, int t) {
        return MD5Coder.cc(MD5Coder.i(b, c, d), a, b, c, d, x, s, t);
    }

    private static int f(int x, int y, int z) {
        return x & y | ~x & z;
    }

    private static int g(int x, int y, int z) {
        return x & z | y & ~z;
    }

    private static int h(int x, int y, int z) {
        return x ^ y ^ z;
    }

    private static int i(int x, int y, int z) {
        return y ^ (x | ~z);
    }

    private static int[] slice(int[] m, int start, int end) {
        int len = end - start;
        int index = 0;
        int[] x = new int[len];
        int i = start;
        while (i < end) {
            x[index++] = m[i];
            ++i;
        }
        return x;
    }

    public static String encodeUTF8(String src) {
        return MD5Coder.encode(src, "UTF-8");
    }

    public static String encode(String src, String encoding) {
        byte[] destBytes = MD5Coder.encodeByte(src, encoding);
        return Hexs.toHexString(destBytes);
    }

    public static String encode(byte[] src) {
        byte[] destBytes = MD5Coder.encodeByte(src);
        return Hexs.toHexString(destBytes);
    }

    public static byte[] encodeByte(String src, String encoding) {
        Asserts.notNull(src, "src");
        Asserts.notNull(encoding, "encoding");
        try {
            return MD5Coder.encodeByte(src.getBytes(encoding));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw Asserts.exception("\u975e\u6cd5\u7684\u7f16\u7801");
        }
    }

    public static byte[] encodeByte(byte[] src) {
        return new MD5Coder().digest(src);
    }
}

