/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.kernel.util;

import org.zhiqim.kernel.annotation.AnAlias;
import org.zhiqim.kernel.constants.CodeConstants;
import org.zhiqim.kernel.constants.EnumConstants;
import org.zhiqim.kernel.enumerated.LetterCase;
import org.zhiqim.kernel.util.Arrays;
import org.zhiqim.kernel.util.Bytes;
import org.zhiqim.kernel.util.Validates;

@AnAlias(value={"Hexs"})
public class Hexs
implements CodeConstants,
EnumConstants {
    public static String toHexStringUTF8(String str) {
        return Hexs.toHexString(str.getBytes(_UTF_8_C_));
    }

    public static String toHexString(byte[] b) {
        return Hexs.toHexString(b, LetterCase.LOWER);
    }

    public static String toHexString(byte[] b, LetterCase letterCase) {
        StringBuilder strb = new StringBuilder();
        int i = 0;
        while (i < b.length) {
            String str = Integer.toString((b[i] & 0xFF) + 256, 16).substring(1);
            strb.append(letterCase.toCase(str, LetterCase.LOWER));
            ++i;
        }
        return strb.toString();
    }

    public static String toHexString(byte[] b, String spe) {
        return Hexs.toHexString(b, spe, LetterCase.LOWER);
    }

    public static String toHexString(byte[] b, String spe, LetterCase letterCase) {
        StringBuilder strb = new StringBuilder();
        int i = 0;
        while (i < b.length) {
            if (i != 0) {
                strb.append(spe);
            }
            String str = Integer.toString((b[i] & 0xFF) + 256, 16).substring(1);
            strb.append(letterCase.toCase(str, LetterCase.LOWER));
            ++i;
        }
        return strb.toString();
    }

    public static String toHexStringX(String s) {
        return Hexs.toHexString(s, "&#x", ";", null);
    }

    public static String toHexStringU(String s) {
        return Hexs.toHexString(s, "\\u", null, null);
    }

    public static String toHexStringUPlus(String s) {
        String u = Hexs.toHexString(s, "U+", null, ",");
        return Arrays.toFilterSameStr(u.split(","), ",");
    }

    public static String toHexString(String s, String prefix, String suffix, String separator) {
        if (Validates.isEmpty(s)) {
            return "";
        }
        StringBuilder strb = new StringBuilder();
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (prefix != null) {
                strb.append(prefix);
            }
            strb.append(Integer.toHexString(c));
            if (suffix != null) {
                strb.append(suffix);
            }
            if (separator != null) {
                strb.append(separator);
            }
            ++i;
        }
        if (s.length() > 0 && separator != null) {
            strb.setLength(strb.length() - separator.length());
        }
        return strb.toString();
    }

    public static byte[] toBytes(String hex) {
        return Hexs.toBytes(hex, " ");
    }

    public static byte[] toBytes(String hex, String spe) {
        hex = hex.replaceAll(spe, "");
        String[] hexArr = new String[hex.length() / 2];
        int i = 0;
        while (i < hexArr.length * 2) {
            hexArr[i / 2] = hex.substring(i, i + 2);
            i += 2;
        }
        byte[] dest = new byte[hexArr.length];
        int i2 = 0;
        while (i2 < hexArr.length) {
            dest[i2] = (byte)Integer.parseInt(hexArr[i2], 16);
            ++i2;
        }
        return dest;
    }

    public static byte[] toBytes(byte[] hexBytes) {
        String hex = new String(Bytes.toCharArray(hexBytes));
        return Hexs.toBytes(hex);
    }

    public static byte[] toBytes(byte[] hexBytes, int off, int len) {
        String hex = new String(Bytes.toCharArray(hexBytes, off, len));
        return Hexs.toBytes(hex);
    }

    public static byte[] toBytes(byte[] hexBytes, String spe) {
        String hex = new String(Bytes.toCharArray(hexBytes));
        return Hexs.toBytes(hex, spe);
    }

    public static byte[] toBytes(byte[] hexBytes, int off, int len, String spe) {
        String hex = new String(Bytes.toCharArray(hexBytes, off, len));
        return Hexs.toBytes(hex, spe);
    }

    public static String byteToHex(byte ib) {
        char[] ob = new char[]{_HEX_CHAR_[ib >>> 4 & 0xF], _HEX_CHAR_[ib & 0xF]};
        String s = new String(ob);
        return s;
    }

    public static String byteToHexLower(byte ib) {
        char[] ob = new char[]{_HEX_CHAR_LOW_[ib >>> 4 & 0xF], _HEX_CHAR_LOW_[ib & 0xF]};
        String s = new String(ob);
        return s;
    }

    public static int hexToByte(char c) {
        if (Character.isDigit(c)) {
            return c - 48;
        }
        if (Character.isLowerCase(c)) {
            return 10 + c - 97;
        }
        return 10 + c - 65;
    }

    public static String toBinString(byte[] b, String spe) {
        if (b == null || b.length == 0) {
            return "";
        }
        StringBuilder strb = new StringBuilder();
        strb.append(Hexs.byteToBin(b[0]));
        int i = 1;
        while (i < b.length) {
            strb.append(spe).append(Hexs.byteToBin(b[i]));
            ++i;
        }
        return strb.toString();
    }

    public static String byteToBin(byte ib) {
        char[] bin = new char[]{_BIN_CHAR_[ib >>> 7 & 1], _BIN_CHAR_[ib >>> 6 & 1], _BIN_CHAR_[ib >>> 5 & 1], _BIN_CHAR_[ib >>> 4 & 1], _BIN_CHAR_[ib >>> 3 & 1], _BIN_CHAR_[ib >>> 2 & 1], _BIN_CHAR_[ib >>> 1 & 1], _BIN_CHAR_[ib & 1]};
        return new String(bin);
    }
}

