/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.kernel.logging;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.zhiqim.kernel.Global;
import org.zhiqim.kernel.Servicer;
import org.zhiqim.kernel.annotation.AnNullable;
import org.zhiqim.kernel.config.Group;
import org.zhiqim.kernel.config.Item;
import org.zhiqim.kernel.extend.HashMapSV;
import org.zhiqim.kernel.logging.Log;
import org.zhiqim.kernel.logging.LogConfig;
import org.zhiqim.kernel.logging.LogFactory;
import org.zhiqim.kernel.logging.LogService;
import org.zhiqim.kernel.logging.Logger;
import org.zhiqim.kernel.logging.logger.ConsoleLogger;
import org.zhiqim.kernel.logging.logger.FileDailyLogger;
import org.zhiqim.kernel.logging.logger.FileLogger;
import org.zhiqim.kernel.util.Arrays;
import org.zhiqim.kernel.util.Strings;
import org.zhiqim.kernel.util.Validates;

public class LogServer
extends Servicer
implements LogService {
    private static final HashMapSV<LogConfig> configMap = new HashMapSV();
    private static final HashMap<Integer, ArrayList<Logger>> rootMap = new HashMap();

    @Override
    public boolean create() throws Exception {
        if (!this.initLogConfig()) {
            return false;
        }
        this.initRootAppender();
        LogFactory.updateLogService(this);
        return true;
    }

    @Override
    public void destroy() throws Exception {
        configMap.clear();
    }

    public Collection<LogConfig> getConfigList() {
        return configMap.values();
    }

    @Override
    public boolean isLoggerEnabled(Log log, int level) {
        List<Logger> loggerList = this.getLoggerList(log, level);
        return loggerList != null && !loggerList.isEmpty();
    }

    @Override
    @AnNullable
    public List<Logger> getLoggerList(Log log, int level) {
        List<Logger> loggerList = this.hasMustName(log, level);
        if (loggerList != null) {
            return loggerList;
        }
        loggerList = this.hasMustClass(log, level);
        if (loggerList != null) {
            return loggerList;
        }
        return rootMap.get(level);
    }

    private boolean initLogConfig() throws Exception {
        if (!Global.hasGroup(this.id)) {
            System.out.println("\u65e5\u5fd7\u914d\u7f6e[" + this.id + "]\u4e0d\u5b58\u5728");
            return false;
        }
        for (Item item : Global.getGroup(this.id).list()) {
            String key = item.getKey();
            if (!Global.hasGroup(key)) {
                System.out.println("\u65e5\u5fd7\u914d\u7f6e[" + key + "]\u4e0d\u5b58\u5728");
                return false;
            }
            String value = item.getString();
            if (Validates.isEmpty(value) || value.indexOf("-") == -1) {
                System.out.println("\u65e5\u5fd7\u914d\u7f6e[" + key + "]\u7684value(\u7ea7\u522b)\u4e0d\u6b63\u786e\uff0c\u683c\u5f0f\u5982debug-info");
                return false;
            }
            String[] levels = Arrays.toStringArray(value, "-");
            int levelMin = LogFactory.getLevel(levels[0]);
            int levelMax = LogFactory.getLevel(levels[1]);
            if (levelMin == 0 || levelMax == 0 || levelMax < levelMin) {
                System.out.println("\u65e5\u5fd7\u914d\u7f6e[" + key + "]\u7ea7\u522b\u914d\u7f6e\u6709\u8bef\uff0c\u6700\u5c0f\u548c\u6700\u5927\u503c\u5fc5\u987b\u5728(debug|info|error|warn|fatal)\u8303\u56f4\u5185\uff0c\u5982error-fatal");
                return false;
            }
            String filePathDefault = "./logs/" + Strings.trimLeft(key, String.valueOf(this.id) + ".") + ".log";
            Group group = Global.getGroup(key);
            LogConfig config = new LogConfig();
            config.setId(key);
            config.setLevelMin(levelMin);
            config.setLevelMax(levelMax);
            config.setConsoleOut(group.isTrue("console.out"));
            config.setConsolePattern(group.getString("console.pattern", "%d [%t] %l - %m%n"));
            config.setFileOut(group.isTrue("file.out"));
            config.setFilePath(group.getString("file.path", filePathDefault));
            config.setFilePattern(group.getString("file.pattern", "%d [%t] %l - %m%n"));
            config.setFileEncoding(group.getString("file.encoding", "UTF-8"));
            config.setFileMaxNum(group.getInt("file.maxNum", 7));
            config.setFileMaxSize(group.getInt("file.maxSize", 100));
            config.setMustName(group.getString("must.name"));
            String mustClass = group.getString("must.class");
            if (Validates.isNotEmptyBlank(mustClass)) {
                Class<?> mustClazz = Global.forName(mustClass);
                config.setMustClass(mustClazz);
            }
            if (config.isConsoleOut()) {
                ConsoleLogger cLogger = new ConsoleLogger(config.getConsolePattern(), levelMin, levelMax);
                config.setConsoleLogger(cLogger);
            }
            if (config.isFileOut()) {
                String loggerClass = group.getString("file.logger");
                FileLogger logger = null;
                if (Validates.isEmpty(loggerClass)) {
                    logger = new FileDailyLogger();
                } else {
                    Class<?> loggerClazz = Global.forName(loggerClass);
                    Object obj = loggerClazz.newInstance();
                    if (!(obj instanceof FileLogger)) {
                        System.out.println("\u65e5\u5fd7\u914d\u7f6e[" + group.getId() + "]file.logger\u672a\u5b9e\u73b0Logger\u63a5\u53e3");
                        return false;
                    }
                    logger = (FileLogger)obj;
                }
                logger.setLevelMin(levelMin);
                logger.setLevelMax(levelMax);
                logger.setFilePattern(config.getFilePattern());
                logger.setFileEncoding(config.getFileEncoding());
                logger.setFileMaxNum(config.getFileMaxNum());
                logger.setFileMaxSize(config.getFileMaxSize());
                logger.setFilePath(config.getFilePath());
                config.setFileLogger(logger);
            }
            configMap.put(group.getId(), config);
        }
        return true;
    }

    private void initRootAppender() {
        ArrayList<LogConfig> rootList = new ArrayList<LogConfig>();
        Collection configList = configMap.values();
        for (LogConfig config : configList) {
            if (!Validates.isEmpty(config.getMustName()) || !Validates.isEmpty(config.getMustClass())) continue;
            rootList.add(config);
        }
        for (LogConfig root : rootList) {
            int min = root.getLevelMin();
            int max = root.getLevelMax();
            int i = min;
            while (i <= max) {
                ArrayList<Logger> loggerList = rootMap.get(i);
                if (loggerList == null) {
                    loggerList = new ArrayList();
                    rootMap.put(i, loggerList);
                }
                if (root.isConsoleOut()) {
                    loggerList.add(root.getConsoleLogger());
                }
                if (root.isFileOut()) {
                    loggerList.add(root.getFileLogger());
                }
                loggerList.trimToSize();
                ++i;
            }
        }
    }

    private List<Logger> hasMustName(Log log, int level) {
        if (Validates.isEmpty(log.getMustName())) {
            return null;
        }
        ArrayList<Logger> loggerList = null;
        for (LogConfig config : configMap.values()) {
            if (Validates.isEmpty(config.getMustName()) || !config.getMustName().equals(log.getMustName())) continue;
            if (loggerList == null) {
                loggerList = new ArrayList<Logger>();
            }
            if (level < config.getLevelMin() || level > config.getLevelMax()) continue;
            if (config.isConsoleOut()) {
                loggerList.add(config.getConsoleLogger());
            }
            if (!config.isFileOut()) continue;
            loggerList.add(config.getFileLogger());
        }
        return loggerList;
    }

    private List<Logger> hasMustClass(Log log, int level) {
        if (log.getMustClass() == null) {
            return null;
        }
        ArrayList<Logger> loggerList = null;
        for (LogConfig config : configMap.values()) {
            if (config.getMustClass() == null || log.getMustClass() != config.getMustClass()) continue;
            if (loggerList == null) {
                loggerList = new ArrayList<Logger>();
            }
            if (level < config.getLevelMin() || level > config.getLevelMax()) continue;
            if (config.isConsoleOut()) {
                loggerList.add(config.getConsoleLogger());
            }
            if (!config.isFileOut()) continue;
            loggerList.add(config.getFileLogger());
        }
        return loggerList;
    }
}

