/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[遇见知启蒙，邂逅框架梦]
 * 
 * https://www.zhiqim.com/gitcan/zhiqim/zhiqim_kernel.htm
 *
 * This file is part of [zhiqim_kernel].
 * 
 * [zhiqim_kernel] is free software: you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * [zhiqim_kernel] is distributed in the hope that it will
 * be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with [zhiqim_kernel].
 * If not, see <http://www.gnu.org/licenses/>.
 */
package org.zhiqim.kernel.xml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

import org.zhiqim.kernel.extend.HashMapSO;
import org.zhiqim.kernel.extend.HashMapSS;
import org.zhiqim.kernel.extend.LinkedMapSO;
import org.zhiqim.kernel.extend.LinkedMapSS;
import org.zhiqim.kernel.extend.MapSO;
import org.zhiqim.kernel.extend.MapSS;
import org.zhiqim.kernel.extend.TreeMapSO;
import org.zhiqim.kernel.extend.TreeMapSS;
import org.zhiqim.kernel.util.Classes;
import org.zhiqim.kernel.xml.parser.ArrayParser;
import org.zhiqim.kernel.xml.parser.BaseParser;
import org.zhiqim.kernel.xml.parser.ListParser;
import org.zhiqim.kernel.xml.parser.MapParser;
import org.zhiqim.kernel.xml.parser.MapSOParser;
import org.zhiqim.kernel.xml.parser.MapSSParser;
import org.zhiqim.kernel.xml.parser.ObjectParser;

/**
 * Xml解析适配工厂类
 *
 * @version v1.1.2 @author zouzhigang 2015-8-21 新建与整理
 */
public class XmlFactory
{
    private HashMap<Class<?>, XmlParser> parserMap;
    
    public XmlFactory(Xml xmlMain)
    {
        parserMap = new HashMap<Class<?>, XmlParser>();
        
        //8种基本类型和字符串
        XmlParser baseParser = new BaseParser().set(xmlMain);
        parserMap.put(boolean.class, baseParser);
        parserMap.put(byte.class, baseParser);
        parserMap.put(char.class, baseParser);
        parserMap.put(short.class, baseParser);
        parserMap.put(int.class, baseParser);
        parserMap.put(long.class, baseParser);
        parserMap.put(float.class, baseParser);
        parserMap.put(double.class, baseParser);
        parserMap.put(Boolean.class, baseParser);
        parserMap.put(Byte.class, baseParser);
        parserMap.put(Character.class, baseParser);
        parserMap.put(Short.class, baseParser);
        parserMap.put(Integer.class, baseParser);
        parserMap.put(Long.class, baseParser);
        parserMap.put(Float.class, baseParser);
        parserMap.put(Double.class, baseParser);
        parserMap.put(String.class, baseParser);
        
        //数组类型，8种基本类型数组、字符串数组和对象数组
        XmlParser arrarParser = new ArrayParser().set(xmlMain);
        parserMap.put(boolean[].class, arrarParser);
        parserMap.put(byte[].class, arrarParser);
        parserMap.put(char[].class, arrarParser);
        parserMap.put(short[].class, arrarParser);
        parserMap.put(int[].class, arrarParser);
        parserMap.put(long[].class, arrarParser);
        parserMap.put(float[].class, arrarParser);
        parserMap.put(double[].class, arrarParser);
        parserMap.put(Boolean[].class, arrarParser);
        parserMap.put(Byte[].class, arrarParser);
        parserMap.put(Character[].class, arrarParser);
        parserMap.put(Short[].class, arrarParser);
        parserMap.put(Integer[].class, arrarParser);
        parserMap.put(Long[].class, arrarParser);
        parserMap.put(Float[].class, arrarParser);
        parserMap.put(Double[].class, arrarParser);
        parserMap.put(String[].class, arrarParser);
        
        //哈希表
        XmlParser mapParser = new MapParser().set(xmlMain);
        parserMap.put(Map.class, mapParser);
        parserMap.put(HashMap.class, mapParser);
        parserMap.put(ConcurrentMap.class, mapParser);
        parserMap.put(ConcurrentHashMap.class, mapParser);
        parserMap.put(Hashtable.class, mapParser);
        parserMap.put(LinkedHashMap.class, mapParser);
        parserMap.put(TreeMap.class, mapParser);
        
        //知启蒙哈希表
        XmlParser zmapsoParser = new MapSOParser().set(xmlMain);
        parserMap.put(MapSO.class, zmapsoParser);
        parserMap.put(HashMapSO.class, zmapsoParser);
        parserMap.put(LinkedMapSO.class, zmapsoParser);
        parserMap.put(TreeMapSO.class, zmapsoParser);
        
        XmlParser zmapssParser = new MapSSParser().set(xmlMain);
        parserMap.put(MapSS.class, zmapssParser);
        parserMap.put(HashMapSS.class, zmapssParser);
        parserMap.put(LinkedMapSS.class, zmapssParser);
        parserMap.put(TreeMapSS.class, zmapssParser);
        
        //链表
        XmlParser listParser = new ListParser().set(xmlMain);
        parserMap.put(Collection.class, listParser);
        parserMap.put(List.class, listParser);
        parserMap.put(ArrayList.class, listParser);
        parserMap.put(LinkedList.class, listParser);
        parserMap.put(Set.class, listParser);
        parserMap.put(HashSet.class, listParser);
        
        //最后放入通用对象和对象数组解析器
        parserMap.put(Object[].class, arrarParser);
        parserMap.put(Object.class, new ObjectParser().set(xmlMain));
    }
    
    public XmlParser getParser(Class<?> clazz)
    {
        XmlParser parser = parserMap.get(clazz);
        if (parser == null)
        {
            if (Classes.isCollection(clazz))
                parser = parserMap.get(List.class);
            else if (Classes.isMap(clazz))
                parser = parserMap.get(Map.class);
            else if (clazz.isArray())
                parser = parserMap.get(Object[].class);
            else
                parser = parserMap.get(Object.class);
        }
        
        return parser;
    }
}
