/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[遇见知启蒙，邂逅框架梦]
 * 
 * https://www.zhiqim.com/gitcan/zhiqim/zhiqim_kernel.htm
 *
 * This file is part of [zhiqim_kernel].
 * 
 * [zhiqim_kernel] is free software: you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * [zhiqim_kernel] is distributed in the hope that it will
 * be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with [zhiqim_kernel].
 * If not, see <http://www.gnu.org/licenses/>.
 */
package org.zhiqim.kernel.util.streams;

import java.io.IOException;
import java.io.OutputStream;

/**
 * 记录输入流长度的自定义输出流
 *
 * @version v1.0.0 @author zouzhigang 2017-6-14 新建与整理
 */
public class LengthOutputStream extends OutputStream
{
    private OutputStream out;
    private long length;

    public LengthOutputStream(OutputStream out)
    {
        this.out = out;
    }
    
    @Override
    public void write(int b) throws IOException
    {
        out.write(b);
        length++;
    }
    
    @Override
    public void write(byte[] b, int off, int len) throws IOException
    {
        out.write(b, off, len);
        length += len;
    }
    
    public long length()
    {
        return length;
    }
}
