/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[遇见知启蒙，邂逅框架梦]
 * 
 * https://www.zhiqim.com/gitcan/zhiqim/zhiqim_kernel.htm
 *
 * This file is part of [zhiqim_kernel].
 * 
 * [zhiqim_kernel] is free software: you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * [zhiqim_kernel] is distributed in the hope that it will
 * be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with [zhiqim_kernel].
 * If not, see <http://www.gnu.org/licenses/>.
 */
package org.zhiqim.kernel.util.mutables;

/**
 * 定义布尔型可变对象，用于引用传递时直接修改值
 *
 * @version v1.0.0 @author zhichenggang 2017-3-25 新建与整理
 */
public final class MObj<T>
{
    public T value;
    
    /*******************************************************/
    //两个构造函数
    /*******************************************************/
    
    public MObj()
    {
    }
    
    public MObj(T value)
    {
        this.value = value;
    }
    
    /*******************************************************/
    //常用方法
    /*******************************************************/
    
    public T val()
    {
        return value;
    }
    
    public MObj<T> val(T val)
    {
        this.value = val;
        return this;
    }
    
    public MObj<T> val(MObj<T> val)
    {
        this.value = val.value;
        return this;
    }
    
    /*******************************************************/
    //hashCode & equals & toString
    /*******************************************************/
    
    public int hashCode()
    {
        return value == null?0:value.hashCode();
    }

    public boolean equals(Object obj)
    {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        
        @SuppressWarnings("rawtypes")
        MObj other = (MObj) obj;
        if (value == null)
            return other.value == null;
        else
            return value.equals(other.value);
    }

    public String toString()
    {
        return String.valueOf(value);
    }
}
