/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[遇见知启蒙，邂逅框架梦]
 * 
 * https://www.zhiqim.com/gitcan/zhiqim/zhiqim_kernel.htm
 *
 * This file is part of [zhiqim_kernel].
 * 
 * [zhiqim_kernel] is free software: you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * [zhiqim_kernel] is distributed in the hope that it will
 * be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with [zhiqim_kernel].
 * If not, see <http://www.gnu.org/licenses/>.
 */
package org.zhiqim.kernel.util.mutables;

/**
 * 定义布尔型可变对象，用于引用传递时直接修改值
 *
 * @version v1.0.0 @author zhichenggang 2017-3-25 新建与整理
 */
public final class MBool
{
    public boolean value;
    
    /*******************************************************/
    //两个构造函数
    /*******************************************************/
    
    public MBool()
    {
    }
    
    public MBool(boolean value)
    {
        this.value = value;
    }
    
    /*******************************************************/
    //常用方法
    /*******************************************************/
    
    public boolean val()
    {
        return value;
    }
    
    public MBool val(boolean val)
    {
        this.value = val;
        return this;
    }
    
    public MBool val(MBool val)
    {
        this.value = val.value;
        return this;
    }
    
    /*******************************************************/
    //hashCode & equals & toString
    /*******************************************************/
    
    public int hashCode()
    {
        return value?1:0;
    }

    public boolean equals(Object obj)
    {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        MBool other = (MBool) obj;
        if (value != other.value)
            return false;
        return true;
    }

    public String toString()
    {
        return String.valueOf(value);
    }
}
