/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[遇见知启蒙，邂逅框架梦]
 * 
 * https://www.zhiqim.com/gitcan/zhiqim/zhiqim_kernel.htm
 *
 * This file is part of [zhiqim_kernel].
 * 
 * [zhiqim_kernel] is free software: you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * [zhiqim_kernel] is distributed in the hope that it will
 * be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with [zhiqim_kernel].
 * If not, see <http://www.gnu.org/licenses/>.
 */
package org.zhiqim.kernel.util.consts;

/**
 * 长整型定义，含值和描述，用于需要描述值时的常量或变量
 * 
 * @version v1.0.0 @author zouzhigang 2014-2-27 新建与整理
 */
public final class Lng
{
    private long value;
    private String desc;
    
    public Lng(long value, String desc)
    {
        this.value = value;
        this.desc = desc;
    }
    
    public Lng(String desc)
    {
        this.value = 0;
        this.desc = desc;
    }
    
    public long value()
    {
        return value;
    }
    
    public String desc()
    {
        return desc;
    }
    
    public boolean isSuccess()
    {
        return value == 0;
    }
    
    public String toString()
    {
        return new StringBuilder("Lng:[")
            .append("value=").append(value).append(";")
            .append("desc=").append(desc).append("]")
            .toString();
    }
}

