/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[遇见知启蒙，邂逅框架梦]
 * 
 * https://www.zhiqim.com/gitcan/zhiqim/zhiqim_kernel.htm
 *
 * This file is part of [zhiqim_kernel].
 * 
 * [zhiqim_kernel] is free software: you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * [zhiqim_kernel] is distributed in the hope that it will
 * be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with [zhiqim_kernel].
 * If not, see <http://www.gnu.org/licenses/>.
 */
package org.zhiqim.kernel.util;

import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.WatchService;

import org.zhiqim.kernel.annotation.AnAlias;

/**
 * 监视文件路径工具类
 * 
 * @version v1.0.0 @author zouzhigang 2014-2-27 新建与整理
 */
@AnAlias("Watchs")
public class Watchs
{
    /**
     * 获取文件系统监视服务
     * 
     * @return  监视服务
     */
    public static WatchService getWatchService()
    {
        try
        {
            return FileSystems.getDefault().newWatchService();
        }
        catch (IOException e)
        {
            throw Asserts.exception("该系统不支持文件监视服务[%s]", e, e.getMessage());
        }
    }
}
