/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[遇见知启蒙，邂逅框架梦]
 * 
 * https://www.zhiqim.com/gitcan/zhiqim/zhiqim_kernel.htm
 *
 * This file is part of [zhiqim_kernel].
 * 
 * [zhiqim_kernel] is free software: you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * [zhiqim_kernel] is distributed in the hope that it will
 * be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with [zhiqim_kernel].
 * If not, see <http://www.gnu.org/licenses/>.
 */
package org.zhiqim.kernel.util;

import org.zhiqim.kernel.annotation.AnAlias;

/**
 * 基本类型相关工具类
 *
 * @version v1.0.0 @author zouzhigang 2014-3-21 新建与整理
 */
@AnAlias("Types")
public class Types
{
    /************************************************************/
    //类判断
    /************************************************************/
    
    /** 
     * 是否八种基本类型，支持byte/short/int/long/float/double/boolean/char和对应的类Byte/Short....
     * 
     * @param clazz 类结构
     * @return =true/=false
     */
    public static boolean isPrimitive(Class<?> clazz)
    {
        if (clazz == null)
            return false;
        
        if (clazz == int.class || clazz == Integer.class)
            return true;
        else if (clazz == long.class || clazz == Long.class)
            return true;
        else if (clazz == boolean.class || clazz == Boolean.class)
            return true;
        else if (clazz == byte.class || clazz == Byte.class)
            return true;
        else if (clazz == short.class || clazz == Short.class)
            return true;
        else if (clazz == char.class || clazz == Character.class)
            return true;
        else if (clazz == float.class || clazz == Float.class)
            return true;
        else if (clazz == double.class || clazz == Double.class)
            return true;
        else
            return false;
    }
    
    /** 
     * 是否八种基本原型基本类型，仅支持byte/short/int/long/float/double/boolean/char
     * 
     * @param clazz 类结构
     * @return =true/=false
     */
    public static boolean isPrimitiveBase(Class<?> clazz)
    {
        if (clazz == null)
            return false;
        
        if (clazz == int.class)
            return true;
        else if (clazz == long.class)
            return true;
        else if (clazz == boolean.class)
            return true;
        else if (clazz == byte.class)
            return true;
        else if (clazz == short.class)
            return true;
        else if (clazz == char.class)
            return true;
        else if (clazz == float.class)
            return true;
        else if (clazz == double.class)
            return true;
        else
            return false;
    }
    
    /**
     * 把八种基本类型转为对象类型
     * 
     * @param clazz 类结构
     * @return 返回对象类型，如int.class转为Integer.class
     */
    public static Class<?> toObjectClass(Class<?> clazz)
    {
        if (clazz == int.class)
            return Integer.class;
        else if (clazz == long.class)
            return Long.class;
        else if (clazz == boolean.class)
            return Boolean.class;
        else if (clazz == byte.class)
            return Byte.class;
        else if (clazz == short.class)
            return Short.class;
        else if (clazz == char.class)
            return Character.class;
        else if (clazz == float.class)
            return Float.class;
        else if (clazz == double.class)
            return Double.class;
        else
            return clazz;
    }
    
    /**
     * 是否数值型(整数/小数)，支持byte/short/int/long/float/double
     * 
     * @param clazz 类结构
     * @return =true/=false
     */
    public static boolean isNumber(Class<?> clazz)
    {
        if (clazz == null)
            return false;
        
        if (clazz == int.class || clazz == Integer.class)
            return true;
        else if (clazz == long.class || clazz == Long.class)
            return true;
        else if (clazz == byte.class || clazz == Byte.class)
            return true;
        else if (clazz == short.class || clazz == Short.class)
            return true;
        else if (clazz == float.class || clazz == Float.class)
            return true;
        else if (clazz == double.class || clazz == Double.class)
            return true;
        else
            return false;
    }
    
    /**
     * 是否整数，区别于isInt，支持byte/short/int/long
     * 
     * @param clazz 类结构
     * @return =true/=false
     */
    public static boolean isInteger(Class<?> clazz)
    {
        if (clazz == null)
            return false;
        
        if (clazz == int.class || clazz == Integer.class)
            return true;
        else if (clazz == long.class || clazz == Long.class)
            return true;
        else if (clazz == byte.class || clazz == Byte.class)
            return true;
        else if (clazz == short.class || clazz == Short.class)
            return true;
        else
            return false;
    }
    
    /**
     * 是否小数，float和double
     * 
     * @param clazz 类结构
     * @return =true/=false
     */
    public static boolean isDecimal(Class<?> clazz)
    {
        if (clazz == null)
            return false;
        
        if (clazz == float.class || clazz == Float.class)
            return true;
        else if (clazz == double.class || clazz == Double.class)
            return true;
        else
            return false;
    }
    
    /**
     * 是否int，int/Integer
     * 
     * @param clazz 类结构
     * @return =true/=false
     */
    public static boolean isInt(Class<?> clazz)
    {
        if (clazz == null)
            return false;
        
        if (clazz == int.class || clazz == Integer.class)
            return true;
        else
            return false;
    }
    
    /**
     * 是否long，long/Long
     * 
     * @param clazz 类结构
     * @return =true/=false
     */
    public static boolean isLong(Class<?> clazz)
    {
        if (clazz == null)
            return false;
        
        if (clazz == long.class || clazz == Long.class)
            return true;
        else
            return false;
    }
    
    /**
     * 是否short，short/Short
     * 
     * @param clazz 类结构
     * @return =true/=false
     */
    public static boolean isShort(Class<?> clazz)
    {
        if (clazz == null)
            return false;
        
        if (clazz == short.class || clazz == Short.class)
            return true;
        else
            return false;
    }
    
    /**
     * 是否char，char/Character
     * 
     * @param clazz 类结构
     * @return =true/=false
     */
    public static boolean isChar(Class<?> clazz)
    {
        if (clazz == null)
            return false;
        
        if (clazz == char.class || clazz == Character.class)
            return true;
        else
            return false;
    }
    
    /**
     * 是否byte，byte/Byte
     * 
     * @param clazz 类结构
     * @return =true/=false
     */
    public static boolean isByte(Class<?> clazz)
    {
        if (clazz == null)
            return false;
        
        if (clazz == byte.class || clazz == Byte.class)
            return true;
        else
            return false;
    }
    
    /**
     * 是否float，float/Float
     * 
     * @param clazz 类结构
     * @return =true/=false
     */
    public static boolean isFloat(Class<?> clazz)
    {
        if (clazz == null)
            return false;
        
        if (clazz == float.class || clazz == Float.class)
            return true;
        else
            return false;
    }
    
    /**
     * 是否double，double/Double
     * 
     * @param clazz 类结构
     * @return =true/=false
     */
    public static boolean isDouble(Class<?> clazz)
    {
        if (clazz == null)
            return false;
        
        if (clazz == double.class || clazz == Double.class)
            return true;
        else
            return false;
    }
    
    /**
     * 是否boolean，boolean/Boolean
     * 
     * @param clazz 类结构
     * @return =true/=false
     */
    public static boolean isBoolean(Class<?> clazz)
    {
        if (clazz == null)
            return false;
        
        if (clazz == boolean.class || clazz == Boolean.class)
            return true;
        else
            return false;
    }
    
    /************************************************************/
    //对象判断
    /************************************************************/
    
    /**
     * 是否单一类型，支持null/byte/short/int/long/float/double/boolean/char/String
     * 
     * @param obj 对象
     * @return =true/=false
     */
    public static boolean isSingle(Object obj)
    {
        if (obj == null)
            return true;
        else if (isInt(obj))
            return true;
        else if (isLong(obj))
            return true;
        else if (isBoolean(obj))
            return true;
        else if (isByte(obj))
            return true;
        else if (isShort(obj))
            return true;
        else if (isChar(obj))
            return true;
        else if (isFloat(obj))
            return true;
        else if (isDouble(obj))
            return true;
        else if (isString(obj))
            return true;
        else
            return false;
    }
    
    /** 
     * 是否八种基本类型，支持byte/short/int/long/float/double/boolean/char
     * 
     * @param obj 对象
     * @return =true/=false
     */
    public static boolean isPrimitive(Object obj)
    {
        if (obj == null)
            return false;
        
        if (isInt(obj))
            return true;
        else if (isLong(obj))
            return true;
        else if (isBoolean(obj))
            return true;
        else if (isByte(obj))
            return true;
        else if (isShort(obj))
            return true;
        else if (isChar(obj))
            return true;
        else if (isFloat(obj))
            return true;
        else if (isDouble(obj))
            return true;
        else
            return false;
    }
    
    /**
     * 是否数值型(整数/小数)，支持byte/short/int/long/float/double
     * 
     * @param obj 对象
     * @return =true/=false
     */
    public static boolean isNumber(Object obj)
    {
        if (isInt(obj))
            return true;
        else if (isLong(obj))
            return true;
        else if (isByte(obj))
            return true;
        else if (isShort(obj))
            return true;
        else if (isFloat(obj))
            return true;
        else if (isDouble(obj))
            return true;
        else
            return false;
    }
    
    /**
     * 是否整数，区别于isInt，支持byte/short/int/long
     * 
     * @param obj 对象
     * @return =true/=false
     */
    public static boolean isInteger(Object obj)
    {
        if (isInt(obj))
            return true;
        else if (isLong(obj))
            return true;
        else if (isByte(obj))
            return true;
        else if (isShort(obj))
            return true;
        else
            return false;
    }
    
    /**
     * 是否小数，支持float/double
     * 
     * @param obj 对象
     * @return =true/=false
     */
    public static boolean isDecimal(Object obj)
    {
        if (isFloat(obj))
            return true;
        else if (isDouble(obj))
            return true;
        else
            return false;
    }

    /**
     * 是否为null
     * 
     * @param obj 对象
     * @return =true/=false
     */
    public static boolean isNull(Object obj)
    {
        return (obj == null);
    }
    
    /**
     * 是否为字符串
     * 
     * @param obj 对象
     * @return =true/=false
     */
    public static boolean isString(Object obj)
    {
        return (obj == null)?false:(obj instanceof String);
    }
    
    /**
     * 是否为int/Integer
     * 
     * @param obj 对象
     * @return =true/=false
     */
    public static boolean isInt(Object obj)
    {
        return (obj == null)?false:(obj instanceof Integer);
    }
    
    /**
     * 是否为long/Long
     * 
     * @param obj 对象
     * @return =true/=false
     */
    public static boolean isLong(Object obj)
    {
        return (obj == null)?false:(obj instanceof Long);
    }
    
    /**
     * 是否为short/Short
     * 
     * @param obj 对象
     * @return =true/=false
     */
    public static boolean isShort(Object obj)
    {
        return (obj == null)?false:(obj instanceof Short);
    }
    
    /**
     * 是否为byte/Byte
     * 
     * @param obj 对象
     * @return =true/=false
     */
    public static boolean isByte(Object obj)
    {
        return (obj == null)?false:(obj instanceof Byte);
    }

    /**
     * 是否为char/Character
     * 
     * @param obj 对象
     * @return =true/=false
     */
    public static boolean isChar(Object obj)
    {
        return (obj == null)?false:(obj instanceof Character);
    }
    
    /**
     * 是否为boolean/Boolean
     * 
     * @param obj 对象
     * @return =true/=false
     */
    public static boolean isBoolean(Object obj)
    {
        return (obj == null)?false:(obj instanceof Boolean);
    }

    /**
     * 是否为float/Float
     * 
     * @param obj 对象
     * @return =true/=false
     */
    public static boolean isFloat(Object obj)
    {
        return (obj == null)?false:(obj instanceof Float);
    }
    
    /**
     * 是否为double/Double
     * 
     * @param obj 对象
     * @return =true/=false
     */
    public static boolean isDouble(Object obj)
    {
        return (obj == null)?false:(obj instanceof Double);
    }
    
    /************************************************************/
    //对象数组判断
    /************************************************************/

    /**
     * 是否为数组
     * 
     * @param obj 对象
     * @return =true/=false
     */
    public static boolean isArray(Object obj)
    {
        return (obj == null)?false:obj.getClass().isArray();
    }
    
    /**
     * 是否为数组
     * 
     * @param clazz 类结构
     * @return =true/=false
     */
    public static boolean isArray(Class<?> clazz)
    {
        return (clazz == null)?false:clazz.isArray();
    }

    /**
     * 是否8种基本类型对象数组，支持byte/short/int/long/float/double/boolean/char
     * 
     * 这里只判断类int[],不去判断Integer[]，因为Integer[]可转化为Object[]，而int[]不行
     * 
     * @param clazz 类结构
     * @return =true/=false
     */
    public static boolean isPrimitiveArray(Class<?> clazz)
    {
        if (clazz == null)
            return false;
        
        if (clazz == int[].class)
            return true;
        else if (clazz == long[].class)
            return true;
        else if (clazz == boolean[].class)
            return true;
        else if (clazz == byte[].class)
            return true;
        else if (clazz == char[].class)
            return true;
        else if (clazz == short[].class)
            return true;
        else if (clazz == float[].class)
            return true;
        else if (clazz == double[].class)
            return true;
        else
            return false;
    }
    
    /**
     * 是否8种基本类型对象数组，支持byte/short/int/long/float/double/boolean/char
     * 
     * 这里只判断类int[],不去判断Integer[]，因为Integer[]可转化为Object[]，而int[]不行
     * 
     * @param obj 对象
     * @return =true/=false
     */
    public static boolean isPrimitiveArray(Object obj)
    {
        return (obj == null)?false:isPrimitiveArray(obj.getClass());
    }
    
    /**
     * 是否为int[]，注意Integer[]不是int[]
     * 
     * @param obj 对象
     * @return =true/=false
     */
    public static boolean isIntArray(Object obj)
    {
        return (obj == null)?false:obj.getClass() == int[].class;
    }
    
    /**
     * 是否为long[]，注意Long[]不是long[]
     * 
     * @param obj 对象
     * @return =true/=false
     */
    public static boolean isLongArray(Object obj)
    {
        return (obj == null)?false:obj.getClass() == long[].class;
    }
    
    /**
     * 是否为short[]，注意Short[]不是short[]
     * 
     * @param obj 对象
     * @return =true/=false
     */
    public static boolean isShortArray(Object obj)
    {
        return (obj == null)?false:obj.getClass() == short[].class;
    }
    
    /**
     * 是否为byte[]，注意Byte[]不是byte[]
     * 
     * @param obj 对象
     * @return =true/=false
     */
    public static boolean isByteArray(Object obj)
    {
        return (obj == null)?false:obj.getClass() == byte[].class;
    }
    
    /**
     * 是否为char[]，注意Character[]不是char[]
     * 
     * @param obj 对象
     * @return =true/=false
     */
    public static boolean isCharArray(Object obj)
    {
        return (obj == null)?false:obj.getClass() == char[].class;
    }
    
    /**
     * 是否为float[]，注意Float[]不是float[]
     * 
     * @param obj 对象
     * @return =true/=false
     */
    public static boolean isFloatArray(Object obj)
    {
        return (obj == null)?false:obj.getClass() == float[].class;
    }
    
    /**
     * 是否为double[]，注意Double[]不是double[]
     * 
     * @param obj 对象
     * @return =true/=false
     */
    public static boolean isDoubleArray(Object obj)
    {
        return (obj == null)?false:obj.getClass() == double[].class;
    }
    
    /**
     * 是否为boolean[]，注意Boolean[]不是boolean[]
     * 
     * @param obj 对象
     * @return =true/=false
     */
    public static boolean isBooleanArray(Object obj)
    {
        return (obj == null)?false:obj.getClass() == boolean[].class;
    }
}
