/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[遇见知启蒙，邂逅框架梦]
 * 
 * https://www.zhiqim.com/gitcan/zhiqim/zhiqim_kernel.htm
 *
 * This file is part of [zhiqim_kernel].
 * 
 * [zhiqim_kernel] is free software: you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * [zhiqim_kernel] is distributed in the hope that it will
 * be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with [zhiqim_kernel].
 * If not, see <http://www.gnu.org/licenses/>.
 */
package org.zhiqim.kernel.util;

import java.util.Map;

import org.zhiqim.kernel.annotation.AnAlias;

/**
 * 哈希表工具类
 *
 * @version v1.0.0 @author zouzhigang 2014-3-21 新建与整理
 */
@AnAlias("Maps")
public class Maps
{
    /**
     * 给定一个哈希表和键，取值
     * 
     * @param map   哈希表
     * @param key   键
     * @return      键对应的值
     */
    public static Object get(Object map, Object key)
    {
        Asserts.as(map instanceof Map?null:"目标对象不是Map，方法不支持");
        
        return ((Map<?, ?>)map).get(key);
    }
    
    /**
     * 给定一个哈希表和键，取值
     * 
     * @param map   哈希表
     * @param key   键
     * @return      键对应的值
     */
    public static Object get(Map<?, ?> map, Object key)
    {
        return map.get(key);
    }
}
