/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[遇见知启蒙，邂逅框架梦]
 * 
 * https://www.zhiqim.com/gitcan/zhiqim/zhiqim_kernel.htm
 *
 * This file is part of [zhiqim_kernel].
 * 
 * [zhiqim_kernel] is free software: you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * [zhiqim_kernel] is distributed in the hope that it will
 * be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with [zhiqim_kernel].
 * If not, see <http://www.gnu.org/licenses/>.
 */
package org.zhiqim.kernel.util;

import org.zhiqim.kernel.annotation.AnAlias;

/**
 * 整型相关工具类
 *
 * @version v1.0.0 @author zouzhigang 2014-2-27 新建与整理
 */
@AnAlias("Ints")
public class Ints
{
    /** 字符串转换为int,异常不处理 注:默认10进制 */
    public static int toInt(String s)
    {
        return Integer.parseInt(s);
    }

    /** 字符串转换为int 如果异常则返回缺省值 */
    public static int toInt(String s, int defaultValue)
    {
        try{return Integer.parseInt(s);}catch(NumberFormatException e){return defaultValue;}
    }
    
    /** 对象转换为int 如果异常则返回缺省值 */
    public static int toInt(Object o, int defaultValue)
    {
        if (o == null)
            return defaultValue;
        else if (o instanceof Integer)
            return (Integer)o;
        else if (o instanceof Long)
            return (int)((long)(Long)o);
        else if (o instanceof String)
            return toInt((String)o, defaultValue);
        else
            return defaultValue;
    }
    
    /****************************************************************/
    //十六进制
    /****************************************************************/
    
    /** 字符串转换为int,异常不处理 注:默认16进制 */
    public static int toIntByHex(String s)
    {
        return Integer.parseInt(s, 16);
    }
    
    /** 字符串转换为int,异常不处理 注:默认16进制 */
    public static int toIntByHex(byte[] b)
    {
        return Integer.parseInt(new String(b), 16);
    }
    
    public static String toStringHex(int i)
    {
        return Integer.toString(i, 16);
    }
    
    /** 转化为字节数组（根据本身长度） */
    public static byte[] toBytesHex(int i)
    {
        String hex = Integer.toString(i, 16);
        return Bytes.toBytesASCII(hex);
    }
    
    /** 转化为4字节（最大65535）的字节数组 */
    public static byte[] toBytesHex4(int i)
    {
        String hex = Integer.toString(i, 16);
        return Bytes.toBytesASCII(Strings.prefixZero(hex, 4));
    }
    
    /** 转化为8字节的字节数组 */
    public static byte[] toBytesHex8(int i)
    {
        String hex = Integer.toString(i, 16);
        return Bytes.toBytesASCII(Strings.prefixZero(hex, 8));
    }
    
    /****************************************************************/
    //其他方法
    /****************************************************************/
    
    public static int length(int val)
    {
        if (val == 0)
            return 1;
        
        boolean isNegative = false; 
        if (val < 0)
        {//负数变为正数
            val = -val;
            isNegative = true;
        }
        
        int len = 0;
        for (int i=val;i!=0;i/=10)
        {//对值作10的整除
            len++;
        }
        
        return isNegative?len+1:len;
    }
    
    public static int getMaxInt(int length)
    {
        if (length >= 10)
            return 0x7FFFFFFF;
        
        if (length <= 0)
            return 9;
        
        String maxString = "999999999".substring(0, length);
        return toInt(maxString);
    }
    
    public static int compareUnsigned(int a, int b)
    {//先去掉符号位比，相等再比符号位
        int cmp = (a >>> 1) - (b >>> 1);
        if (cmp != 0)
            return cmp>0?1:-1;
            
        cmp = ((a & 1) - (b & 1));
        return cmp>0?1:(cmp<0?-1:0);
    }
}
