/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[遇见知启蒙，邂逅框架梦]
 * 
 * https://www.zhiqim.com/gitcan/zhiqim/zhiqim_kernel.htm
 *
 * This file is part of [zhiqim_kernel].
 * 
 * [zhiqim_kernel] is free software: you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * [zhiqim_kernel] is distributed in the hope that it will
 * be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with [zhiqim_kernel].
 * If not, see <http://www.gnu.org/licenses/>.
 */
package org.zhiqim.kernel.util;

import java.util.UUID;

import org.zhiqim.kernel.annotation.AnAlias;
import org.zhiqim.kernel.enumerated.LetterCase;
import org.zhiqim.kernel.util.seqs.Sequence;

/**
 * ID编号相关工具类
 *
 * @version v1.0.0 @author zouzhigang 2014-2-27 新建与整理
 * @version v1.4.0 @author zouzhigang 2018-1-1  增加long13方法支持条型码
 * @version v1.4.1 @author zouzhigang 2018-4-20 修改UUID默认为小写，增加指定大小写参数
 */
@AnAlias("Ids")
public class Ids
{
    private static final Sequence sequence3 = new Sequence(3);
    private static final Sequence sequence4 = new Sequence(4);
    private static final Sequence sequence5 = new Sequence(5);
    
    /***************************************************************************************************/
    //32位通用唯一识别码字符串（Universally Unique Identifier）
    /***************************************************************************************************/
    
    /** 32位通用唯一识别码 */
    public static final String uuid()
    {
        return UUID.randomUUID().toString().replaceAll("-", "");
    }
    
    /** 32位通用唯一识别码，指定大小写 */
    public static final String uuid(LetterCase letter)
    {
        return letter.toCase(uuid(), LetterCase.LOWER);
    }
    
    /***************************************************************************************************/
    //16位唯一长整数，由12位秒级+4位序列号,JS支持最大值16位（9007199254740992），所以16位在JSON中比较合适
    /***************************************************************************************************/
    
    /** 16位唯一长整数 */
    public static final long longId()
    {
        return longId(sequence4);
    }
    
    /** 16位唯一长整数，指定长度为4位数的序列对象 */
    public static final long longId(Sequence sequence4)
    {
        long time = Longs.toLong(DateTimes.getDateTime12String());
        int seq = sequence4.nextInt();
        
        return time * 10000 + seq;
    }
    
    /***************************************************************************************************/
    //13位唯一长整数，由2位年数+当年8位秒数+3位序列号，支持条形码，有效至2099年
    /***************************************************************************************************/
    
    /** 13位唯一长整数 */
    public static final long longId13()
    {
        return longId13(sequence3);
    }
    
    /** 13位唯一长整数，指定长度为3位数的序列对象 */
    public static final long longId13(Sequence sequence3)
    {
        int year = DateTimes.getCurrentYear();
        long yearTime = DateTimes.toLong(year, 1, 1, 0, 0, 0) / 1000;
        long currtime = System.currentTimeMillis() / 1000;
        
        int seq = sequence3.nextInt();
        return (year % 100) * 100000000000L + (currtime - yearTime) * 1000 + seq;
    }
    
    /** 13位唯一长整数 */
    public static final long longId13_4()
    {
        return longId13_4(sequence4);
    }
    
    /** 13位唯一长整数，指定长度为4位数的序列对象，对一年时间/3.16224 */
    public static final long longId13_4(Sequence sequence4)
    {
        int year = DateTimes.getCurrentYear();
        long yearTime = DateTimes.toLong(year, 1, 1, 0, 0, 0) / 1000;
        long currtime = System.currentTimeMillis() / 1000;
        
        int seq = sequence4.nextInt();
        return (year % 100) * 100000000000L + (long)((currtime - yearTime) / 3.16224) * 10000 + seq;
    }
    
    /**********************************************************************************************/
    //19位唯一长整数，由14位秒级+5位序列号，有效至9223年，long型最大值为19位（9223372036854775807）
    /**********************************************************************************************/
    
    /** 19位唯一长整数 */
    public static final long longId19()
    {
        return longId19(sequence5);
    }
    
    /** 19位唯一长整数，指定长度为5位数的序列对象 */
    public static final long longId19(Sequence sequence5)
    {
        long time = Longs.toLong(DateTimes.getDateTime14String());
        int seq = sequence5.nextInt();
        
        return time * 100000 + seq;
    }
}
