/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[遇见知启蒙，邂逅框架梦]
 * 
 * https://www.zhiqim.com/gitcan/zhiqim/zhiqim_kernel.htm
 *
 * This file is part of [zhiqim_kernel].
 * 
 * [zhiqim_kernel] is free software: you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * [zhiqim_kernel] is distributed in the hope that it will
 * be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with [zhiqim_kernel].
 * If not, see <http://www.gnu.org/licenses/>.
 */
package org.zhiqim.kernel.util;

import java.util.Map.Entry;

import org.zhiqim.kernel.annotation.AnAlias;
import org.zhiqim.kernel.extend.MapSO;

/**
 * HTML扩展工具类
 *
 * @version v1.0.0 @author zouzhigang 2014-2-27 新建与整理
 */
@AnAlias("Htmls")
public class Htmls extends Htmlx
{
    /**************************************************************************************/
    //格式化
    /**************************************************************************************/
    
    /**
     * 标准HTML格式化，对<>格式化，保证浏览器解释成字符串而不是代码，且JSON不受影响
     * 
     * @param html 要格式化的字符串
     * @return 格式化后的字符串
     */
    public static String format(String html)
    {
        return (html == null)?"":html.replaceAll("<", "&lt;").replaceAll(">", "&gt;");
    }
    
    /**
     * 全部HTML格式化，把&,\',\",<,>替换成&amp;,&apos;,&quot;,&gt;和&lt;，保证浏览器解释成字符串，而不是代码
     * 
     * @param html 要格式化的字符串
     * @return 格式化后的字符串
     */
    public static String formatAll(String html)
    {
        if (html == null)
            return "";

        html = html.replaceAll("&", "&amp;");
        //把&放在第一个处理，防止转换的&再被转换一次
        html = html.replaceAll("\'", "&apos;");
        html = html.replaceAll("\"", "&quot;");
        html = html.replaceAll("<", "&lt;");
        html = html.replaceAll(">", "&gt;");
        return html;
    }
    
    /**************************************************************************************/
    //过滤
    /**************************************************************************************/
    
    /**
     * HTTP等传输时过滤HTML标签，但支持JSON格式
     * 
     * @param str   原字符串
     * @return      过滤<>后的字符串
     */
    public static String filter(String html)
    {
        return (html == null)?null:html.replaceAll("<", "").replaceAll(">", "");
    }
    
    /**
     * HTTP等传输时过滤可能导致注入的HTML/JS/JSON格式
     * 
     * @param str   原字符串
     * @return      过滤<>;'"&后的字符串
     */
    public static String filterAll(String str)
    {
        if (str == null)
            return null;
        
        str = str.trim();
        str = str.replaceAll(">", "");
        str = str.replaceAll("<", "");
        str = str.replaceAll(";", "");
        str = str.replaceAll("\'", "");
        str = str.replaceAll("\"", "");
        str = str.replaceAll("&", "");
        
        return str;
    }
    
    /**
     * HTTP等传输时过滤可能导致注入的漏洞
     * 
     * @param strs  原字符串数组
     * @return      过滤<>;'"&的字符串数组
     */
    public static String[] filterAll(String[] strs)
    {
        if (strs == null)
            return null;
        
        String[] news = new String[strs.length];
        for (int i=0;i<strs.length;i++)
        {
            news[i] = filterAll(strs[i]);
        }
        
        return news;
    }
    
    /**************************************************************************************/
    //表单
    /**************************************************************************************/
    
    /**
     * 生成独立表单HTML形式，自动提交
     * 
     * @param id        表单编号
     * @param action    表单目标地址
     * @param method    表单提交方法 GET|POST
     * @param paramMap  表单参数表
     * 
     * @return 提交表单HTML文本
     */
    public static String buildForm(String id, String action, String method, MapSO paramMap) 
    {
        //待请求参数数组
        StringBuilder strb = new StringBuilder();
        strb.append("<form")
            .append(" id=\"").append(id).append("\"")
            .append(" name=\"").append(id).append("\"")
            .append(" action=\"").append(action).append("\"")
            .append(" method=\"").append(method).append("\">");

        for (Entry<String, Object> entry : paramMap.entrySet()) 
        {
            String name = entry.getKey();
            Object value = entry.getValue();

            strb.append("<input type=\"hidden\" name=\"").append(name).append("\" value=\"").append(value).append("\"/>");
        }

        //submit按钮控件不含name属性，以保证服务器获取时全部为参数
        strb.append("<input type=\"submit\" value=\"submit\" style=\"display:none;\">");
        strb.append("</form>");
        strb.append("<script>document.forms['").append(id).append("'].submit();</script>");

        return strb.toString();
    }
}
