/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[遇见知启蒙，邂逅框架梦]
 * 
 * https://www.zhiqim.com/gitcan/zhiqim/zhiqim_kernel.htm
 *
 * This file is part of [zhiqim_kernel].
 * 
 * [zhiqim_kernel] is free software: you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * [zhiqim_kernel] is distributed in the hope that it will
 * be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with [zhiqim_kernel].
 * If not, see <http://www.gnu.org/licenses/>.
 */
package org.zhiqim.kernel.util;

import org.zhiqim.kernel.annotation.AnAlias;

/**
 * 位运算工具类
 * 1.左为高，右为低
 * 2.高1位表示左边第一位=低8位
 *
 * @version v1.0.0 @author zouzhigang 2014-3-21 新建与整理
 */
@AnAlias("Bits")
public class Bits
{
    /**
     * 判断字节指定的位上是不是0
     * 
     * @param ib    字节
     * @param hpos  高第1-8之间
     * @return      =true表示是，=false表示否
     */
    public static boolean isZero(byte ib, int hpos)
    {
        return ((ib >>> (8-hpos)) & 0x00000001) == 0;
    }
    
    /**
     * 判断字节指定的位上是不是1
     * 
     * @param ib    字节
     * @param hpos  高第1-8之间
     * @return      =true表示是，=false表示否
     */
    public static boolean isOne(byte ib, int hpos)
    {
        return ((ib >>> (8-hpos)) & 0x00000001) == 1;
    }
    
    /**
     * 把有符号字节转换成无符号整数
     * 
     * @param ib    字节
     * @return      无符号整数
     */
    public static int unsigned(byte ib)
    {
        return ib & 0xFF;
    }
}
