/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[遇见知启蒙，邂逅框架梦]
 * 
 * https://www.zhiqim.com/gitcan/zhiqim/zhiqim_kernel.htm
 *
 * This file is part of [zhiqim_kernel].
 * 
 * [zhiqim_kernel] is free software: you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * [zhiqim_kernel] is distributed in the hope that it will
 * be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with [zhiqim_kernel].
 * If not, see <http://www.gnu.org/licenses/>.
 */
package org.zhiqim.kernel.transaction;

import org.zhiqim.kernel.util.Arrays;

/**
 * 事务抽象类定义，包括提交、回滚和关闭状态
 *
 * @version v1.0.0 @author zouzhigang 2014-3-21 新建与整理
 */
public abstract class TransactionAbstracter implements Transaction
{
    protected String id;
    protected boolean isCommited = false;
    protected boolean isRollbacked = false;
    protected boolean isClosed = false;
    
    /** 要求提供id或id数组字符串，用于关闭 */
    public TransactionAbstracter(String id)
    {
        this.id = id;
    }
    
    /** 设置事务为已提交状态 */
    public void setCommitted()
    {
        isCommited = true;
        isRollbacked = false;
    }
    
    /** 设置事务为已回滚状态 */
    public void setRollbacked()
    {
        isCommited = false;
        isRollbacked = true;
    }
    
    /** 设置事务为已关闭状态 */
    public void setClosed()
    {
        isClosed = true;
        TransactionManager.closeTransaction(Arrays.toStringArray(id));
    }
    
    /** 获取事务服务编号 */
    public String getId()
    {
        return id;
    }
    
    /** 是否已提交 */
    public boolean isCommitted()
    {
        return isCommited;
    }
    
    /** 是否已回滚 */
    public boolean isRollbacked()
    {
        return isRollbacked;
    }
    
    /** 是否已关闭 */
    public boolean isClosed()
    {
        return isClosed;
    }
}
